package com.yeejoin.amos.boot.module.cylinder.flc.biz.controller;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.module.cylinder.api.entity.PageParam;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.TzCarcylRegDto;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.TzCarcylTraceDto;
import com.yeejoin.amos.boot.module.cylinder.flc.api.service.ITzCarcylService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

@RestController
@Api(tags = "车用气瓶Api")
@RequestMapping(value = "/carcyl")
public class CarCylController {

    @Autowired
    private ITzCarcylService iTzCarcylService;

    /**
     * 列表分页查询
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/userInfo/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "get", value = "列表分页查询", notes = "列表分页查询")
    public ResponseModel<IPage<TzCarcylRegDto>> getUserInfo(PageParam pageParam, TzCarcylRegDto tzCarcylRegDto, String key){
        return ResponseHelper.buildResponse(iTzCarcylService.page(pageParam,tzCarcylRegDto,key));
    }

    /**
     * 追溯详情查询
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/traceInfo/{sequenceNbr}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "get", value = "列表分页查询", notes = "列表分页查询")
    public ResponseModel<TzCarcylTraceDto> getTraceInfo(@PathVariable(value = "sequenceNbr") String sequenceNbr){
        return ResponseHelper.buildResponse(iTzCarcylService.getTrace(sequenceNbr));
    }
}
