package com.yeejoin.amos.boot.module.jg.api.enums;

/**
 * 业务类型枚举
 */
public enum BusinessTypeEnum {

    EQUIPMENT_MANAGEMENT(101,"设备管理"),

    INSTALLATION_NOTIFICATION(102,"安装告知"),

    INSPECTION_DETECTION(103,"检验检测"),

    MAINTENANCE_RECORD(104,"维保备案"),

    USAGE_REGISTRATION(105,"使用登记"),

    EQUIPMENT_HANDOVER(106,"设备移交"),

    MODIFICATION_NOTIFICATION(107,"改造告知"),

    MAINTENANCE_NOTIFICATION(108,"维修告知"),

    ADVICE_REMOVAL(109,"移装告知"),

    CHANGE_REGISTRATION(110,"变更登记"),

    ELEVATOR_STOP(111,"电梯停运"),

    ELEVATOR_ACTIVATION(112,"电梯启用"),

    ELEVATOR_DEREGISTRATION(113,"电梯注销");

    private final int code;

    private final String name;

    BusinessTypeEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static String getNameByType(Long code) {
        String name = null;
        for (BusinessTypeEnum enumOne : BusinessTypeEnum.values()) {
            if (enumOne.getCode() == code) {
                name = enumOne.getName();
                break;
            }
        }
        return name;
    }

    public int getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
