package com.yeejoin.amos.boot.module.jg.api.enums;

import com.yeejoin.amos.boot.module.ymt.api.enums.EquimentEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 施工信息枚举
 *
 * @author Provence
 * @version v1.0
 * @date 2023/12/18 11:01
 */
@AllArgsConstructor
@Getter
public enum ConstructionEnum {

    INSTALL("安装",6030),
    RENOVATION("改造",6031),
    REPAIR("修理",6032);

    String name;
    Integer code;

    public static Map<Integer,String> getName=new HashMap<>();
    public static Map<String,Integer> getCode=new HashMap<>();

    static {
        for (ConstructionEnum e : ConstructionEnum.values()){
            getName.put(e.code, e.name);
            getCode.put(e.name, e.code);
        }

    }
}
