package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.yeejoin.amos.boot.module.jg.api.common.BaseException;
import com.yeejoin.amos.boot.module.jg.api.entity.JgEquipTransfer;
import com.yeejoin.amos.component.feign.utils.FeignUtil;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.*;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgEquipTransferServiceImpl;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.JgEquipTransferDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 设备移交
 *
 * @author system_generator
 * @date 2023-12-20
 */
@RestController
@Api(tags = "设备移交Api")
@RequestMapping(value = "/jg-equip-transfer")
public class JgEquipTransferController extends BaseController {

    @Autowired
    JgEquipTransferServiceImpl jgEquipTransferServiceImpl;

    /**
     * 新增设备移交
     *
     * @return String
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增设备移交", notes = "新增设备移交")
    public ResponseModel<Object> save(@RequestParam("submitType") String submitType, @RequestBody JgEquipTransferDto model) {
        jgEquipTransferServiceImpl.saveOrUpdateModel(submitType, model, getSelectedOrgInfo());
        return ResponseHelper.buildResponse("ok");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/update")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新设备移交", notes = "根据sequenceNbr更新设备移交")
    public ResponseModel<JgEquipTransferDto> updateBySequenceNbr(@RequestParam("submitType") String submitType,
                                                                 @RequestBody JgEquipTransferDto equipTransferDto,
                                                                 @RequestParam(value = "op", required = false) String op) {
        return ResponseHelper.buildResponse(jgEquipTransferServiceImpl.updateEquipTransfer(submitType, equipTransferDto, op));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/delete")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除设备移交", notes = "根据sequenceNbr删除设备移交")
    public ResponseModel<Boolean> deleteBySequenceNbr(@RequestParam(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgEquipTransferServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 批量删除
     *
     * @param ids 主键
     * @return ResponseModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/deleteBatch")
    @ApiOperation(httpMethod = "DELETE", value = "批量删除设备移交", notes = "批量删除设备移交")
    public ResponseModel<Object> deleteBySequenceNbr(@RequestParam("ids") String ids) {
        if (StringUtils.isEmpty(ids)) {
            throw new RuntimeException("请选择需要删除的行！");
        }
        return ResponseHelper.buildResponse(jgEquipTransferServiceImpl.removeByIds(Arrays.asList(ids.split(","))));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return Map
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/details")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个设备移交", notes = "根据sequenceNbr查询单个设备移交")
    public ResponseModel<Map<String, Object>> selectOne(@RequestParam("sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgEquipTransferServiceImpl.queryBySequenceNbr(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param size    每页大小
     * @return Page
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/page")
    @ApiOperation(httpMethod = "POST", value = "设备移交分页查询", notes = "设备移交分页查询")
    public ResponseModel<Page<JgEquipTransferDto>> queryForPage(@RequestParam(value = "current") int current,
                                                                @RequestParam(value = "size") int size,
                                                                @ApiParam(value = "类型：useUnit-使用单位、installUnit-施工单位", required = true) @RequestParam(value = "type", defaultValue = "useUnit") String type,
                                                                @RequestBody(required = false) JgEquipTransferDto dto) {
        Page<JgEquipTransferDto> page = new Page<>(current, size);
        return ResponseHelper.buildResponse(jgEquipTransferServiceImpl.queryForJgEquipTransferPage(page, dto, type, getSelectedOrgInfo()));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getCodeAndName")
    @ApiOperation(httpMethod = "GET", value = "获取当前登录用户所在公司code和公司名称", notes = "获取当前登录用户所在公司code和公司名称")
    public ResponseModel<Map<String, Object>> getCodeAndName() {

        List<CompanyModel> companyModels = FeignUtil.remoteCall(() -> Privilege.companyClient.queryListByChild(RequestContext.getExeUserId()));
        if (companyModels.isEmpty()) {
            throw new BaseException("未指定人员归属单位信息");
        }
        String companyType = companyModels.get(0).getCompanyType();
        String companyCode = companyModels.get(0).getCompanyCode();
        String companyName = companyModels.get(0).getCompanyName();
        Map<String, Object> map = new HashMap<>();
        if("个人主体".equals(companyType)){
            map.put("useUnitName", companyName.split("_")[1]);
            map.put("useUnitCreditCode", companyCode.split("_")[1]);
            map.put("companyType", "person");
        } else {
            map.put("useUnitName", companyName);
            map.put("useUnitCreditCode", companyCode);
            map.put("companyType", "company");
        }
        return ResponseHelper.buildResponse(map);
    }
}

