package com.yeejoin.amos.boot.module.jg.biz.controller;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.boot.module.jg.api.dto.JgTransferNoticeDto;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgTransferNoticeServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 移装告知
 *
 * @author system_generator
 * @date 2023-12-12
 */
@RestController
@Api(tags = "移装告知工作流相关Api")
@RequestMapping(value = "/jg-transfer-workflow")
public class JgTransferNoticeByWorkFlowController {


    @Autowired
    JgTransferNoticeServiceImpl jgTransferNoticeService;

    /**
     * 提交
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/submit")
    @ApiOperation(httpMethod = "POST", value = "移装告知提交", notes = "移装告知提交")
    public ResponseModel<JgTransferNoticeDto> submit(@RequestBody JgTransferNoticeDto model, String op) {
        // TODO 发起移装告知流程
        // jgInstallationNoticeServiceImpl.submit(model, op);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 撤销
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/cancel")
    @ApiOperation(httpMethod = "POST", value = "移装告知撤销", notes = "移装告知撤销")
    public ResponseModel<JgTransferNoticeDto> cancel(@RequestBody Map<String, Object> model) {
        JgTransferNoticeDto installationInfo = BeanUtil.mapToBean(((LinkedHashMap) model.get("transferNoticeInfo")), JgTransferNoticeDto.class, true);
        if (Objects.isNull(installationInfo)) {
            throw new IllegalArgumentException("参数transferNoticeInfo不能为空");
        }
        jgTransferNoticeService.cancel(installationInfo);
        return ResponseHelper.buildResponse(installationInfo);
    }

    /**
     * 受理
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/accept")
    @ApiOperation(httpMethod = "POST", value = "移装告知受理", notes = "移装告知受理")
    public ResponseModel<JgTransferNoticeDto> accept(@RequestBody Map<String, Object> model, String op) {
        // TODO 受理移装告知流程
        LinkedHashMap model1 = (LinkedHashMap)model.get("model");
        LinkedHashMap installationInfo = (LinkedHashMap)model1.get("transferNoticeInfo");
        JgTransferNoticeDto JgTransferNoticeDto = JSON.parseObject(JSON.toJSONString(installationInfo), JgTransferNoticeDto.class);
        jgTransferNoticeService.accept(JgTransferNoticeDto,op);
        return ResponseHelper.buildResponse(null);
    }
}
