package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jg.api.entity.*;
import com.yeejoin.amos.boot.module.jg.api.enums.EquipTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.enums.WorkFlowStatusEnum;
import com.yeejoin.amos.boot.module.jg.api.mapper.*;
import com.yeejoin.amos.boot.module.jg.api.service.IJgChangeRegistrationReformService;
import com.yeejoin.amos.boot.module.jg.api.dto.JgChangeRegistrationReformDto;
import com.yeejoin.amos.boot.module.jg.biz.feign.TzsServiceFeignClient;
import com.yeejoin.amos.boot.module.jg.biz.service.IIdxBizJgRegisterInfoService;
import com.yeejoin.amos.boot.module.jg.flc.api.fegin.WorkFlowFeignService;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgTechParamsElevator;
import com.yeejoin.amos.boot.module.ymt.api.entity.InspectionDetectionInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.OtherInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.UseInfo;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.*;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.workflow.Workflow;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowStartDTO;
import com.yeejoin.amos.feign.workflow.model.AjaxResult;
import com.yeejoin.amos.feign.workflow.model.TaskResultDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 改造变更登记服务实现类
 *
 * @author system_generator
 * @date 2023-12-20
 */
@Service
public class JgChangeRegistrationReformServiceImpl extends BaseService<JgChangeRegistrationReformDto, JgChangeRegistrationReform, JgChangeRegistrationReformMapper> implements IJgChangeRegistrationReformService {
    @Autowired
    IIdxBizJgRegisterInfoService idxBizJgRegisterInfoService;
    @Autowired
    WorkFlowFeignService workFlowFeginService;

    @Autowired
    TzsServiceFeignClient tzsServiceFeignClient;
    @Autowired
    RedisUtils redisUtils;
    @Autowired
    private UseInfoMapper useInfoMapper;
    @Autowired
    private InspectionDetectionInfoMapper inspectionDetectionInfoMapper;
    @Autowired
    private OtherInfoMapper otherInfoMapper;
    //改造登记关系表mapper
    @Autowired
    private JgChangeRegistrationReformEqMapper jgChangeRegistrationReformEqMapper;
    //移装登记关系表
    @Autowired
    private JgChangeRegistrationTransferEqMapper jgChangeRegistrationTransferEqMapper;
    @Autowired
    private IdxBizJgTechParamsElevatorMapper idxBizJgTechParamsElevatorMapper;
    @Autowired
    private JgRegistrationHistoryMapper jgRegistrationHistoryMapper;
    //使用登记关系表mapper
    @Autowired
    private JgUseRegistrationEqMapper jgUseRegistrationEqMapper;
    @Autowired
    private IdxBizJgRegisterInfoMapper idxBizJgRegisterInfoMapper;
    @Autowired
    private IdxBizJgOtherInfoMapper idxBizJgOtherInfoMapper;
    //单位变更登记关系表mapper
    @Autowired
    private JgChangeRegistrationUnitEqMapper jgChangeRegistrationUnitEqMapper;
    //更名变更登记关系表mapper
    @Autowired
    private JgChangeRegistrationNameEqMapper jgChangeRegistrationNameEqMapper;

    /**
     * 分页查询
     */
    public Page<Map<String, Object>> getList(JgChangeRegistrationReformDto dto, Page<Map<String, Object>> page, List<String> roleIds) {
        Page<Map<String, Object>> listPage = this.baseMapper.getListPage(page, dto, roleIds);
        return listPage;
    }

    public Page<Map<String, Object>> getEquipList(Page<Map<String, Object>> page, String factoryNum, String equList, String equCategory) {
        return this.baseMapper.getEquipListPage(page, factoryNum, equList, equCategory);
    }

    @Transactional
    public void save(JSONObject map) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        UseInfo useInfo = new UseInfo();
        BeanUtil.copyProperties(map, useInfo);
        String equipId  = map.get("record").toString();
        LambdaQueryWrapper<UseInfo> lambda = new QueryWrapper<UseInfo>().lambda();
        lambda.eq(UseInfo::getRecord,equipId);
        // 更新使用信息
        useInfoMapper.update(useInfo, lambda);
        InspectionDetectionInfo inspectionDetectionInfo = new InspectionDetectionInfo();
        BeanUtil.copyProperties(map, inspectionDetectionInfo);
        LambdaQueryWrapper<InspectionDetectionInfo> inspectionLambda = new QueryWrapper<InspectionDetectionInfo>().lambda();
        inspectionLambda.eq(InspectionDetectionInfo::getRecord, equipId);
        // 更新检验检测信息
        inspectionDetectionInfoMapper.update(inspectionDetectionInfo, inspectionLambda);
        // 使用登记信息
        JgChangeRegistrationReform jgChangeRegistrationReform = new JgChangeRegistrationReform();
        LambdaQueryWrapper<OtherInfo> otherLambda = new QueryWrapper<OtherInfo>().lambda();
        otherLambda.eq(OtherInfo::getRecord, equipId);
        OtherInfo otherInfo = otherInfoMapper.selectOne(otherLambda);
        String supervisoryCode = otherInfo.getSupervisoryCode();
        jgChangeRegistrationReform.setSupervisoryCode(supervisoryCode);
        jgChangeRegistrationReform.setUseUnitName(useInfo.getUseUnitName());
        jgChangeRegistrationReform.setUseUnitCreditCode(useInfo.getUseUnitCreditCode());
        if(!ObjectUtils.isEmpty(map.get("transformationQualityCertificate"))){
            jgChangeRegistrationReform.setTransformationQualityCertificate(JSONObject.toJSONString(map.get("transformationQualityCertificate")));
        }
        if(!ObjectUtils.isEmpty(map.get("renovationSupervisioninspectionCertificate"))) {
            jgChangeRegistrationReform.setRenovationSupervisioninspectionCertificate(JSONObject.toJSONString(map.get("renovationSupervisioninspectionCertificate")));
        }
        // 使用单位提交
        jgChangeRegistrationReform.setUseUnitCreditCode(reginParams.getCompany().getCompanyCode());
        if (!ObjectUtils.isEmpty(map.get("inspectUnitCreditCode"))) {
            jgChangeRegistrationReform.setInspectUnitCreditCode(map.get("inspectUnitCreditCode").toString());
        } else {
            jgChangeRegistrationReform.setInspectUnitCreditCode(reginParams.getCompany().getCompanyCode());
        }
        if (!ObjectUtils.isEmpty(map.get("inspectOrgName"))) {
            jgChangeRegistrationReform.setInspectUnitName(map.get("inspectOrgName").toString());
        } else {
            jgChangeRegistrationReform.setInspectUnitName(reginParams.getCompany().getCompanyName());
        }
        if (map.containsKey("receiveCompanyCode")) {
            String  receiveCompanyCode = String.valueOf(map.getString("receiveCompanyCode"));
            jgChangeRegistrationReform.setReceiveCompanyCode(receiveCompanyCode);
            jgChangeRegistrationReform.setReceiveOrgCode(receiveCompanyCode.split("_")[0]);
            jgChangeRegistrationReform.setReceiveOrgName(receiveCompanyCode.split("_")[1]);

        } else {
            jgChangeRegistrationReform.setReceiveCompanyCode("610000");
        }
        JgRegistrationHistory jgRegistrationHistory = new JgRegistrationHistory();
        //使用登记编号
        jgRegistrationHistory.setUseRegistrationCode(idxBizJgRegisterInfoMapper.getUseOrgCodeByEquip(equipId));
        //登记类别
        jgRegistrationHistory.setRegistrationClass("改造登记");
        //设备id
        jgRegistrationHistory.setEquId(equipId);
        //修改数据
        jgRegistrationHistory.setChangeData(JSONObject.toJSONString(map));
        //保存历史数据
        IdxBizJgTechParamsElevator idxBizJgTechParamsElevator = idxBizJgTechParamsElevatorMapper.selectOne(new QueryWrapper<IdxBizJgTechParamsElevator>().eq("RECORD", equipId));
        jgRegistrationHistory.setOldData(JSONObject.toJSONString(idxBizJgTechParamsElevator));
        //设备监管码
        jgRegistrationHistory.setSupervisoryCode(supervisoryCode);
        //数据状态
        jgChangeRegistrationReform.setUseRegistrationCode(jgRegistrationHistory.getUseRegistrationCode());
        jgRegistrationHistory.setStatus("new");
        if (map.containsKey("type") && "edit".equals(String.valueOf(map.get("type")))) {
            jgChangeRegistrationReform.setUseUnitCreditCode(null);
            jgChangeRegistrationReform.setSequenceNbr(Long.valueOf(String.valueOf(map.get("sequenceNbr"))));
            this.getBaseMapper().updateById(jgChangeRegistrationReform);
            jgRegistrationHistory.setSequenceNbr(jgRegistrationHistoryMapper.getSequenceNbrByEquidAndDocumentId(equipId, String.valueOf(map.get("sequenceNbr"))));
            jgRegistrationHistoryMapper.updateById(jgRegistrationHistory);
        } else {

            // 业务管理设备信息保存
            JgChangeRegistrationReformEq jgChangeRegistrationReformEq = new JgChangeRegistrationReformEq();
            jgChangeRegistrationReformEq.setEquId(equipId);
            ResponseModel<List<String>> result =tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.GZBG.getCode(), 1);
            if(!result.getResult().isEmpty()){
                jgChangeRegistrationReform.setApplyNo(result.getResult().get(0));
            }else {
                throw  new BadRequest("申请单编号生成失败,请稍后重试!");
            }
            jgChangeRegistrationReform.setAuditStatus(WorkFlowStatusEnum.CHANGE_SUBMIT.getPass());
            jgChangeRegistrationReform.setStatus(WorkFlowStatusEnum.CHANGE_SUBMIT.getPass());
            jgChangeRegistrationReform.setRegDate(new Date());
            this.save(jgChangeRegistrationReform);
            jgChangeRegistrationReformEq.setEquipTransferId(jgChangeRegistrationReform.getSequenceNbr().toString());
            jgChangeRegistrationReformEqMapper.insert(jgChangeRegistrationReformEq);
            //当前单据id
            jgRegistrationHistory.setCurrentDocumentId(jgChangeRegistrationReform.getApplyNo());
            jgRegistrationHistoryMapper.insert(jgRegistrationHistory);
        }

        if (!ObjectUtils.isEmpty(map.get("submit"))) {
            String instanceId = "";
            if (!ObjectUtils.isEmpty(map.get("instanceId"))) {
                instanceId = map.get("instanceId").toString();
            } else {
                // 启动并执行流程
                instanceId = startByVariable();
                updateExecuteIds(instanceId, jgChangeRegistrationReform.getSequenceNbr(), "0");
            }

            if (!ObjectUtils.isEmpty(instanceId)) {
                // 执行流程
                flowExecute(jgChangeRegistrationReform.getSequenceNbr(), instanceId, "0", "");
                updateExecuteIds(instanceId, jgChangeRegistrationReform.getSequenceNbr(), "0");
            }

        }
    }

    public String startByVariable() {
        String instanceId = "";
        //启动流程
        try {
            ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
            dto.setProcessDefinitionKey("renovationRegistrationReview");
            dto.setBusinessKey("submit");
            AjaxResult ajaxResult = Workflow.taskClient.startByVariable(dto);
            instanceId = ((Map) ajaxResult.get("data")).get("id").toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return instanceId;
    }

    public void updateExecuteIds(String instanceId, Long sequenceNbr, String operate) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        String role = "";
        String taskCode = FlowStatusEnum.TO_BE_FINISHED.getName();
        ArrayList<String> roleList = new ArrayList<>();
        JgChangeRegistrationReform jgChangeRegistrationReform = this.getBaseMapper().selectById(sequenceNbr);
        try {
            // 查询下节点任务
            JSONObject taskNoAuth = workFlowFeginService.getTaskNoAuth(instanceId);
            if (!ObjectUtils.isEmpty(taskNoAuth.get("data"))) {
                JSONObject nextTask = JSON.parseObject(JSON.toJSONString(taskNoAuth.get("data")));
                String nextTaskId = nextTask.getString("id");
                FeignClientResult<JSONObject> nodeInfo = workFlowFeginService.getNodeInfo(nextTaskId);
                JSONObject result = nodeInfo.getResult();
                Map<String, Object> taskInfo = (Map<String, Object>) result.get("taskInfo");
                taskCode = String.valueOf(taskInfo.get("taskDefinitionKey"));
                AjaxResult taskGroupName = Workflow.taskClient.getTaskGroupName(nextTaskId);
                JSONArray data = JSON.parseArray(JSON.toJSONString(taskGroupName.get("data")));
                for (Object datum : data) {
                    if (((Map) datum).containsKey("groupId")) {
                        roleList.add(((Map) datum).get("groupId").toString());
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (!FlowStatusEnum.TO_BE_FINISHED.getName().equals(taskCode)) {
            role = String.join(",", roleList);
            jgChangeRegistrationReform.setNextExecutorIds(role);
            jgChangeRegistrationReform.setPromoter(reginParams.getUserModel().getUserId());
            jgChangeRegistrationReform.setInstanceId(instanceId);
            if (!ObjectUtils.isEmpty(jgChangeRegistrationReform.getInstanceStatus())) {
                jgChangeRegistrationReform.setInstanceStatus(jgChangeRegistrationReform.getInstanceStatus() + "," + role);
            } else {
                jgChangeRegistrationReform.setInstanceStatus(role);
            }
            if ("0".equals(operate)) {
                // 通过操作
                jgChangeRegistrationReform.setAuditStatus(WorkFlowStatusEnum.getMessage(taskCode).getPass());
                jgChangeRegistrationReform.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getPass());
            } else {
                // 驳回操作
                jgChangeRegistrationReform.setAuditStatus(WorkFlowStatusEnum.getMessage(taskCode).getReject());
                jgChangeRegistrationReform.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getReject());
                jgChangeRegistrationReform.setPromoter(null);
            }

        } else {
            jgChangeRegistrationReform.setAuditPassDate(new Date());
            jgChangeRegistrationReform.setAuditStatus(FlowStatusEnum.TO_BE_FINISHED.getName());
            jgChangeRegistrationReform.setStatus(FlowStatusEnum.TO_BE_FINISHED.getName());
            JgChangeRegistrationReformEq jgChangeRegistrationReformEq = jgChangeRegistrationReformEqMapper.selectOne(new QueryWrapper<JgChangeRegistrationReformEq>().eq("equip_transfer_id", jgChangeRegistrationReform.getSequenceNbr()));
            String newUseRegistrationCertificateNumber = getCode(jgChangeRegistrationReform.getSupervisoryCode());
            jgChangeRegistrationReform.setUseRegistrationCode(newUseRegistrationCertificateNumber);
            updateTechparamsByEquIdAndCurrentDoucumentId(jgChangeRegistrationReformEq.getEquId(), jgChangeRegistrationReform.getSequenceNbr().toString(),newUseRegistrationCertificateNumber,jgChangeRegistrationReform.getApplyNo() );
        }
        this.getBaseMapper().updateById(jgChangeRegistrationReform);
    }
//    public String flowExecute(Long id, String instanceId, String operate, String comment, Boolean update) {
//        String role = "";
//        String taskName = "流程结束";
//        ArrayList<String> roleList = new ArrayList<>();
//        try {
//            JSONObject task = workFlowFeginService.getTaskNoAuth(instanceId);
//            JSONObject taskMessage = JSON.parseObject(JSON.toJSONString(task.get("data")));
//            String taskId = taskMessage.getString("id");
//            //组装信息
//            TaskResultDTO dto = new TaskResultDTO();
//            dto.setResultCode("approvalStatus");
//            dto.setTaskId(taskId);
//            dto.setComment(comment);
//            HashMap<String, Object> map = new HashMap<>();
//            map.put("approvalStatus", operate);
//            dto.setVariable(map);
//            //执行流程
//            Workflow.taskClient.completeByTask(taskId, dto);
//            // 查询下节点任务
//            JSONObject taskNoAuth = workFlowFeginService.getTaskNoAuth(instanceId);
//            if (!ObjectUtils.isEmpty(taskNoAuth.get("data"))) {
//                JSONObject nextTask = JSON.parseObject(JSON.toJSONString(taskNoAuth.get("data")));
//                String nextTaskId = nextTask.getString("id");
//                taskName = nextTask.getString("name");
//                AjaxResult taskGroupName = Workflow.taskClient.getTaskGroupName(nextTaskId);
//                JSONArray data = JSON.parseArray(JSON.toJSONString(taskGroupName.get("data")));
//                for (Object datum : data) {
//                    if (((Map) datum).containsKey("groupId")) {
//                        roleList.add(((Map) datum).get("groupId").toString());
//                    }
//                }
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//        role = String.join(",", roleList);
//        if (update) {
//            Boolean rollBack = "1".equals(operate) ? true : false;
//            updateStatus(id, instanceId, taskName, role, rollBack);
//        }
//        return role;
//    }


    public void flowExecute(Long id, String instanceId, String operate, String comment) {
        try {
            JSONObject task = workFlowFeginService.getTaskNoAuth(instanceId);
            JSONObject taskMessage = JSON.parseObject(JSON.toJSONString(task.get("data")));
            String taskId = taskMessage.getString("id");
            //组装信息
            TaskResultDTO dto = new TaskResultDTO();
            dto.setResultCode("approvalStatus");
            dto.setTaskId(taskId);
            dto.setComment(comment);
            HashMap<String, Object> map = new HashMap<>();
            map.put("approvalStatus", operate);
            dto.setVariable(map);
            //执行流程
            Workflow.taskClient.completeByTask(taskId, dto);
        } catch (Exception e) {
            e.printStackTrace();
        }
        // 更新下一步执行人
        updateExecuteIds(instanceId, id, operate);

    }
//    public void updateStatus(Long id, String instanceId, String taskName, String role, Boolean rollBack) {
//        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
//        LambdaQueryWrapper<JgChangeRegistrationReform> lambda = new QueryWrapper<JgChangeRegistrationReform>().lambda();
//        lambda.eq(JgChangeRegistrationReform::getSequenceNbr, id);
//        JgChangeRegistrationReform jgChangeRegistrationReform = this.getBaseMapper().selectOne(lambda);
//        if ("流程结束".equals(taskName)) {
//            JgChangeRegistrationReformEq jgChangeRegistrationReformEq = jgChangeRegistrationReformEqMapper.selectOne(new QueryWrapper<JgChangeRegistrationReformEq>().eq("equip_transfer_id", jgChangeRegistrationReform.getSequenceNbr()));
//            jgChangeRegistrationReform.setStatus("已完成");
//            jgChangeRegistrationReform.setAuditStatus(RenovationRegistrationWorkFlowStatusEnum.COMPLETE.getName());
//
//            //交换历史数据与新增数据
//            updateTechparamsByEquIdAndCurrentDoucumentId(jgChangeRegistrationReformEq.getEquId(), jgChangeRegistrationReform.getSequenceNbr().toString(), jgChangeRegistrationReform.getSupervisoryCode());
//        } else {
//            jgChangeRegistrationReform.setNextExecutorIds(role);
//            jgChangeRegistrationReform.setPromoter(reginParams.getUserModel().getUserId());
//            if (!ObjectUtils.isEmpty(jgChangeRegistrationReform.getInstanceStatus())) {
//                jgChangeRegistrationReform.setInstanceStatus(jgChangeRegistrationReform.getInstanceStatus() + "," + role);
//            } else {
//                jgChangeRegistrationReform.setInstanceStatus(role);
//            }
//        }
//        if (rollBack) {
//            jgChangeRegistrationReform.setAuditStatus(RenovationRegistrationWorkFlowStatusEnum.getMessage(taskName).getReject());
//            this.getBaseMapper().update(jgChangeRegistrationReform, lambda);
//            this.getBaseMapper().updatePromoter(jgChangeRegistrationReform.getSequenceNbr());
//        } else {
//            jgChangeRegistrationReform.setAuditStatus(RenovationRegistrationWorkFlowStatusEnum.getMessage(taskName).getPass());
//            this.getBaseMapper().update(jgChangeRegistrationReform, lambda);
//        }
//    }

    public void withdraw(String instanceId) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        String taskCode = "";
        JgChangeRegistrationReform jgChangeRegistrationReform = new JgChangeRegistrationReform();
        LambdaQueryWrapper<JgChangeRegistrationReform> lambda = new QueryWrapper<JgChangeRegistrationReform>().lambda();
        lambda.eq(JgChangeRegistrationReform::getInstanceId, instanceId);
        ArrayList<String> roleList = new ArrayList<>();
        try {
            workFlowFeginService.rollBack(instanceId);
            JSONObject taskNoAuth = workFlowFeginService.getTaskNoAuth(instanceId);
            JSONObject nextTask = JSON.parseObject(JSON.toJSONString(taskNoAuth.get("data")));
            if (!ObjectUtils.isEmpty(taskNoAuth.get("data"))) {
                String nextTaskId = nextTask.getString("id");
                FeignClientResult<JSONObject> nodeInfo = workFlowFeginService.getNodeInfo(nextTaskId);
                JSONObject result = nodeInfo.getResult();
                Map<String, Object> taskInfo = (Map<String, Object>) result.get("taskInfo");
                taskCode = String.valueOf(taskInfo.get("taskDefinitionKey"));
                AjaxResult taskGroupName = Workflow.taskClient.getTaskGroupName(nextTaskId);
                JSONArray data = JSON.parseArray(JSON.toJSONString(taskGroupName.get("data")));
                for (Object datum : data) {
                    if (((Map) datum).containsKey("groupId")) {
                        roleList.add(((Map) datum).get("groupId").toString());
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (!ObjectUtils.isEmpty(taskCode)) {
            jgChangeRegistrationReform.setAuditStatus(WorkFlowStatusEnum.getMessage(taskCode).getRollBack());
            jgChangeRegistrationReform.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getRollBack());
        }

        String join = String.join(",", roleList);
        jgChangeRegistrationReform.setPromoter(reginParams.getUserModel().getUserId());
        jgChangeRegistrationReform.setNextExecutorIds(join);
        this.update(jgChangeRegistrationReform, lambda);
    }

    public void deleteBatch(List<Long> ids) {
         List<JgChangeRegistrationReform> jgChangeRegistrationReformList = this.getBaseMapper().selectList(new QueryWrapper<JgChangeRegistrationReform>().in("sequence_nbr", ids));
         List<String>  applyNos  =jgChangeRegistrationReformList.stream().map(JgChangeRegistrationReform::getApplyNo).collect(Collectors.toList());
        JgChangeRegistrationReform jgChangeRegistrationReform = new JgChangeRegistrationReform();
        jgChangeRegistrationReform.setIsDelete(true);
        LambdaQueryWrapper<JgChangeRegistrationReform> lambda = new QueryWrapper<JgChangeRegistrationReform>().lambda();
        lambda.in(JgChangeRegistrationReform::getSequenceNbr, ids);
        this.getBaseMapper().delete(lambda);
        JgChangeRegistrationReformEq jgChangeRegistrationReformEq = new JgChangeRegistrationReformEq();
        jgChangeRegistrationReformEq.setIsDelete(true);
        LambdaQueryWrapper<JgChangeRegistrationReformEq> lambda1 = new QueryWrapper<JgChangeRegistrationReformEq>().lambda();
        lambda1.in(JgChangeRegistrationReformEq::getEquipTransferId, ids);
        jgChangeRegistrationReformEqMapper.delete(lambda1);
        jgRegistrationHistoryMapper.delete(new QueryWrapper<JgRegistrationHistory>().in("current_document_id", applyNos));
    }

    public Map<String, Object> getDetail(String currentDocumentId, String equipId) {
        JgChangeRegistrationReform jgChangeRegistrationReform = this.getBaseMapper().selectById(currentDocumentId);
        if(ObjectUtils.isEmpty(equipId)){
            equipId = jgChangeRegistrationReformEqMapper.selectEquipId(currentDocumentId);
        }
        Map<String, Object> detail = JSONObject.parseObject(JSONObject.toJSONString(jgChangeRegistrationReform), Map.class);
        Map<String, Object> originalData = new HashMap<>();

        if ((detail.get("status").equals("已完成") || detail.get("status").equals("流程结束"))) {
            originalData = idxBizJgRegisterInfoService.getDetailFieldCamelCaseByRecord(equipId);
            originalData.remove("sequenceNbr");
            if(!ObjectUtils.isEmpty(detail.get("transformationQualityCertificate"))){
                detail.put("transformationQualityCertificate", JSONObject.parse(detail.get("transformationQualityCertificate").toString()));
            }
            if(!ObjectUtils.isEmpty(detail.get("renovationSupervisioninspectionCertificate"))){
                detail.put("renovationSupervisioninspectionCertificate", JSONObject.parse(detail.get("renovationSupervisioninspectionCertificate").toString()));
            }
        } else {
            JgRegistrationHistory jgRegistrationHistory = jgRegistrationHistoryMapper.selectOne(new QueryWrapper<JgRegistrationHistory>()
                    .eq("equ_id", equipId)
                    .eq("current_document_id", jgChangeRegistrationReform.getApplyNo())
                    .eq("registration_class", "改造登记"));
            originalData = JSONObject.parseObject(jgRegistrationHistory.getChangeData(), Map.class);
            originalData.remove("sequenceNbr");
        }
        detail.putAll(originalData);
        return detail;
    }


    /**
     * 批量设置设备无效(使用登记、移装登记、改造登记)
     *
     * @param equipmentId       装备id
     * @param currentDocumentId 当前文档id
     */
    public void makeEquipmentsInvalid(String equipmentId, String currentDocumentId) {
        jgChangeRegistrationReformEqMapper.updateEquipIsVaildByEquipIdAndCurrentDocumentId(equipmentId, currentDocumentId);
        jgChangeRegistrationTransferEqMapper.updateEquipIsVaildByEquipIdAndCurrentDocumentId(equipmentId, currentDocumentId);
        jgUseRegistrationEqMapper.updateEquipIsVaildByEquipIdAndCurrentDocumentId(equipmentId, currentDocumentId);
        //单位变更登记
        jgChangeRegistrationUnitEqMapper.updateEquipIsVaildByEquipIdAndCurrentDocumentId(equipmentId, currentDocumentId);
        //更名变更登记
        jgChangeRegistrationNameEqMapper.updateEquipIsVaildByEquipIdAndCurrentDocumentId(equipmentId, currentDocumentId);
    }

    /**
     * 流程完成之后互换数据并更新设备状态
     *
     * @param equipId
     * @param currentDocumentId
     */
    public void updateTechparamsByEquIdAndCurrentDoucumentId(String equipId, String currentDocumentId, String newUseRegistrationCertificateNumber,String applyNo) {

        IdxBizJgTechParamsElevator idxBizJgTechParamsElevator = idxBizJgTechParamsElevatorMapper.selectOne(new QueryWrapper<IdxBizJgTechParamsElevator>().eq("RECORD", equipId));
        JgRegistrationHistory jgRegistrationHistory = jgRegistrationHistoryMapper.selectOne(new QueryWrapper<JgRegistrationHistory>()
                .eq("equ_id", equipId)
                .eq("current_document_id", applyNo)
                .eq("registration_class", "改造登记"));

        if (!ObjectUtils.isEmpty(idxBizJgTechParamsElevator) && !ObjectUtils.isEmpty(jgRegistrationHistory)) {
            //历史数据
            String historyData = JSONObject.toJSONString(idxBizJgTechParamsElevator);
            //当前数据
            String newData = jgRegistrationHistory.getChangeData();
            //将历史数据更新到技术参数表中
            IdxBizJgTechParamsElevator idxBizJgTechParamsElevatorNew = JSONObject.parseObject(newData, IdxBizJgTechParamsElevator.class);
            BeanUtil.copyProperties(idxBizJgTechParamsElevatorNew, idxBizJgTechParamsElevator, "sequenceNbr", "record");
            idxBizJgTechParamsElevatorMapper.updateById(idxBizJgTechParamsElevator);
            //将历史数据回填到历史记录表中
            jgRegistrationHistory.setChangeData(newData);
            jgRegistrationHistory.setOldData(historyData);
            jgRegistrationHistory.setStatus("history");
            jgRegistrationHistoryMapper.updateById(jgRegistrationHistory);
            makeEquipmentsInvalid(equipId, currentDocumentId);
            //更新使用注册登记证编号
            idxBizJgRegisterInfoMapper.updateUseOrgCodeByEquip(equipId, newUseRegistrationCertificateNumber);
            //es中的编号信息
            Map<String, Map<String, Object>> resultMap = new HashMap<>();
            Map<String, Object> map1 = new HashMap<>();
            map1.put("USE_ORG_CODE", newUseRegistrationCertificateNumber);
            resultMap.put(equipId, map1);
            tzsServiceFeignClient.commonUpdateEsDataByIds(resultMap);
        }
    }

    /*
     * 获取电梯的原始技术参数
     * @param equipId
     */
    public Map<String, Object> getOriginalTechParams(String equipId) {
        Map<String, Object> result = new HashMap<>();
        IdxBizJgTechParamsElevator idxBizJgTechParamsElevator = idxBizJgTechParamsElevatorMapper.selectOne(new QueryWrapper<IdxBizJgTechParamsElevator>().eq("RECORD", equipId));
        if (!ObjectUtils.isEmpty(idxBizJgTechParamsElevator)) {
            result = JSONObject.parseObject(JSONObject.toJSONString(idxBizJgTechParamsElevator), Map.class);
            result.remove("sequenceNbr");
        }
        return result;
    }

    /**
     * 参数为监管码
     *
     * @param supervisoryCode
     * @return
     */
    public String getCode(String supervisoryCode) {
        if (!ObjectUtils.isEmpty(supervisoryCode) && supervisoryCode.length() > 5) {
            String name = EquipTypeEnum.getMessage(supervisoryCode.substring(1, 2));
            String type = supervisoryCode.substring(2, 4);
            String city = supervisoryCode.substring(0, 1);
            ResponseModel<String> stringResponseModel = tzsServiceFeignClient.useRegistrationCode(name + type + "陕" + city);
            return stringResponseModel.getResult();
        }
        return null;
    }
}