package com.yeejoin.amos.boot.module.common.api.dto;

import java.util.Date;
import java.util.List;

import org.springframework.format.annotation.DateTimeFormat;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.common.api.entity.SourceFile;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author system_generator
 * @date 2021-08-04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "FailureDetailsDto", description = "")
public class FailureDetailsDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "当前状态名")
    private String currentStatusName;

    @ApiModelProperty(value = "当前状态")
    private Integer currentStatus;

    @ApiModelProperty(value = "故障单号")
    private String failureCode;

    @ApiModelProperty(value = "故障设备ID")
    private Integer failureEquipmentId;

    @ApiModelProperty(value = "故障设备")
    private String failureEquipment;

    //@JsonFormat(locale = "zh",timezone = "GMT+8",pattern = "YYYY-MM-dd")
    @ApiModelProperty(value = "故障时间")
    private String faultTime;

    @ApiModelProperty(value = "故障现象")
    private String faultPhenomenon;

    @ApiModelProperty(value = "报送人")
    private String submissionName;

    @ApiModelProperty(value = "报送人ID")
    private Integer submissionPid;

    @ApiModelProperty(value = "组织code")
    private Long bizCode;

    @ApiModelProperty(value = "报送时间")
    private Date submissionTime;

    @ApiModelProperty(value = "送达部门")
    private String submissionBranch;

    @ApiModelProperty(value = "送达部门ID")
    private Long submissionBranchId;

    @ApiModelProperty(value = "流程ID")
    private String processId;

    @ApiModelProperty(value = "附件")
    private List<SourceFile> attachment;

    @ApiModelProperty(value = "是否本人报送")
    private Boolean isSubmit = false ;

}
