package com.yeejoin.amos.boot.module.jczs.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

/**
 * @author Zhang Yingbin
 */
@AllArgsConstructor
@Getter
public enum WarningTypeEnum {

    /**
     * 预警类型
     */
    WARNING_CYL_TYPE("气瓶预警", "1", "warning_soon_expire"),
    WARNING_EQU_TYPE("设备预警", "2", "warning_over_expire"),
    WARNING_LIC_TYPE("许可预警", "3", "warning_soon_expire");


    private String name;

    private String level;

    private String code;

    public static WarningTypeEnum getEumByLevel(String level) {
        Optional<WarningTypeEnum> op = Arrays.stream(WarningTypeEnum.values()).filter(e -> e.getLevel().equals(level)).findFirst();
        return op.orElseThrow(() -> new RuntimeException("未知的类型"));
    }
}
