package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.annotation.FieldMapping;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.api.dto.JgChangeVehicleRegistrationUnitDto;
import com.yeejoin.amos.boot.module.jg.api.dto.JgUseRegistrationManageDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgChangeVehicleRegistrationUnit;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.CommonServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgChangeVehicleRegistrationUnitServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.component.event.RestEventTrigger;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 *
 * @author system_generator
 * @date 2024-07-10
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/jg-change-vehicle-registration-unit")
public class JgChangeVehicleRegistrationUnitController extends BaseController {

    @Autowired
    JgChangeVehicleRegistrationUnitServiceImpl jgChangeVehicleRegistrationUnitServiceImpl;



	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	public ResponseModel<JgChangeVehicleRegistrationUnitDto> updateBySequenceNbrJgChangeVehicleRegistrationUnit(@RequestBody JgChangeVehicleRegistrationUnitDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(jgChangeVehicleRegistrationUnitServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(jgChangeVehicleRegistrationUnitServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<JgChangeVehicleRegistrationUnitDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(jgChangeVehicleRegistrationUnitServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<JgChangeVehicleRegistrationUnitDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<JgChangeVehicleRegistrationUnitDto> page = new Page<JgChangeVehicleRegistrationUnitDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(jgChangeVehicleRegistrationUnitServiceImpl.queryForJgChangeVehicleRegistrationUnitPage(page));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增、更新车用气瓶变更", notes = "新增、更新车用气瓶变更")
	@FieldMapping({@FieldMapping.FieldMap(sourceField = "useUnitSeq", targetField = "useUnitCreditCode", serviceClass = CommonServiceImpl.class, queryMethod = "queryUnitCreditInfoBySeq"),})
	public ResponseModel<String> save(@RequestBody JSONObject model) {
		ReginParams reginParams = getSelectedOrgInfo();
		jgChangeVehicleRegistrationUnitServiceImpl.saveMessage(model, reginParams);
		return ResponseHelper.buildResponse("");
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<JgChangeVehicleRegistrationUnitDto>> selectForList() {
	    return ResponseHelper.buildResponse(jgChangeVehicleRegistrationUnitServiceImpl.queryForJgChangeVehicleRegistrationUnitList());
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping (value = "/getUseRegistrationCodeData")
	@ApiOperation(httpMethod = "GET", value = "获取当前企业，某接收机构审批的使用登记证信息", notes = "获取当前企业，某接收机构审批的使用登记证信息")
	@FieldMapping({@FieldMapping.FieldMap(paramIndex = 2, useEntireParam = true, sourceField = "useUnitCreditCode", replaceParam = true, targetField = "useUnitCreditCode", serviceClass = CommonServiceImpl.class, queryMethod = "queryUnitCreditInfoBySeq")})
	public ResponseModel<Page<JgUseRegistrationManageDto>> getUseRegistrationCodeData(
			@RequestParam(value = "current") int current,
			@RequestParam(value = "size") int size,
			@RequestParam(value = "useUnitCreditCode", required = false) String useUnitCreditCode,
			@RequestParam(value = "whetherVehicleCylinder") String whetherVehicleCylinder,
			@RequestParam(value = "certificateStatus", required = false) String certificateStatus,
			@RequestParam(value = "equCategoryCode", required = false) String equCategoryCode,
			@RequestParam(value = "useRegistrationCode", required = false) String useRegistrationCode) {
		if (ValidationUtil.isEmpty(useUnitCreditCode)) throw new BadRequest("请先选择原使用单位");
		JgUseRegistrationManageDto dto = new JgUseRegistrationManageDto();
		Page<JgUseRegistrationManageDto> page = new Page<>();
		page.setCurrent(current);
		page.setSize(size);
		if (!ValidationUtil.isEmpty(useUnitCreditCode)){
			String[] codes = useUnitCreditCode.split("_");
			if (!ValidationUtil.isEmpty(codes)){
				dto.setDataType(BaseController.COMPANY_TYPE_COMPANY);
			    dto.setUseUnitCreditCode(codes[0]);
			}
		}
		if (!ValidationUtil.isEmpty(certificateStatus)){
			dto.setCertificateStatus(certificateStatus);
		}
        if (!ValidationUtil.isEmpty(equCategoryCode)){
            dto.setEquCategoryCode(equCategoryCode);
        }
		if (!ObjectUtils.isEmpty(useRegistrationCode)){
			dto.setUseRegistrationCode(useRegistrationCode);
		}
		if (!ValidationUtil.isEmpty(whetherVehicleCylinder)){
			dto.setWhetherVehicleCylinder(whetherVehicleCylinder);
		}
		return ResponseHelper.buildResponse(jgChangeVehicleRegistrationUnitServiceImpl.getUseRegistrationCodeData(page, dto));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getEquList")
	@ApiOperation(httpMethod = "GET", value = "根据使用登记查询绑定气瓶(组件默认参数record)", notes = "根据使用登记查询绑定气瓶")
	public ResponseModel<Map<String, Object>> getEquList(@RequestParam(value = "record") String record) {
		return ResponseHelper.buildResponse(jgChangeVehicleRegistrationUnitServiceImpl.getEquList(record));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/details")
	@ApiOperation(httpMethod = "GET", value = "获取详情", notes = "获取详情")
	public ResponseModel<Map<String, Object>> getDetails(@RequestParam(value = "sequenceNbr") String sequenceNbr) {
		return ResponseHelper.buildResponse(jgChangeVehicleRegistrationUnitServiceImpl.getDetails(sequenceNbr, getSelectedOrgInfo()));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/withdraw")
	@ApiOperation(httpMethod = "POST", value = "车用气瓶单位变更登记撤回", notes = "撤回")
	@RestEventTrigger(value = "operateLogRestEventHandler")
	public ResponseModel<Object> withdraw(@RequestBody JSONObject map) {
		jgChangeVehicleRegistrationUnitServiceImpl.withdraw(String.valueOf(map.get("instanceId")), String.valueOf(map.get("nextTaskId")));
		return ResponseHelper.buildResponse("ok");
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@DeleteMapping(value = "/delete")
	@ApiOperation(httpMethod = "DELETE", value = "车用气瓶单位变更删除", notes = "删除")
	@RestEventTrigger(value = "operateLogRestEventHandler")
	public ResponseModel<Object> withdraw(@RequestParam(value = "sequenceNbr") String sequenceNbr) {
		jgChangeVehicleRegistrationUnitServiceImpl.deleteMessage(sequenceNbr);
		return ResponseHelper.buildResponse("ok");
	}
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/flowExecute")
	@ApiOperation(httpMethod = "POST", value = "车用气瓶单位变更执行流程", notes = "执行流程")
	@RestEventTrigger(value = "operateLogRestEventHandler")
	public ResponseModel<Object> flowExecute(@RequestBody JSONObject map) {
		jgChangeVehicleRegistrationUnitServiceImpl.flowExecute(Long.valueOf(String.valueOf(map.get("sequenceNbr"))),
				String.valueOf(map.get("instanceId")),
				String.valueOf(map.get("operate")),
				String.valueOf(map.get("comment")),
				String.valueOf(map.get("nextTaskId")));
		return ResponseHelper.buildResponse("ok");
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/getPage")
	@ApiOperation(httpMethod = "POST", value = "车用气瓶列表", notes = "车用气瓶列表")
	public ResponseModel<Object> getPage(@RequestBody(required = false) JgChangeVehicleRegistrationUnitDto dto,
										 @RequestParam(value = "number") int number,
										 @RequestParam(value = "size") int size,
										 @ApiParam(value = "排序字段", required = false) @RequestParam(value = "sort", required = false) String sort,
										 @ApiParam(value = "客户端类型: jgAudit-监管审核;jgLook-监管查看") @RequestParam(value = "client", required = false, defaultValue = "jgAudit") String client
	) {
		Page<JgChangeVehicleRegistrationUnit> page = new Page<>(number, size);
		ReginParams reginParams = getSelectedOrgInfo();
		String type = "";
		if (reginParams.getCompany().getLevel().equals(BaseController.COMPANY_TYPE_COMPANY)) {
			type = "enterprise";
		} else {
			type = "supervision";
		}
		return ResponseHelper.buildResponse(jgChangeVehicleRegistrationUnitServiceImpl.getPage(page, sort, dto, type, reginParams, client));
	}
}
