package com.yeejoin.amos.boot.module.jczs.flc.biz.controller;

import com.yeejoin.amos.boot.module.jczs.flc.biz.service.impl.EquipmentIndexInformServiceImpl;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;

import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jczs.flc.api.dto.EquipmentIndexInformDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 设备指标
 *
 * @author system_generator
 * @date 2021-12-29
 */
@RestController
@Api(tags = "设备指标Api")
@RequestMapping(value = "/equipment-index-inform")
public class EquipmentIndexInformController extends BaseController {

    @Autowired
    EquipmentIndexInformServiceImpl equipmentIndexInformServiceImpl;

    /**
     * 新增设备指标
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增设备指标", notes = "新增设备指标")
	public ResponseModel<EquipmentIndexInformDto> save(@RequestBody EquipmentIndexInformDto model) {
	    model = equipmentIndexInformServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新设备指标", notes = "根据sequenceNbr更新设备指标")
	public ResponseModel<EquipmentIndexInformDto> updateBySequenceNbrEquipmentIndexInform(@RequestBody EquipmentIndexInformDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(equipmentIndexInformServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除设备指标", notes = "根据sequenceNbr删除设备指标")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(equipmentIndexInformServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个设备指标",  notes = "根据sequenceNbr查询单个设备指标")
	public ResponseModel<EquipmentIndexInformDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(equipmentIndexInformServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "设备指标分页查询",  notes = "设备指标分页查询")
	public ResponseModel<Page<EquipmentIndexInformDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<EquipmentIndexInformDto> page = new Page<EquipmentIndexInformDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(equipmentIndexInformServiceImpl.queryForEquipmentIndexInformPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "设备指标列表全部数据查询",   notes = "设备指标列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<EquipmentIndexInformDto>> selectForList() {
	    return ResponseHelper.buildResponse(equipmentIndexInformServiceImpl.queryForEquipmentIndexInformList());
	}
}
