package com.yeejoin.amos.boot.module.common.biz.refresh.dispatch;

import com.yeejoin.amos.boot.module.common.api.entity.TzsDataRefreshMessage;
import com.yeejoin.amos.boot.module.common.api.service.IDataRefreshDispatch;
import com.yeejoin.amos.boot.module.common.api.service.IDataRefreshHandler;
import com.yeejoin.amos.boot.module.common.biz.service.impl.TzsDataRefreshMessageServiceImpl;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

@Component
@RequiredArgsConstructor
@Slf4j
public class DataRefreshDispatcher implements IDataRefreshDispatch {


    private final TzsDataRefreshMessageServiceImpl refreshMessageService;

    @Override
    @Async
    public void doDispatch(List<IDataRefreshHandler> dataRefreshHandlers, List<TzsDataRefreshMessage> messages) {
        int total = dataRefreshHandlers.size();
        dataRefreshHandlers.forEach(dataRefreshHandler -> {
            messages.forEach(message -> {
                try {
                    message.setDistributions(total);
                    dataRefreshHandler.doRefresh(message);
                    markRefreshSuccess(message, dataRefreshHandler);
                } catch (Exception e) {
                    log.error("企业、设备、人员，总线分发处理变更数据失败，消息内容：{}, 错误日志：{}", message, e.getMessage(), e);
                    markRefreshFailure(message, dataRefreshHandler, e);
                }
            });
        });
    }


    private static String buildErrorMsg(IDataRefreshHandler dataRefreshHandler, TzsDataRefreshMessage message, Exception e) {
        return StringUtils.isEmpty(message.getErrorMsg()) ? dataRefreshHandler.getClass().getSimpleName() + "@" + e.getMessage() : message.getErrorMsg() + ";" + dataRefreshHandler.getClass().getSimpleName() + "@" + e.getMessage();
    }

    private void markRefreshSuccess(TzsDataRefreshMessage message, IDataRefreshHandler dataRefreshHandler) {
        message.setSuccessDistributionHandler(message.getSuccessDistributionHandler() == null ? dataRefreshHandler.getClass().getSimpleName() : message.getSuccessDistributionHandler() + ";" + dataRefreshHandler.getClass().getSimpleName());
        updateMessageStatus(message);
    }

    private void markRefreshFailure(TzsDataRefreshMessage message, IDataRefreshHandler dataRefreshHandler, Exception e) {
        message.setErrorMsg(buildErrorMsg(dataRefreshHandler, message, e));
        message.setFailedDistributions(message.getFailedDistributions() == null ? 1 : message.getFailedDistributions() + 1);
        updateMessageStatus(message);
    }


    private void updateMessageStatus(TzsDataRefreshMessage message) {
        message.setRecDate(new Date());
        refreshMessageService.saveOrUpdate(message);
    }
}
