package com.yeejoin.amos.patrol.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum CheckStatisticsTypeEnum {
	 PLAN("巡检计划",0),
	 ROUTE("巡检路线",1),
	 POINT("巡检点",2),
	 DEPARTMENT("巡检部门",3),
	 INSPECTORS("巡检人员",4),
	 TASKMONTH("任务日期",5),
	 TASTTIME("任务月份",6);
	/**
	 * 名称
	 */
	private String name;

	/**
	 * 值
	 */
	private int value;
	


	private CheckStatisticsTypeEnum(String name, int value) {
		this.name = name;
		this.value = value;
	}


	public static String getName(int value) {
		for (CheckStatisticsTypeEnum c : CheckStatisticsTypeEnum.values()) {
			if (c.getValue() == value) {
				return c.name;
			}
		}
		return null;
	}
	
	public static int getValue(String name) {
		for (CheckStatisticsTypeEnum c : CheckStatisticsTypeEnum.values()) {
			if (c.getName().equals(name)) {
				return c.value;
			}
		}
		return -1;
	}


	public static CheckStatisticsTypeEnum getEnum(int value) {
		for (CheckStatisticsTypeEnum c : CheckStatisticsTypeEnum.values()) {
			if (c.getValue() == value) {
				return c;
			}
		}
		return null;
	}


	public static CheckStatisticsTypeEnum getEnum(String name) {
		for (CheckStatisticsTypeEnum c : CheckStatisticsTypeEnum.values()) {
			if (c.getName().equals(name)) {
				return c;
			}
		}
		return null;
	}
	
	public static List<Map<String,String>> getEnumList() {
		List<Map<String,String>> nameList = new ArrayList<>();
		for (CheckStatisticsTypeEnum c: CheckStatisticsTypeEnum.values()) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("name", c.getName());
			map.put("value", c.getValue() +"");
			nameList.add(map);
		}
		return nameList;
	}

	public String getName() {
		return name;
	}


	public void setName(String name) {
		this.name = name;
	}


	public int getValue() {
		return value;
	}


	public void setValue(int value) {
		this.value = value;
	}
}
