package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.maintenanceContract;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jg.api.entity.JgMaintenanceContract;
import com.yeejoin.amos.boot.module.jg.api.entity.JgMaintenanceContractEq;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgMaintenanceContractEqServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgMaintenanceContractServiceImpl;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Getter
public class MaintenanceContractEditUpdateService {

    private final JgMaintenanceContractServiceImpl maintenanceContractService;

    private final JgMaintenanceContractEqServiceImpl maintenanceContractEqService;

    public Set<String> getEqsByApplyNo(String applyNo) {
        JgMaintenanceContract maintenanceContract = maintenanceContractService.getOne(new LambdaQueryWrapper<JgMaintenanceContract>().eq(JgMaintenanceContract::getApplyNo, applyNo).select(BaseEntity::getSequenceNbr));
        List<JgMaintenanceContractEq> eqs = maintenanceContractEqService.list(new LambdaQueryWrapper<JgMaintenanceContractEq>().eq(JgMaintenanceContractEq::getEquipTransferId, maintenanceContract.getSequenceNbr()).select(JgMaintenanceContractEq::getEquId, BaseEntity::getSequenceNbr));
        return eqs.stream().map(JgMaintenanceContractEq::getEquId).collect(Collectors.toSet());
    }

    public JgMaintenanceContract getOneByApplyNo(String applyNo) {
        return maintenanceContractService.getOne(new LambdaQueryWrapper<JgMaintenanceContract>().eq(JgMaintenanceContract::getApplyNo, applyNo));
    }

}