package com.yeejoin.amos.boot.module.jg.biz.edit.typeHandler;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.typeHandler.TypeHandler;
import com.yeejoin.amos.boot.module.ymt.api.entity.EquipmentCategory;
import com.yeejoin.amos.boot.module.ymt.api.mapper.EquipmentCategoryMapper;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 特种设备目录处理器
 */
@Component("equipCategoryTypeHandler")
@RequiredArgsConstructor
public class EquipCategoryTypeHandler implements TypeHandler<String> {
    private final Map<String, String> CODE_NAME_MAP = new ConcurrentHashMap<>();

    private final EquipmentCategoryMapper equipmentCategoryMapper;

    @Override
    public String handle(String code) {
        return code != null ? CODE_NAME_MAP.computeIfAbsent(code, (k) -> {
            EquipmentCategory equipmentCategory = equipmentCategoryMapper.selectOne(new LambdaQueryWrapper<EquipmentCategory>().eq(EquipmentCategory::getCode, code).select(EquipmentCategory::getName, EquipmentCategory::getId));
            return Optional.ofNullable(equipmentCategory).map(EquipmentCategory::getName).orElse("");
        }) : null;
    }
}
