package com.yeejoin.amos.boot.module.cylinder.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.cylinder.api.dto.CylinderFillingMessageModel;
import com.yeejoin.amos.boot.module.cylinder.api.dto.PageParam;
import com.yeejoin.amos.boot.module.cylinder.api.mapper.CylinderFillingMessageMapper;
import com.yeejoin.amos.boot.module.cylinder.api.entity.CylinderFillingMessageEntity;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.RegionModel;
import joptsimple.internal.Strings;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.text.DecimalFormat;
import java.util.*;
import java.util.stream.Collectors;

@Component
public class CylinderFillingMessageService extends BaseService<CylinderFillingMessageModel, CylinderFillingMessageEntity, CylinderFillingMessageMapper> {
    public IPage<CylinderFillingMessageModel> getUploadCylinderLogs(PageParam pageParam, String regionCode) {
        CompanyModel result = Privilege.companyClient.queryByCompanyCode(regionCode).getResult();
        Page<CylinderFillingMessageModel> page = new Page<>(pageParam.getCurrent(), pageParam.getSize());
        return getUploadCylinderLogsByOrgCode(page, result.getOrgCode());
    }

    public IPage<CylinderFillingMessageModel> getUploadCylinderLogsByOrgCode( Page<CylinderFillingMessageModel> page, @Condition(Operator.likeRight) String orgCode) {
        return queryForPage(page, null, false, orgCode);
    }


}
