package com.yeejoin.amos.fas.business.action.model;

import com.yeejoin.amos.component.rule.Label;
import com.yeejoin.amos.component.rule.RuleFact;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@RuleFact(value = "风险点",project = "风险管控")
@Data
public class RiskSourceRo extends BasicsRo {


    private static final long serialVersionUID = 1L;

    @Label("风险点id")
    private String id;

    /**
     * 风险点名称
     */
    
    private String name;
    /**
     * 风险点编号
     */
    @Label("风险点编号")
    private String code;
    /**
     * 风险点来源（ProtalDataRo、FireEquimentDataRo、child）
     */
    @Label("风险点来源")
    private String from;
    /**
     * 状态
     */
    @Label("风险源状态（巡检点/设备）")
    private String nodeState;//风险源状态
    /**
     * 上一次状态
     */
    private String originalNodeState;
    /**
     * 风险点级别
     */
    @Label("级别")
    private Integer riskLevel;
    /**
     * RPNr值
     */
    @Label("rpn")
    private BigDecimal rpn;
    /**
     * RPNi值
     */
    @Label("rpni")
    private BigDecimal rpni;

    /**
     * 风险因素，多条换行
     */
    @Label("风险因素")
    private String riskFactor;

    /**
     * 是否区域节点
     */
    @Label("是否区域节点")
    private String  isRegion;


    @Label("区域下已触发风险点最高级别")
    private Integer regionMaxLevel;

    /**
     * 计算RPNi值，保存所有风险因素得i值，key统一为：rpni
     */
    @Label("RPNiSum")
    private List<BigDecimal> RPNiSum;
    /**
     * 计算RPNr值
     */
    @Label("风险点状态")
    private String riskState;//风险点状态

    private BigDecimal rg;

    /**
     * up、down、no
     */
    @Label("等级变化类型")
    private String levelChangeType;

}
