package com.yeejoin.amos.boot.module.common.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.common.api.dto.FireStationDto;
import com.yeejoin.amos.boot.module.common.api.dto.FireStationzhDto;
import com.yeejoin.amos.boot.module.common.api.dto.RequestData;
import com.yeejoin.amos.boot.module.common.api.entity.FireStation;

import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

/**
* 微型消防站 Mapper 接口
*
* @author system_generator
* @date 2021-06-28
*/
public interface FireStationMapper extends BaseMapper<FireStation> {

	// 微型消防站按时间倒叙排列add order by cb_fire_station.rec_date desc  2021-09-08 by kongfm

	@Select("<script>"
			+ "select * from  cb_fire_station  where cb_fire_station.is_delete=0 "
			+ "<if test='par.name!=null'> and cb_fire_station.name like  CONCAT('%',#{par.name},'%') </if>"	
			+ "<if test='par.bizCompanyId!=null'> and cb_fire_station.biz_company_id = #{par.bizCompanyId} </if>"
			+ "<if test='par.bizCompanyCode!=null'> and cb_fire_station.biz_company_code like  CONCAT('',#{par.bizCompanyCode},'%') </if>"
			+" order by cb_fire_station.rec_date desc limit  #{pageNum},#{pageSize}"
			+ "</script>")	
	List<FireStationDto>getFireStation(@Param("pageNum")int pageNum,@Param("pageSize")int pageSize,@Param("par")FireStationDto par);
	@Select("<script>"
			+ "select COUNT(cb_fire_station.sequence_nbr) num from  cb_fire_station  where cb_fire_station.is_delete=0 "
			+ "<if test='par.name!=null'> and cb_fire_station.name like  CONCAT('%',#{par.name},'%') </if>"	
			+ "<if test='par.bizCompanyId!=null'> and cb_fire_station.biz_company_id = #{par.bizCompanyId} </if>"
			+ "<if test='par.bizCompanyCode!=null'> and cb_fire_station.biz_company_code like  CONCAT('',#{par.bizCompanyCode},'%') </if>"
			+ "</script>")	
	 Map<String, Long> getFireStationCount(@Param("par")FireStationDto par);



	/***
	 *
	 * 指挥系统 -微型消防站资源 列表
	 *
	 * **/
	List<FireStationzhDto> getStationList(@Param("pageNum")int pageNum, @Param("pageSize")int pageSize, @Param("par") RequestData par);
	/***
	 *
	 * 指挥系统 -微型消防站资源统计
	 *
	 * **/
	Integer getStationListCount(@Param("par")RequestData par);
}
