package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.jcs.api.entity.PowerrTransferLog;
import com.yeejoin.amos.boot.module.jcs.api.mapper.PowerrTransferLogMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.IPowerrTransferLogService;
import com.yeejoin.amos.boot.module.jcs.api.dto.PowerrTransferLogDto;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;

/**
 * 力量调派发送信息记录表服务实现类
 *
 * @author litw
 * @date 2021-11-05
 */
@Service
public class PowerrTransferLogServiceImpl extends BaseService<PowerrTransferLogDto,PowerrTransferLog,PowerrTransferLogMapper> implements IPowerrTransferLogService {
    /**
     * 分页查询
     */
    public Page<PowerrTransferLogDto> queryForPowerrTransferLogPage(Page<PowerrTransferLogDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<PowerrTransferLogDto> queryForPowerrTransferLogList()   {
        return this.queryForList("" , false);
    }

    @Override
    public PowerrTransferLogDto selectOneDetails(Long id, String type) {
        // 队伍
        if("0".equals(type)) {
            LambdaQueryWrapper<PowerrTransferLog> queryWrapper = new LambdaQueryWrapper<>();
            PowerrTransferLogDto dto = new PowerrTransferLogDto();
            queryWrapper.eq(PowerrTransferLog::getTeamId,id);
            List<PowerrTransferLog> list = this.list(queryWrapper);
            list.stream().forEach(e->{
                dto.setReceiveName(dto.getRecUserName() == null ? "".concat(e.getReceiveName()) : dto.getReceiveName().concat("/").concat(e.getReceiveName()) );
                dto.setSendTime(e.getSendTime());
                dto.setSendContent(e.getSendContent());
                dto.setRecUserName(e.getReceiveName());
            });
            return dto;
        }

        // 资源
        if("1".equals(type)) {
            LambdaQueryWrapper<PowerrTransferLog> queryWrapper = new LambdaQueryWrapper<>();
            PowerrTransferLogDto dto = new PowerrTransferLogDto();
            queryWrapper.eq(PowerrTransferLog::getTeamId,id);
            PowerrTransferLog powerrTransferLog = this.getOne(queryWrapper);
            Bean.toPo(powerrTransferLog,dto);
            return dto;
        }

        return new PowerrTransferLogDto();
    }
}