package com.yeejoin.amos.boot.module.elevator.api.dto;

import java.util.Date;
import java.util.List;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.elevator.api.entity.TzsJgFile;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 特种设备基本信息-设计信息Dto
 *
 * @author duanwei
 * @date 2022-07-26
 */
@Data
public class TzsJgDesignInfoDto extends BaseDto {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "id")
	/**
	 * id
	 */
	private Long sequenceNbr;
	@ApiModelProperty(value = "设备唯一标识码")
	/**
	 * 设备唯一标识码
	 */
	private String sequenceCode;
	@ApiModelProperty(value = "监管系统唯一编码(监管系统对接标识)")
	/**
	 * 监管系统唯一编码(监管系统对接标识)
	 */
	private String superviseCode;
	@ApiModelProperty(value = "设计单位统一社会信用代码")
	/**
	 * 设计单位统一社会信用代码
	 */
	private String designUnitCreditCode;
	@ApiModelProperty(value = "设计单位名称")
	/**
	 * 设计单位名称
	 */
	private String designUnitName;
	@ApiModelProperty(value = "设计许可编号")
	/**
	 * 设计许可编号
	 */
	private String designLicenseNum;
	@ApiModelProperty(value = "设计使用年限")
	/**
	 * 设计使用年限
	 */
	private Integer designUseDate;
	@ApiModelProperty(value = "设计日期")
	/**
	 * 设计日期
	 */
	private Date designDate;
	@ApiModelProperty(value = "总图图号")
	/**
	 * 总图图号
	 */
	private String drawingDo;
	@ApiModelProperty(value = "设计文件鉴定单位")
	/**
	 * 设计文件鉴定单位
	 */
	private String appraisalUnit;
	@ApiModelProperty(value = "设计文件鉴定日期")
	/**
	 * 设计文件鉴定日期
	 */
	private Date appraisalDate;
	@ApiModelProperty(value = "同步时间")
	/**
	 * 同步时间
	 */
	private Date syncDate;
	@ApiModelProperty(value = "同步状态（0-新增   1-更新   2-删除）")
	/**
	 * 同步状态（0-新增 1-更新 2-删除）
	 */
	private Integer syncState;
	@ApiModelProperty(value = "对接公司编码")
	/**
	 * 对接公司编码
	 */
	private String appId;
	@ApiModelProperty(value = "创建时间")
	/**
	 * 创建时间
	 */
	private Date recDate;
	@ApiModelProperty(value = "操作人员")
	/**
	 * 操作人员
	 */
	private String recUserId;

	List<TzsJgFile> designFile;

	List<TzsJgFile> designCode;
}
