package com.yeejoin.amos.boot.module.jyjc.biz.rule;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.io.Serializable;
import java.util.Map;

/**
 * @author LiuLin
 * @date 2024年01月02日 16:47
 */
@Data
@ApiModel(value = "InspectionEquipInfo")
public class InspectionEquipInfo implements Serializable {

    @ApiModelProperty(value = "请求唯一标识")
    private String componentKey;

    @ApiModelProperty(value = "设备ID")
    private String record;

    @ApiModelProperty(value = "检验类型（大类与菜单对应）")
    private String bizType;

    @ApiModelProperty(value = "技术参数")
    private Map<String, Object> techParams;

    @ApiModelProperty(value = "是否防爆")
    private Boolean isAntiExplosion;

    @ApiModelProperty(value = "设备品种")
    private String equDefine;

    @ApiModelProperty(value = "设备类别")
    private String equCategory;

    @ApiModelProperty(value = "设备种类")
    private String equList;

    @ApiModelProperty(value = "检验类型（小类）")
    private String inspectionType;
}
