package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.ymt.api.dto.TzBaseEnterpriseInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzBaseEnterpriseInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzsUserInfo;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.TzBaseEnterpriseInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.TzsUserInfoMapper;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.TaskV2Model;
import com.yeejoin.amos.feign.workflow.model.FlowTaskVo;
import com.yeejoin.amos.feign.workflow.model.ProcessTaskDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.*;
import java.util.stream.Collectors;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

@Service
public class CommonserviceImpl {

    @Value("${jyjc.user-post:6615}")
    private String jyjcUserPost;

    @Value("${jyjc.user-post:6616}")
    private String jyjcBizUserPost;
    @Autowired
    RedisUtils redisUtils;
    @Autowired
    TzsUserInfoMapper userInfoMapper;
    @Autowired
    private WorkflowHelper workflowHelper;

    @Autowired
    TzBaseEnterpriseInfoMapper enterpriseInfoMapper;

    public static final String UNIT_TYPE = "检验检测机构";

    /**
     * @return ReginParams
     * @description 获取当前用户注册信息
     */
    public ReginParams getReginParamsOfCurrentUser() {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        return reginParams;
    }

    public List<TzsUserInfo> getUserInfosByUnitCode(String unitCode) {
        QueryWrapper userInfoQueryWrapper = new QueryWrapper<>();
        userInfoQueryWrapper.eq("unit_code", unitCode);
        userInfoQueryWrapper.like("post", jyjcUserPost);
        userInfoQueryWrapper.eq("is_delete",false);
        List<TzsUserInfo> userInfos = userInfoMapper.selectList(userInfoQueryWrapper);
        return userInfos;
    }

    public List<TzsUserInfo> getBizUserInfosByUnitCode(String unitCode) {
        QueryWrapper userInfoQueryWrapper = new QueryWrapper<>();
        userInfoQueryWrapper.eq("unit_code", unitCode);
        userInfoQueryWrapper.like("post", jyjcBizUserPost);
        userInfoQueryWrapper.isNotNull("amos_user_id");
        userInfoQueryWrapper.eq("is_delete",false);
        List<TzsUserInfo> userInfos = userInfoMapper.selectList(userInfoQueryWrapper);
        return userInfos;
    }

    public List<TzsUserInfo> getUserPhonesByPersonCode(String personCode) {
        List<String> ids = StrUtil.split(personCode, ",");
        QueryWrapper userInfoQueryWrapper = new QueryWrapper<>();
        userInfoQueryWrapper.in("sequence_nbr", ids);

        List<TzsUserInfo> userInfos = userInfoMapper.selectList(userInfoQueryWrapper);
        return userInfos;
    }


    public List<TzBaseEnterpriseInfoDto> getInspectionUnitList() {
        return enterpriseInfoMapper.getInspectionUnitList(UNIT_TYPE);
    }

    public TzBaseEnterpriseInfo getInspectionUnitBySequenceNbr(Long sequenceNbr) {
        return enterpriseInfoMapper.selectBySeq(sequenceNbr);
    }


    public void buildTaskModel(Map<String, Object> params){
        TaskV2Model model = new TaskV2Model();
        //获取待办任务执行人
        Map<String, Object> nextNodeInfo = workflowHelper.getNextWorkflowNode(params.get("instanceId").toString());
        String role = (String) nextNodeInfo.get("role");
        model.setExecuteUserIds(role);
        List<AgencyUserModel> userList = Privilege.agencyUserClient
                .queryByRoleId(role, null,false).getResult();
        List<String> userIds = userList.stream().map(AgencyUserModel::getUserId).collect(Collectors.toList());
        model.setExecuteUserIds(CollectionUtils.isEmpty(userIds)?"": String.join(",",userIds));
        model.setExtras(params.getOrDefault("extras","").toString());
        model.setRelationId(params.getOrDefault("instanceId","").toString());
        model.setRoutePath(params.getOrDefault("routePath","").toString());
        model.setStartDate((Date) params.getOrDefault("startDate",""));
        model.setStartUserId(params.getOrDefault("startUserId","").toString());
        model.setTaskContent(params.getOrDefault("taskContent","").toString());
        model.setTaskType(params.getOrDefault("taskType","").toString());
        model.setTaskTypeLabel(params.getOrDefault("taskTypeLabel","").toString());
        model.setTaskTitle(params.getOrDefault("taskTitle","").toString());
        model.setTaskName(params.getOrDefault("taskName","").toString());
        model.setTaskStatus(Integer.valueOf(params.getOrDefault("taskStatus",0).toString()));
        model.setTaskStatusLabel(params.getOrDefault("taskStatusLabel","").toString());
        model.setTaskSource(params.getOrDefault("taskSource","workFlow").toString());
        // model.setTerminal(params.getOrDefault("terminal","WEB").toString());
        model.setCreateDate(new Date());
        //model.setFinishStatus(false);
        model.setTaskCode(params.get("taskCode").toString());
        model.setRecUserId(params.get("userId").toString());
        model.setAgencyCode(params.get("agencyCode").toString());
        Systemctl.taskV2Client.create(model);
    }


    public TaskV2Model  updateTaskModel(Map<String, Object> params){
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);

        List<TaskV2Model> result =Systemctl.taskV2Client.selectListByRelationId(params.get("relationId").toString()).getResult();
        TaskV2Model model = result.stream().sorted((r1, r2) -> r2.getCreateDate().compareTo(r1.getCreateDate())) // 按时间降序排序
                .findFirst()
                .orElse(null);
        model.setTaskStatus(Integer.valueOf(params.get("taskStatus").toString()));
        model.setTaskStatusLabel(params.get("taskStatusLabel").toString());
        model.setEndUserId(reginParams.getUserModel().getUserId());
        model.setEndDate(new Date());
        model.setRoutePath(model.getRoutePath().replace("roleIds","role").replace("edit","look"));
        //model.setFinishStatus(true);
        Systemctl.taskV2Client.update(model,model.getSequenceNbr());

        //修改model并返回 用于组装新待办
        model.setEndUserId(null);
        model.setTaskStatus(null);
        model.setEndDate(null);
        model.setSequenceNbr(null);
        //model.setCreateUserId(reginParams.getUserModel().getUserId());
        model.setCreateDate(new Date());
        model.setTaskStatus(FlowStatusEnum.REJECTED.getCode());
        model.setTaskStatusLabel(FlowStatusEnum.REJECTED.getName());
        model.setStartDate(new Date());
        return model;
    }

    @Async
    public  void sendMessage(HashMap<String,String> smsParams, List<String> phones){
        for (String phone : phones) {
            smsParams.put("mobile",phone);
            Systemctl.smsClient.sendCommonSms(smsParams);
        }
    }

    public void  deleteTaskModel(String id){
        List<TaskV2Model> result =Systemctl.taskV2Client.selectListByRelationId(id).getResult();
        TaskV2Model model = result.stream().sorted((r1, r2) -> r2.getCreateDate().compareTo(r1.getCreateDate())) // 按时间降序排序
                .findFirst()
                .orElse(null);
        Systemctl.taskV2Client.delete(String.valueOf(model.getSequenceNbr()));

    }

    public  <T> String toQueryParams(T obj) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();

        for (Class<?> clazz = obj.getClass(); !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();

            for (Field field : fields) {
                if (!Modifier.isStatic(field.getModifiers())) {
                    field.setAccessible(true);

                    try {
                        Object value = field.get(obj);

                        if (value != null && !"".equals(value)) {
                            String encodedValue = URLEncoder.encode(value.toString(), "UTF-8");
                            sb.append(field.getName()).append('=').append(encodedValue).append('&');
                        }
                    } catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }

        return sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "";
    }

}
