package com.yeejoin.precontrol.common.dto;

import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 作业活动
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
public class TaskDto extends BaseDto{
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "任务id")
    private Long id;
    @ApiModelProperty(value = "所属项目id")
    private Long projectId;
    @ApiModelProperty(value = "项目名称")
    private String projectName;
    @ApiModelProperty(value = "作业类型")
    private Long type;
    @ApiModelProperty(value = "发起人id")
    private Long createPersonId;
    @ApiModelProperty(value = "任务状态")
    private Long status;
    @ApiModelProperty(value = "任务单号")
    private Long taskNo;
    @ApiModelProperty(value = "文件")
    @ImagePrefix
    private List<FileDto> file;
    @ApiModelProperty(value = "作业交底")
    private JobDisclosureDto jobDisclosure;
    @ImagePrefix
    @ApiModelProperty(value = "三交三查数据")
    private TaskPaycheckDto taskPaycheck;
    @ApiModelProperty(value = "违规管理")
    private BadManangerDto badMananger;

    @ApiModelProperty(value = "未完成任务的当前状态")
    private Long currentStatus;
    @ApiModelProperty(value = "风险作业确认状态")
    private Long riskStatus;
    @ApiModelProperty(value = "检查项确认状态")
    private Long builderStatus;
}
