/* 表结构 */

-- ----------------------------
-- Table structure for knowledge_doc_category
-- ----------------------------
DROP TABLE IF EXISTS `knowledge_doc_category`;
CREATE TABLE `knowledge_doc_category` (
  `SEQUENCE_NBR` bigint(20) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `REC_USER_ID` varchar(32) NOT NULL,
  `CATEGORY_NAME` varchar(100) NOT NULL COMMENT '分组名称',
  `PARENT_ID` bigint(20) NOT NULL,
  `AGENCY_CODE` varchar(100) NOT NULL COMMENT '机构编号',
  PRIMARY KEY (`SEQUENCE_NBR`)
) ENGINE=InnoDB  COMMENT='知识库文档分类';

-- ----------------------------
-- Table structure for knowledge_doc_comments
-- ----------------------------
DROP TABLE IF EXISTS `knowledge_doc_comments`;
CREATE TABLE `knowledge_doc_comments` (
  `SEQUENCE_NBR` bigint(20) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `REC_USER_ID` varchar(32) NOT NULL,
  `DOC_SEQ` bigint(20) NOT NULL COMMENT '文档id',
  `USER_ID` varchar(64) NOT NULL COMMENT '发表评论的用户id',
  `COMMENTS_CONTENT` varchar(500) NOT NULL COMMENT '评论内容',
  `PARENT_ID` bigint(20) NOT NULL COMMENT '父级评论id',
  `AGENCY_CODE` varchar(100) NOT NULL COMMENT '机构编号',
  PRIMARY KEY (`SEQUENCE_NBR`)
) ENGINE=InnoDB  COMMENT='知识库评论信息';

-- ----------------------------
-- Table structure for knowledge_doc_content
-- ----------------------------
DROP TABLE IF EXISTS `knowledge_doc_content`;
CREATE TABLE `knowledge_doc_content` (
  `SEQUENCE_NBR` bigint(20) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `REC_USER_ID` varchar(32) DEFAULT NULL,
  `HTML_CONTENT` mediumtext NOT NULL COMMENT '富文本内容存储',
  `DOC_STATUS` varchar(32) NOT NULL COMMENT '文档状态：发布,未发布',
  `USER_ID` varchar(64) NOT NULL COMMENT '发布者',
  `CREATE_TIME` datetime NOT NULL COMMENT '创建时间',
  `HAVE_ATTACHMENT` bit(1) NOT NULL COMMENT '是否有附件',
  `SUMMARY` varchar(500) NOT NULL COMMENT '摘要',
  `AGENCY_CODE` varchar(100) NOT NULL COMMENT '机构编号',
  `AUDIT_STATUS` varchar(64) DEFAULT NULL COMMENT '审核状态:通过,驳回,待审核,待提交',
  `REJECTION_COMMENT` varchar(500) DEFAULT NULL COMMENT '驳回意见',
  `AUDITOR_USER_ID` varchar(64) DEFAULT NULL COMMENT '审核人id',
  `ORG_CODE` varchar(64) NOT NULL COMMENT '数据过滤选项',
  `TEXT_CONTENT` MEDIUMTEXT NULL   COMMENT '纯文本内容',
  `SORT_STR` VARCHAR(200) NULL   COMMENT '自定义排序规则生成文本值',
  PRIMARY KEY (`SEQUENCE_NBR`)
) ENGINE=InnoDB  COMMENT='知识库文档存储';

-- ----------------------------
-- Table structure for knowledge_dynamics_group
-- ----------------------------
DROP TABLE IF EXISTS `knowledge_dynamics_group`;
CREATE TABLE `knowledge_dynamics_group` (
  `SEQUENCE_NBR` bigint(20) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `REC_USER_ID` varchar(32) NOT NULL,
  `GROUP_NAME` varchar(100) NOT NULL COMMENT '分组名称',
  `FRONT_END_CONFIG` text COMMENT '前端配置',
  `FUNCTIONAL` varchar(100) NOT NULL COMMENT '功能标识',
  `AGENCY_CODE` varchar(100) NOT NULL COMMENT '机构编号',
  `APP_KEY` varchar(100) NOT NULL COMMENT 'APPKEY',
  PRIMARY KEY (`SEQUENCE_NBR`),
  UNIQUE KEY `knowledge_dynamics_group_FUNCTIONAL_IDX` (`FUNCTIONAL`,`APP_KEY`) USING BTREE
) ENGINE=InnoDB  COMMENT='知识库系统动态选项配置的分组,用于区分不同功能的字段列表';

-- ----------------------------
-- Table structure for knowledge_dynamics_option
-- ----------------------------
DROP TABLE IF EXISTS `knowledge_dynamics_option`;
CREATE TABLE `knowledge_dynamics_option` (
  `SEQUENCE_NBR` bigint(20) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `REC_USER_ID` varchar(32) NOT NULL,
  `FIELD_NAME` varchar(100) NOT NULL COMMENT '字段名',
  `FIELD_LABEL` varchar(100) NOT NULL COMMENT '中文名',
  `DATA_TYPE` varchar(100) NOT NULL COMMENT '数据类型：文本,数字,枚举,日期',
  `FUNCTIONAL` varchar(64) NOT NULL COMMENT '功能标识',
  `FRONT_END_CONFIG` varchar(1000) DEFAULT NULL,
  `AGENCY_CODE` varchar(100) NOT NULL COMMENT '机构编号',
  `APP_KEY` varchar(100) NOT NULL COMMENT '业务项目标识',
  `GROUP_SEQ` bigint(20) NOT NULL COMMENT '字段分组主键',
  `QUERY_STRATEGY` varchar(100) DEFAULT NULL COMMENT '查询策略;全等,模糊,区间',
  PRIMARY KEY (`SEQUENCE_NBR`)
) ENGINE=InnoDB  COMMENT='知识库系统动态选项配置,多用于动态字段配置';

-- ----------------------------
-- Table structure for knowledge_dynamics_value
-- ----------------------------
DROP TABLE IF EXISTS `knowledge_dynamics_value`;
CREATE TABLE `knowledge_dynamics_value` (
  `SEQUENCE_NBR` bigint(20) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `REC_USER_ID` varchar(32) NOT NULL,
  `FIELD_NAME` varchar(100) NOT NULL COMMENT '字段名',
  `FIELD_LABEL` varchar(100) NOT NULL COMMENT '中文名',
  `DATA_TYPE` varchar(100) NOT NULL COMMENT '数据类型：文本,数字,枚举,日期',
  `GROUP_SEQ` bigint(20) NOT NULL COMMENT '字段分组id',
  `FIELD_VALUE` varchar(500) NOT NULL COMMENT '动态配置字段的值',
  `INSTANCE_ID` bigint(20) NOT NULL COMMENT '关联的对象id,即文档id',
  `AGENCY_CODE` varchar(100) NOT NULL COMMENT '机构编号',
  `OPTION_SEQ` bigint(20) NOT NULL COMMENT '字段定义信息的主键',
  `QUERY_STRATEGY` varchar(100) NOT NULL COMMENT '查询策略;全等,模糊,区间',
  PRIMARY KEY (`SEQUENCE_NBR`)
) ENGINE=InnoDB  COMMENT='知识库系统动态选项配置的实例值';

-- ----------------------------
-- Table structure for knowledge_interaction_count
-- ----------------------------
DROP TABLE IF EXISTS `knowledge_interaction_count`;
CREATE TABLE `knowledge_interaction_count` (
  `SEQUENCE_NBR` bigint(20) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `REC_USER_ID` varchar(32) NOT NULL,
  `OPERATE_TYPE` varchar(64) NOT NULL COMMENT '操作类型(标签所有情况引用,标签被已审核/已发布文档引用,文档引用)',
  `ENTITY_TYPE` varchar(100) NOT NULL COMMENT '关联对象类型',
  `ENTITY_ID` varchar(100) NOT NULL COMMENT '关联对象id',
  `OPERATE_COUNT` int(11) NOT NULL COMMENT '计数',
  `AGENCY_CODE` varchar(100) DEFAULT NULL COMMENT '机构编号',
  PRIMARY KEY (`SEQUENCE_NBR`)
) ENGINE=InnoDB  COMMENT='知识库内容交互计数表';

-- ----------------------------
-- Table structure for knowledge_interaction_record
-- ----------------------------
DROP TABLE IF EXISTS `knowledge_interaction_record`;
CREATE TABLE `knowledge_interaction_record` (
  `SEQUENCE_NBR` bigint(20) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `REC_USER_ID` varchar(32) NOT NULL,
  `USER_ID` varchar(64) NOT NULL COMMENT '用户id',
  `OPERATE_TYPE` varchar(64) NOT NULL COMMENT '操作类型(点赞,吐槽,收藏)',
  `ENTITY_TYPE` varchar(100) NOT NULL COMMENT '关联对象类型',
  `ENTITY_ID` varchar(100) NOT NULL COMMENT '关联对象id',
  `AGENCY_CODE` varchar(100) NOT NULL COMMENT '机构编号',
  PRIMARY KEY (`SEQUENCE_NBR`)
) ENGINE=InnoDB  COMMENT='知识库内容交互记录';

-- ----------------------------
-- Table structure for knowledge_tag
-- ----------------------------
DROP TABLE IF EXISTS `knowledge_tag`;
CREATE TABLE `knowledge_tag` (
  `SEQUENCE_NBR` bigint(20) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `REC_USER_ID` varchar(32) NOT NULL,
  `TAG_NAME` varchar(100) NOT NULL COMMENT '标签名称',
  `TAG_CODE` varchar(100) DEFAULT NULL COMMENT '标签编码',
  `TAG_TYPE` varchar(100) NOT NULL COMMENT '标签分类：文本标签,值标签,',
  `TAG_STATUS` varchar(32) NOT NULL COMMENT '标签状态：启用,禁用',
  `TAG_REMARK` varchar(100) DEFAULT NULL COMMENT '标签备注',
  `CREATOR` varchar(32) NOT NULL COMMENT '创建人',
  `AGENCY_CODE` varchar(100) NOT NULL COMMENT '机构编号',
  PRIMARY KEY (`SEQUENCE_NBR`) USING BTREE
) ENGINE=InnoDB  ROW_FORMAT=DYNAMIC COMMENT='标签库';

-- ----------------------------
-- Table structure for knowledge_tag_group
-- ----------------------------
DROP TABLE IF EXISTS `knowledge_tag_group`;
CREATE TABLE `knowledge_tag_group` (
  `SEQUENCE_NBR` bigint(20) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `REC_USER_ID` varchar(32) NOT NULL,
  `GROUP_NAME` varchar(100) NOT NULL COMMENT '标签分类名称',
  `PARENT_ID` bigint(20) NOT NULL COMMENT '父级分类id',
  `AGENCY_CODE` varchar(100) NOT NULL COMMENT '机构编号',
  PRIMARY KEY (`SEQUENCE_NBR`)
) ENGINE=InnoDB  COMMENT='标签分组';

-- ----------------------------
-- Table structure for knowledge_tag_group_ref
-- ----------------------------
DROP TABLE IF EXISTS `knowledge_tag_group_ref`;
CREATE TABLE `knowledge_tag_group_ref` (
  `SEQUENCE_NBR` bigint(20) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `REC_USER_ID` varchar(32) NOT NULL,
  `GROUP_SEQ` bigint(20) NOT NULL COMMENT '标签分组id',
  `TAG_SEQ` bigint(20) NOT NULL COMMENT '标签id',
  PRIMARY KEY (`SEQUENCE_NBR`)
) ENGINE=InnoDB  COMMENT='标签分组关系表';

-- ----------------------------
-- Table structure for knowledge_tag_instance
-- ----------------------------
DROP TABLE IF EXISTS `knowledge_tag_instance`;
CREATE TABLE `knowledge_tag_instance` (
  `SEQUENCE_NBR` bigint(20) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `REC_USER_ID` varchar(32) NOT NULL,
  `TAG_SEQ` bigint(20) NOT NULL COMMENT '标签id',
  `TARGET_SEQ` bigint(20) NOT NULL COMMENT '标签标记的目标id',
  `TAG_NAME` varchar(100) NOT NULL COMMENT '标签名称',
  `MARKING_TYPE` varchar(100) NOT NULL COMMENT '标记方式:文档,内容',
  `AGENCY_CODE` varchar(100) NOT NULL COMMENT '机构编号',
  `TAG_TYPE` varchar(100) NOT NULL COMMENT '标签类型',
  `FRONT_END_CONFIG` varchar(255) DEFAULT NULL COMMENT '前端配置存储',
  PRIMARY KEY (`SEQUENCE_NBR`)
) ENGINE=InnoDB  COMMENT='标签实例';

-- ----------------------------
-- Table structure for knowledge_tag_value
-- ----------------------------
DROP TABLE IF EXISTS `knowledge_tag_value`;
CREATE TABLE `knowledge_tag_value` (
  `SEQUENCE_NBR` bigint(20) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `REC_USER_ID` varchar(32) NOT NULL,
  `INSTANCE_SEQ` bigint(20) NOT NULL COMMENT '标签实例id',
  `FIELD_NAME` varchar(100) NOT NULL COMMENT '值标签的扩展字段名,内容标签文本位置,值标签文本内容/单值/日期,值标签范围最大值-最小值',
  `TAG_VALUE` varchar(2000) NOT NULL COMMENT '值标签扩展字段的值',
  `AGENCY_CODE` varchar(100) NOT NULL COMMENT '机构编号',
  `UNIT` varchar(16) DEFAULT NULL COMMENT '计量单位',
  PRIMARY KEY (`SEQUENCE_NBR`)
) ENGINE=InnoDB  COMMENT='值标签的实例值';

-- ----------------------------
-- Table structure for knowlege_statistics_record
-- ----------------------------
DROP TABLE IF EXISTS `knowlege_statistics_record`;
CREATE TABLE `knowlege_statistics_record` (
  `SEQUENCE_NBR` bigint(20) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `REC_USER_ID` varchar(32) DEFAULT NULL,
  `DOC_SEQ` bigint(20) NOT NULL COMMENT '文档ID',
  `DISASTER_TIME` datetime NOT NULL COMMENT '警情发生时间',
  `RECORD_NAME` varchar(100) NOT NULL COMMENT '记录类型',
  `CATEGORY_VALUE` varchar(200) DEFAULT NULL COMMENT '分类文本值',
  `COUNT_VALUE` bigint(20) NOT NULL DEFAULT '1' COMMENT '统计数值,统一用整型存储',
  `VALUE_WEIGHT` int(11) NOT NULL DEFAULT '1' COMMENT '值放大倍数',
  `UNIT` varchar(30) DEFAULT NULL COMMENT '值单位（备注属性）',
  PRIMARY KEY (`SEQUENCE_NBR`)
) ENGINE=InnoDB  COMMENT='文档各项统计数据';

-- ----------------------------
-- Table structure for knowledge_doc_annotate
-- ----------------------------
DROP TABLE IF EXISTS `knowledge_doc_annotate`;
CREATE TABLE `knowledge_doc_annotate` (
  `SEQUENCE_NBR` bigint(20) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `REC_USER_ID` varchar(32) CHARACTER SET utf8mb4  NOT NULL,
  `DOC_SEQ` bigint(20) NOT NULL COMMENT '文档id',
  `USER_ID` varchar(64) CHARACTER SET utf8mb4  NOT NULL COMMENT '发表评论的用户id',
  `ANNOTATE_CONTENT` varchar(500) CHARACTER SET utf8mb4 NOT NULL COMMENT '评论内容',
  `AGENCY_CODE` varchar(100) CHARACTER SET utf8mb4  NOT NULL COMMENT '机构编号',
  `POSITION_INFO` varchar(500) CHARACTER SET utf8mb4  NOT NULL,
  `CREATE_TIME` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`SEQUENCE_NBR`)
) ENGINE=InnoDB ;

-- ----------------------------
-- Table structure for knowledge_message
-- ----------------------------
DROP TABLE IF EXISTS `knowledge_message`;
CREATE TABLE `knowledge_message` (
  `SEQUENCE_NBR` bigint(20) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `REC_USER_ID` varchar(32) NOT NULL,
  `MESSAGE_TYPE` varchar(20) NOT NULL COMMENT '消息类型',
  `MESSAGE_TITLE` varchar(200) NOT NULL COMMENT '消息标题',
  `MESSAGE_CONTENT` text COMMENT '消息内容',
  `TARGET_SEQ` bigint(20) DEFAULT NULL COMMENT '关联的文档id',
  PRIMARY KEY (`SEQUENCE_NBR`)
) ENGINE=InnoDB   COMMENT='标签分组';

-- ----------------------------
-- Table structure for knowledge_message_personal
-- ----------------------------
DROP TABLE IF EXISTS `knowledge_message_personal`;
CREATE TABLE `knowledge_message_personal` (
  `SEQUENCE_NBR` bigint(20) NOT NULL,
  `REC_DATE` datetime NOT NULL,
  `REC_USER_ID` varchar(32) NOT NULL,
  `MESSAGE_OWNER` varchar(32) NOT NULL,
  `MESSAGE_SEQ` bigint(20) NOT NULL,
  `MESSAGE_STATUS` int(1) NOT NULL COMMENT '消息状态 0-未读/1-已读',
  PRIMARY KEY (`SEQUENCE_NBR`)
) ENGINE=InnoDB   COMMENT='标签分组';


-- 创建索引
ALTER TABLE `knowledge_doc_content`
  ADD INDEX `ORG_CODE` (`ORG_CODE`),
  ADD INDEX `REC_USER_ID` (`REC_USER_ID`),
  ADD INDEX `DOC_STATUS` (`DOC_STATUS`),
  ADD INDEX `AUDIT_STATUS` (`AUDIT_STATUS`),
  ADD INDEX `SORT_STR` (`SORT_STR`);

ALTER TABLE `knowledge_dynamics_value`
  ADD  INDEX `INSTANCE_ID` (`INSTANCE_ID`),
  ADD  INDEX `FIELD_NAME` (`FIELD_NAME`);

ALTER TABLE `knowledge_interaction_count`
  ADD  INDEX `OP_ET_EI` (`OPERATE_TYPE`, `ENTITY_TYPE`, `ENTITY_ID`),
  ADD  INDEX `ENTITY_ID` (`ENTITY_ID`);

ALTER TABLE `knowledge_interaction_record`
  ADD  INDEX `OT_ET_EI` (`OPERATE_TYPE`, `ENTITY_TYPE`, `ENTITY_ID`),
  ADD  INDEX `USER_ID` (`USER_ID`),
  ADD  INDEX `ENTITY_ID` (`ENTITY_ID`);

ALTER TABLE `knowledge_tag_instance`
  ADD  INDEX `TARGET_SEQ` (`TARGET_SEQ`) USING BTREE,
  ADD  INDEX `TAG_SEQ` (`TAG_SEQ`) USING BTREE;

ALTER TABLE `knowledge_tag_value`
  ADD  INDEX `INSTANCE_SEQ` (`INSTANCE_SEQ`) USING BTREE,
  ADD  INDEX `FIELD_NAME` (`FIELD_NAME`) USING BTREE;
