package com.yeejoin.amos.patrol.dao.entity;

import lombok.Data;
import org.hibernate.annotations.Where;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import java.util.Date;

/**
 * @author keyong
 * @title: LatentDanger
 * <pre>
 * @description: 隐患表
 * </pre>
 * @date 2021/1/26 14:03
 */
@Entity
@Table(name = "p_latent_danger")
@NamedQuery(name = "LatentDanger.findAll", query = "SELECT c FROM LatentDanger c")
@Where(clause = "deleted=0") //表示未删除的数据
@Data
public class LatentDanger extends BasicEntity {
    private static final long serialVersionUID = 1L;


    /**
     * 业务唯一标识
     */
    @Column(name = "business_key")
    private String businessKey;

    /**
     * 公司组织机构
     */
    @Column(name = "org_code")
    private String orgCode;

    /**
     * 隐患名称
     */
    @Column(name = "danger_name")
    private String dangerName;

    @Column(name = "instance_id")
    private String instanceId;

    @Column(name = "current_flow_record_id")
    private Long currentFlowRecordId;

    /**
     * 隐患等级（1：一般隐患；2：重大隐患；0：安全问题）
     */
    @Column(name = "danger_level")
    private Integer dangerLevel;

    /**
     * 隐患地点
     */
    @Column(name = "danger_position")
    private String dangerPosition;

    /**
     * 隐患类型（1：普通隐患；2：巡检隐患）
     */
    @Column(name = "danger_type")
    private Integer dangerType;

    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;

    /**
     * 整改类型（1：常规整改；2：安措计划；3：延期整改）
     */
    @Column(name = "reform_type")
    private Integer reformType;

    /**
     * 限制时间
     */
    @Column(name = "reform_limit_date")
    private Date reformLimitDate;

    @Column(name = "overtime_state")
    private Integer overtimeState;

    @Column(name = "reform_json")
    private String reformJson;

    /**
     * 隐患状态（1：待评审；2：待治理；3：安措计划中；4：逾期未治理；5：待验证；6：治理完毕；7：已撤销）
     */
    @Column(name = "danger_state")
    private Integer dangerState;

    /**
     * 发现人
     */
    @Column(name = "discoverer_user_id")
    private String discovererUserId;

    @Column(name = "discoverer_department_id")
    private String discovererDepartmentId;

    @Column(name = "photo_urls")
    private String photoUrls;

    /**
     * 是否删除（0：否；1：是）
     */
    @Column(name = "deleted")
    private Integer deleted;

    /**
     * 记录修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 延期治理时间
     */
    @Column(name = "delay_limit_date")
    private Date delayLimitDate;

    /**
     * 问题描述
     */
    @Column(name = "problem_description")
    private String problemDescription;

    /**
     * 原因分析
     */
    @Column(name = "reason_analysis")
    private String reasonAnalysis;

    /**
     * 举一反三
     */
    @Column(name = "infer_other_things")
    private String inferOtherThings;

    /**
     * 检查记录创建的隐患检查项对应id
     */
    @Column(name = "check_input_id")
    private Long checkInputId;

}
