package com.yeejoin.amos.supervision.common.enums;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum CheckTypeSuEnum {

    TIME_DESC("日常检查", "1"),
    TIME_ASC("专项检查", "2");

    /**
     * 名字
     */
    private String name;
    /**
     * 编号
     */
    private String code;

    CheckTypeSuEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public static List<Map<String, Object>> getEnumList() {
        return Arrays.stream(CheckTypeSuEnum.values()).map(e -> {
            Map<String, Object> map = new HashMap<>();
            map.put(e.getCode(), e.getName());
            return map;
        }).collect(Collectors.toList());
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
