package com.yeejoin.amos.supervision.business.service.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.supervision.business.constants.XJConstant;
import com.yeejoin.amos.supervision.business.dao.mapper.PlanMapper;
import com.yeejoin.amos.supervision.business.dao.mapper.PointMapper;
import com.yeejoin.amos.supervision.business.dao.mapper.RouteMapper;
import com.yeejoin.amos.supervision.business.dao.repository.*;
import com.yeejoin.amos.supervision.business.param.PlanInfoPageParam;
import com.yeejoin.amos.supervision.business.service.intfc.IPlanService;
import com.yeejoin.amos.supervision.common.enums.PlanStatusEnum;
import com.yeejoin.amos.supervision.core.common.request.AddPlanRequest;
import com.yeejoin.amos.supervision.core.common.response.PlanPointRespone;
import com.yeejoin.amos.supervision.core.util.DateUtil;
import com.yeejoin.amos.supervision.dao.entity.*;
import com.yeejoin.amos.supervision.feign.RemoteSecurityService;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.util.ArrayListWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.stream.Collectors;

@Service("planService")
public class PlanServiceImpl implements IPlanService {
    @Autowired
    private IPlanDao planDao;
    @Autowired
    private PlanMapper planMapper;

    @Autowired
    private IPlanTaskDao planTaskDao;

    @Autowired
    private IPlanTaskDetailDao planTaskDetailDao;

    @Autowired
    RemoteSecurityService remoteSecurityService;

    @Autowired
    IRouteDao iRouteDao;

    @Autowired
    IPointDao iPointDao;

    @Autowired
    private PointMapper pointMapper;

    @Autowired
    private IRoutePointDao iRoutePointDao;

    @Autowired
    private IRoutePointItemDao iRoutePointItemDao;

    @Autowired
    private IPointInputItemDao iPointInputItemDao;

    @Autowired
    private IPlanService planService;

    private static final Logger logger = LoggerFactory.getLogger(PlanServiceImpl.class);

    @Override
    public Page<HashMap<String, Object>> getPlanInfo(PlanInfoPageParam param) {
        long total = planMapper.countPlanInfoData(param);
        Set<String> userIds = new HashSet<>();
        List<HashMap<String, Object>> content = planMapper.getPlanInfo(param);
        content.forEach(c -> userIds.add(c.get("createBy") != null ? c.get("createBy").toString() : ""));
        userIds.remove("");
        String[] temp = Joiner.on(",").join(userIds).split(",");
        Set<String> distinctUserIds = new HashSet<>(Arrays.asList(temp));
        List<AgencyUserModel> userModels = remoteSecurityService.listUserByUserIds(Joiner.on(",").join(distinctUserIds));
        Map<String, String> userIdNameMap = userModels.stream().collect(Collectors.toMap(AgencyUserModel::getUserId, AgencyUserModel::getRealName));
        content.forEach(c -> {
            this.buildUserName(c, "createBy", userIdNameMap);
            if (c.containsKey("status")) {
                String finishStatusDesc = PlanStatusEnum.getName(Integer.parseInt(c.get("status").toString()));
                c.put("statusDesc", finishStatusDesc);
            }
        });
        return new PageImpl<>(content, param, total);
    }

    private void buildUserNames(HashMap<String, Object> c, String key, Map<String, String> userIdNameMap) {
        String[] userIdArray = c.get(key) != null ? c.get(key).toString().split(",") : new String[1];
        Set<String> names = new HashSet<>();
        for (String userId : userIdArray) {
            names.add(userIdNameMap.get(userId));
        }
        names.remove(null);
        names.remove("");
        c.put(key + "Name", String.join(",", names));
    }

    private void buildUserName(HashMap<String, Object> c, String key, Map<String, String> userIdNameMap) {
        String userId = c.get(key) != null ? c.get(key).toString() : "";
        c.put(key + "Name", userIdNameMap.get(userId));
    }

    @Override
    @Transactional
    public void addPlan(HashMap<String, Object> map) {
        // 新增路线
        AddPlanRequest addPlanRequest = (AddPlanRequest) map.get("param");
        Plan param = addPlanRequest.getPlan();
        String orgCode = map.get("org_code") == null ? "" : map.get("org_code").toString();
        String userId = map.get("user_id") == null ? "" : map.get("user_id").toString();
        param.setOrgCode(orgCode);
//        param.setStatus(Byte.parseByte(XJConstant.PLAN_STATUS_STOP));
        param.setNextGenDate(DateUtil.getIntervalDate(new Date(), 0));
        param.setCreateBy(userId);
        addPlanRequest.setPlan(param);
        Route route = save(addPlanRequest);
        if (!ObjectUtils.isEmpty(route)) {
            param.setRouteId(route.getId());
            //编辑计划
            if (param.getId() > 0) {
                Plan oriPlan = planDao.findById(param.getId()).get();
                param.setCreateDate(oriPlan.getCreateDate());
                param.setCreateBy(oriPlan.getCreateBy());
                param.setLastUpdBy(userId);
                param.setFirstFlag(XJConstant.PLAN_FIRST_STATUS_YES);
            }
            if (XJConstant.FIX_DATE_NO.equals(param.getIsFixedDate()) && (XJConstant.PLAN_TYPE_MONTH.equals(param.getPlanType()) || XJConstant.PLAN_TYPE_YEAR.equals(param.getPlanType()))) {
                param.setDayBegin(DateUtil.formatStrToTime("00:00:00"));
                param.setDayEnd(DateUtil.formatStrToTime("23:59:59"));
            }
            planDao.save(param);
        }
    }

    /**
     *  默认新增路线
     */
    public Route save (AddPlanRequest addPlanRequest) {
        Route saveRoute = new Route();
        Plan plan = addPlanRequest.getPlan();

        // 判断是新增还是修改
        if (plan.getId()>0) {
            // 删除相关点项内容
            iRoutePointDao.delRoutePointByRouteId(plan.getRouteId());
//            iRoutePointItemDao.delRoutePointItem(plan.getRouteId());
            saveRoute.setId(plan.getRouteId());
        }

        saveRoute.setName(plan.getName());
        saveRoute.setOrgCode(plan.getOrgCode());
        saveRoute.setCreatorId(plan.getCreateBy());
        if (!ObjectUtils.isEmpty(addPlanRequest.getOwnerId())) {
            String ownerId = StringUtils.join(addPlanRequest.getOwnerId().toArray(), ",");
            saveRoute.setOwnerId(ownerId);
        }
        Route route = iRouteDao.save(saveRoute);

        if (!ObjectUtils.isEmpty(route.getId())) {
            // 新增路线与点关系
            List<Long> ownerIds = addPlanRequest.getOwnerId();
            if (!ObjectUtils.isEmpty(ownerIds)) {
                List<Long> pointVos = pointMapper.getPointRouteList(ownerIds);
                if (!ObjectUtils.isEmpty(pointVos)) {
                    if (!ObjectUtils.isEmpty(pointVos)) {
                        pointVos.forEach(point -> {
                            RoutePoint routePoint = new RoutePoint();
                            routePoint.setOrgCode(plan.getOrgCode());
                            routePoint.setCreatorId(plan.getCreateBy());
                            routePoint.setRouteId(route.getId());
                            routePoint.setPointId(point);
                            iRoutePointDao.save(routePoint);

//                            List<PointInputItem> pointInputItems = pointMapper.getCheckPointById(point);
//                            List<PointInputItem> pointInputItems = iPointInputItemDao.getPointInputItemByPointId(point);
//                            pointMapper.getPointClassInputItemById(point);
//                            if (!ObjectUtils.isEmpty(pointInputItems)) {
//                                pointInputItems.forEach(pointInputItem -> {
//                                    RoutePointItem routePointItem = new RoutePointItem();
//                                    routePointItem.setRoutePointId(routePoint.getId());
//                                    routePointItem.setPointInputItemId(pointInputItem.getId());
//                                    iRoutePointItemDao.save(routePointItem);
//                                });
//                            }
                        });
                    }
                }
            }
        }
        return route;
    }

    @Override
    @Transactional
    public void delPlanById(String[] param) {
        List<Long> ids = new ArrayList<Long>();
        for (int i = 0; i < param.length; i++) {
            ids.add(Long.parseLong(param[i]));
        }
        planDao.updatePlanDel(ids);
        // 删除对应该计划今天往后的所有计划执行信息
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        Date zero = calendar.getTime();
        List<Long> taskIdList = planTaskDao.getPlanTaskIdByPlanIdAndDate(ids, zero);
        if (taskIdList.size() > 0) {
            planTaskDao.deletePlanTaskByIdAndDate(ids, zero);

            // 删除对应该计划的计划执行详情新
            planTaskDetailDao.deletePlanTaskDetailByTaskNo(taskIdList);
        }

    }

    @Override
    public void planSaveAs(String[] param) {
        for (int i = 0; i < param.length; i++) {
            planMapper.saveAs(param[i]);
        }

    }

    @Override
    public List<Plan> getPlanByRouteId(Long routeId) {
        List<Plan> planList = planMapper.getPlanByRouteId(routeId);
        return planList;
    }

    @Override
    public void disablePlan(Long[] planIds) {
        // plan表中status字段置为1
        for (long planId : planIds) {
            List<Plan> planList = getPlanByRouteId(planId);
            for (Plan plan : planList) {
                plan.setStatus(1);
                planDao.save(plan);
            }
        }
    }

    @Override
    public Plan queryPlanById(Long id) {
        Plan plan = null;
        Optional<Plan> op = planDao.findById(id);
        if(op.isPresent()){
            plan = op.get();
            Optional<Route> optionalRoute = iRouteDao.findById(plan.getRouteId());
            plan.setOwnerId( optionalRoute.isPresent() ? optionalRoute.get().getOwnerId() : "" );
        }
        return plan;
    }

    @Override
    public List<HashMap<String, Object>> getPlanInfoNoPage(PlanInfoPageParam param) {
        return planMapper.getPlanInfoNoPage(param);
    }

    @Override
    public List<HashMap<String, Object>> queryPlanListByOrgCode(String loginOrgCode) {
        return planMapper.queryPlanListByOrgCode(loginOrgCode);
    }

    @Override
    public void setplanstatus (Long id, Integer status) {
        Plan oriPlan = planDao.findById(id).get();
        oriPlan.setStatus(status);
        planDao.save(oriPlan);
    }

    @Override
    public PlanPointRespone  getplandetails (Long id) {
        PlanPointRespone planRequest = new PlanPointRespone();
        Plan plan =  planService.queryPlanById(id);;
        if (!ObjectUtils.isEmpty(plan)) {
            List<Long> ids = pointMapper.getPointoriginalidbyrouteid(plan.getRouteId());
            planRequest.setPlan(plan);
            planRequest.setOwnerId(ids);
        }
        return planRequest;
    }
}
