package com.yeejoin.amos.boot.module.common.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;

import java.util.List;

/**
 * @author LiuLin
 */
public interface CustomBaseMapper<T> extends BaseMapper<T> {
    Integer insertBatchSomeColumn(List<T> entityList);
    /**
     * 分批批量插入
     * @param entityList 数据集合
     * @param batchSize 每批数量
     * @return 插入总条数
     */
    default int insertBatchSomeColumn(List<T> entityList, int batchSize) {
        if (entityList == null || entityList.isEmpty()) {
            return 0;
        }
        int total = 0;
        for (int i = 0; i < entityList.size(); i += batchSize) {
            int endIndex = Math.min(i + batchSize, entityList.size());
            List<T> subList = entityList.subList(i, endIndex);
            total += insertBatchSomeColumn(subList);
        }
        return total;
    }
}
