package com.yeejoin.amos.boot.module.jg.biz.data.fix.service;

import cn.hutool.core.bean.BeanUtil;
import com.yeejoin.amos.boot.module.common.api.dao.ESEquipmentCategory;
import com.yeejoin.amos.boot.module.common.api.dto.ESEquipmentCategoryDto;
import com.yeejoin.amos.boot.module.common.api.entity.TzsDataRefreshMessage;
import com.yeejoin.amos.boot.module.common.biz.refresh.DataRefreshEvent;
import com.yeejoin.amos.boot.module.jg.biz.data.fix.patcher.BatchDataPatcherWithFilter;
import com.yeejoin.amos.boot.module.jg.biz.refresh.StatisticsDataUpdateService;
import com.yeejoin.amos.boot.module.jg.biz.refresh.handler.EquipmentRefreshHandler;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgUseInfoMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.Optional;

@Component
@Slf4j
public class EquipInsert2EsPatcher extends BatchDataPatcherWithFilter {


    private final ESEquipmentCategory equipmentCategory;

    private final EquipmentRefreshHandler refreshHandler;

    private final IdxBizJgUseInfoMapper idxBizJgUseInfoMapper;

    protected EquipInsert2EsPatcher(ApplicationContext applicationContext, ESEquipmentCategory equipmentCategory, EquipmentRefreshHandler refreshHandler, IdxBizJgUseInfoMapper idxBizJgUseInfoMapper) {
        super(applicationContext);
        this.equipmentCategory = equipmentCategory;
        this.refreshHandler = refreshHandler;
        this.idxBizJgUseInfoMapper = idxBizJgUseInfoMapper;
    }

    @Override
    protected Map<String, Object> buildFilter(Map<String, Object> params) {
        return params;
    }

    @Override
    protected void beforePatching(String record) {

    }

    @Override
    protected void patchSingleRecord(String record) {
        Optional<ESEquipmentCategoryDto> op = equipmentCategory.findById(record);
        // 插入旧索引
        if (!op.isPresent()) {
            try {
                Map<String, Object> detail = idxBizJgUseInfoMapper.queryDetail(record);
                ESEquipmentCategoryDto esEquipmentInfo = new ESEquipmentCategoryDto();
                StatisticsDataUpdateService.formatUseDate(detail);
                BeanUtil.copyProperties(detail, esEquipmentInfo, true);
                equipmentCategory.save(esEquipmentInfo);
            } catch (Exception e) {
                log.error("老设备索引插入处理失败：{}", record, e);
            }
        }
        // 插入或者新索引
        try {
            refreshHandler.doRefresh(new TzsDataRefreshMessage().setDataId(record).setOperation(DataRefreshEvent.Operation.INSERT.name()));
        } catch (Exception e) {
            log.error("新设备索引插入处理失败：{}", record, e);
        }
    }

    @Override
    protected void afterPatching(String record) {

    }
}
