package com.yeejoin.amos.boot.module.common.api.enums;

import lombok.Getter;

import java.util.*;

@Getter
public enum IssueTypeEnum {
    //检验超期（设备）
    CHECK_OVERDUE_EQUMENT("检验超期","2","3,4"),
    //维保超期（设备）
    MAINTENANCE_OVERDUE_EQUMENT("维保超期","1","3"),
    //资质超期（设备）
    QUALIFICATION_OVERDUE_EQUMENT("资质超期","3","3"),
    //检验不合格（设备）
    CHECK_UNQUALIFIED_EQUMENT("检验不合格","4","3,4"),
    //超设计使用年限（设备）
    DESIGN_OVERDUE_EQUMENT("超设计使用年限","5","3"),
    //电梯困人（设备）
    ELEVATOR_TRAPPED_EQUMENT("电梯困人","6","3"),
    //电梯故障（设备）
    ELEVATOR_FAULT_EQUMENT("电梯故障","7","3"),
    //许可临期(公司)
    LICENSE_EXPIRY_COMPANY("许可临期","8","2"),
    //许可超期（公司）
    LICENSE_OVERDUE_COMPANY("许可超期","9","2"),
    //维保备案超期（公司）
    MAINTENANCE_RECORD_OVERDUE_COMPANY("维保备案超期","10","2"),
    //资质临期（个人）
    LICENSE_EXPIRY_PERSON("资质临期","11","1"),
    //资质超期（个人）
    LICENSE_OVERDUE_PERSON("资质超期","12","1"),
    //操作人员资质超期（气瓶）
    OPERATOR_QUALIFICATION_OVERDUE_CYLINDER("操作人员资质超期","13","4"),
    //充装异常（气瓶）
    CHARGE_EXCEPTION_CYLINDER("充装异常","14","4"),
    //许可超期(设备，气瓶)
    LICENSE_OVERDUE("许可超期","15","3,4"),



    ;

    String name;
    String code;
    String mainBody;

    private IssueTypeEnum(String name, String code, String mainBody) {
        this.name = name;
        this.code = code;
        this.mainBody = mainBody;
    }

    public static List<HashMap<String,String>> getEnumList() {
        List<HashMap<String, String>> list = new ArrayList<>();
        for (IssueTypeEnum testEnum : EnumSet.allOf(IssueTypeEnum.class)) {
            HashMap<String, String> map = new HashMap<>();
            map.put(testEnum.name,testEnum.code.toString());
            list.add(map);
        }
        return list;
    }

    public static String getNameByCode(String code) {
        for (IssueTypeEnum testEnum : EnumSet.allOf(IssueTypeEnum.class)) {
            if(testEnum.getCode().equals(code)){
                return testEnum.getName();
            }
        }
        return null;
    }

    public static List<String> getEnumNameListByMainBody(String mainBody) {
        List<String> list = new ArrayList<>();
        for (IssueTypeEnum testEnum : EnumSet.allOf(IssueTypeEnum.class)) {
            if(testEnum.getMainBody().contains(mainBody)){
                list.add(testEnum.getName());
            }
        }
        return list;
    }

    public static List<String> getEnumCodeListByMainBody(String mainBody) {
        List<String> list = new ArrayList<>();
        for (IssueTypeEnum testEnum : EnumSet.allOf(IssueTypeEnum.class)) {
            if(testEnum.getMainBody().contains(mainBody)){
                list.add(testEnum.getCode());
            }
        }
        return list;
    }
    public static List<Map<String, String>> getEnumListByMainBody(String mainBody) {
        List<Map<String, String>> list = new ArrayList<>();
        for (IssueTypeEnum testEnum : EnumSet.allOf(IssueTypeEnum.class)) {
            if(testEnum.getMainBody().contains(mainBody)){
                Map<String, String> map = new HashMap<>();
                map.put("name",testEnum.getName());
                map.put("code",testEnum.getCode());
                list.add(map);
            }
        }
        return list;
    }
}
