package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 人员保险信息
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("rpm_person_insurance")
@ApiModel(value = "PersonInsurance对象", description = "人员保险信息")
public class PersonInsurance extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "人员信息id")
    private Long personId;
    @ApiModelProperty(value = "投保单位")
    private String insureCompany;
    @ApiModelProperty(value = "投保时间")
    private Date insureDate;
    @ApiModelProperty(value = "投保额度")
    private String insurePremium;
    @ApiModelProperty(value = "保障期限起")
    private String insurePeriodStart;
    @ApiModelProperty(value = "保障期限止")
    private String insurePeriodEnd;
    @ApiModelProperty(value = "保障期限")
    private String insurePeriod;
    @ApiModelProperty(value = "附件")
    @TableField(exist = false)
    @ImagePrefix
    private List<PersonInsuranceAttachment> attachment;
}
