package com.yeejoin.amos.patrol.business.feign;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

//装备
@FeignClient(name ="${equip.fegin.name}")
public interface EquipFeign {
    @RequestMapping(value = "${equip.fegin.prefix}"+"/equipSpecific/getSourceNameByEquipSpeId", method = RequestMethod.GET ,consumes="application/json")
    LinkedHashMap<String,Object> getEquipDetail(@RequestParam(value = "id", required = true) Long id);

    @RequestMapping(value = "${equip.fegin.prefix}"+"/equipSpecific/getSourceNameList", method = RequestMethod.POST ,consumes="application/json")
    LinkedHashMap<String,Object> getEquipList(@RequestBody Long id);

    @RequestMapping(value = "${equip.fegin.prefix}"+"/warehouse-structure/listAll", method = RequestMethod.GET ,consumes="application/json")
    String getStructureNameAll();

    /**
     * 消防建筑树
     * @return
     */
    @RequestMapping(value = "${equip.fegin.prefix}"+"/building/tree", method = RequestMethod.GET ,consumes="application/json")
    LinkedHashMap<String,Object> getBuildingTree();

    @RequestMapping(value = "${equip.fegin.prefix}"+"/building/getBuildingAbsolutePosition", method = RequestMethod.GET ,consumes="application/json")
    LinkedHashMap<String,Object> getBuildingAbsolutePosition();
    /**
     *  所属局域树
     * @return
     */
    @RequestMapping(value = "${equip.fegin.prefix}"+"/area/tree", method = RequestMethod.GET ,consumes="application/json")
    LinkedHashMap<String,Object> getRegionTress();
}

