package com.yeejoin.precontrol.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.precontrol.common.entity.WorkTicket;
import com.yeejoin.precontrol.common.service.IWorkTicketService;
import com.yeejoin.precontrol.common.utils.RedisUtil;
import com.yeejoin.precontrol.common.vo.DistrictVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;


/**
 * 危险作业字典表
 *
 * @author duanwei
 * @date 2020-08-26
 */
@RestController
@Api(tags = "危险作业字典表Api")
@RequestMapping(value = "/work-ticket", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class WorkTicketController {
    /**
     * 缓存服务
     */
    @Autowired
    RedisUtil redisUtil;
    /**
     * 危险作业服务
     */
    @Autowired
    IWorkTicketService iWorkTicketService;


    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/p/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public Object selectByParentId(HttpServletRequest request, @PathVariable Long id) {
        List<WorkTicket> list = iWorkTicketService.list(new LambdaQueryWrapper<WorkTicket>().eq(WorkTicket::getPid, id));
        return list;
    }

    /**
     * 列表分页查询
     *
     * @return
     */
    @RequestMapping(value = "/tree", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表tree查询", notes = "列表tree查询")
    public Object tree() {
        if (redisUtil.hasKey("workTicket")) {
            return redisUtil.get("workTicket");
        }
        List<WorkTicket> list = iWorkTicketService.list();
        List<DistrictVo> districtVos = new ArrayList<>();
        list.forEach(d -> {
            DistrictVo districtVo = new DistrictVo();
            districtVo.setLabel(d.getExtName());
            districtVo.setValue(String.valueOf(d.getId()));
            districtVo.setId(d.getId());
            districtVo.setPid(d.getPid());
            districtVos.add(districtVo);
        });
        List<DistrictVo> menuTreeList = getMenuTreeList(0L, districtVos);
        redisUtil.set("workTicket", menuTreeList, 3600);
        return menuTreeList;
    }

    /**
     * 递归循环
     *
     * @param pid
     * @param list
     * @return
     */
    private List<DistrictVo> getMenuTreeList(Long pid, List<DistrictVo> list) {
        List<DistrictVo> childrenList = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            DistrictVo districtVo = list.get(i);
            if (districtVo.getPid().equals(pid)) {
                districtVo.setChildren(getMenuTreeList(districtVo.getId(), list));
                childrenList.add(districtVo);
            }
        }
        return childrenList;
    }

}


