package com.yeejoin.amos.boot.module.tzs.flc.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.TaskDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.entity.Task;
import com.yeejoin.amos.boot.module.tzs.flc.api.enums.TaskStatusEnum;
import com.yeejoin.amos.boot.module.tzs.flc.api.mapper.TaskMapper;
import com.yeejoin.amos.boot.module.tzs.flc.api.service.ITaskService;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 任务表服务实现类
 *
 * @author system_generator
 * @date 2022-05-31
 */
@Component
public class TaskServiceImpl extends BaseService<TaskDto, Task, TaskMapper> implements ITaskService {

    public void deleteById(Long sequenceNbr) {
        TaskDto taskDto = this.queryBySeq(sequenceNbr);
        taskDto.setIsDelete(true);
        this.updateWithModel(taskDto);
    }

    public Page<TaskDto> queryForTaskPageByStatus(Page<TaskDto> page, String userId, String status) {
        List<Integer> statusList = getStatus(status);
        return this.queryForTaskPage(page, userId, statusList);
    }

    public JSONObject queryCountForMap(String userId){
        Date[] recDate = new Date[2];
        Date now = DateUtils.getDateNow();
        recDate[0] = DateUtils.getCurrentDayStartTime(now);
        recDate[1] = DateUtils.getCurrentDayEndTime(now);

        // 我的任务
        Integer myTaskCount = this.queryForCount(userId, null, null);
        // 今日待办
        List<Integer> statusList = getStatus("uncomplete");
        Integer todyUnCompletedTaskCount = this.queryForCount(userId, recDate, statusList);
        // 未完结业务
        Integer unCompletedTaskCount = this.queryForCount(userId, null, statusList);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("myTask", myTaskCount);
        jsonObject.put("todyUnCompletedTask", todyUnCompletedTaskCount);
        jsonObject.put("unCompletedTask", unCompletedTaskCount);
        return jsonObject;
    }

    /**
     * 分页查询
     */
    public Page<TaskDto> queryForTaskPage(Page<TaskDto> page, String userId, @Condition(Operator.in) List<Integer> status) {
        return this.queryForPage(page, "rec_date", false, userId, status);
    }

    /**
     * 列表查询 示例
     */
    public List<TaskDto> queryForTaskList() {
        return this.queryForList("", false);
    }

    /**
     * 列表查询 示例
     */
    public Integer queryForCount(String userId, @Condition(Operator.between) Date[] recDate, @Condition(Operator.in) List<Integer> status) {
        return this.queryCount(userId, recDate, status);
    }

    private List<Integer> getStatus (String status) {
        List<Integer> statusList = new ArrayList<>();
        if ("uncomplete".equals(status)) {
            statusList.add(TaskStatusEnum.待填报.getKey());
            statusList.add(TaskStatusEnum.待签收.getKey());
        } else if ("complete".equals(status)) {
            statusList.add(TaskStatusEnum.已完成.getKey());
        }
        return statusList;
    }
}