package com.yeejoin.amos.boot.biz.common.utils;

import com.itextpdf.text.*;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;

import javax.servlet.http.HttpServletResponse;

/**
 * PDF工具类
 */
public class PdfUtils {

    private  static  int maxWidth = 520;

    public static Document  createFile(HttpServletResponse response) {        // 设置页面大小,联系文件
        Document  document=new Document();
        document.setPageSize(PageSize.A4);
        document.setPageCount(3);
        try {
            PdfWriter.getInstance(document, response.getOutputStream());
            document.open();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    public static PdfPCell createCell(Object value, Font font, int align, int colspan, int row, int size,int top,int right,int bottom,int left){
        String cellValue;
        if (value == null) {
            cellValue = "";
        } else {
            cellValue = value.toString();
        }
        PdfPCell cell = new PdfPCell();
        cell.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell.setHorizontalAlignment(align);
        cell.setColspan(colspan);
        cell.setPhrase(new Phrase(cellValue,font));
        cell.setFixedHeight(size);
        if (row != 1) {
            cell.setRowspan(row);
        }
        cell.setBorderWidthLeft(left);
        cell.setBorderWidthRight(right);
        cell.setBorderWidthTop(top);
        cell.setBorderWidthBottom(bottom);
        return cell;
    }
    public static PdfPCell createCell(Image image, int align, int colspan){
        PdfPCell cell = new PdfPCell();
        cell.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell.setHorizontalAlignment(align);
        cell.setColspan(colspan);
        cell.setImage(image);
        cell.setPadding(3.0f);
        cell.setBorderWidthLeft(0);
        cell.setBorderWidthRight(0);
        cell.setBorderWidthTop(0);
        cell.setBorderWidthBottom(1);
        return cell;
    }

    // 创建一个几列的Table
    public static PdfPTable createTable(int colNumber){
        PdfPTable table = new PdfPTable(colNumber);
        try{
            table.setTotalWidth(maxWidth);
            table.setLockedWidth(true);
            table.setHorizontalAlignment(Element.ALIGN_CENTER);
        }catch(Exception e){
            e.printStackTrace();
        }
        return table;
    }
}
