package com.yeejoin.amos.boot.module.elevator.flc.api.entity;

import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.TableName;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

/**
 * 液化气体气瓶充装信息审核
 *
 * @author duanwei
 * @date 2022-08-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_cylinder_filling_examine")
@ApiModel(value="TzCylinderFillingExamine对象", description="液化气体气瓶充装信息审核")
public class CylinderFillingExamine extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "充装信息审核ID")
    private String fillingExamineId;

    @ApiModelProperty(value = "报表生成时间")
    private String fillingAuditDate;

    @ApiModelProperty(value = "充装审核报表附件地址")
    private String fillingAuditUrl;

    @ApiModelProperty(value = "充装审核报表附件名称")
    private String fillingAuditName;



    @ApiModelProperty(value = "同步时间  yyyy-MM-dd HH24:mi:ss")
    private Date syncDate;

    @ApiModelProperty(value = "0-新增   1-更新  2-删除")
    private Integer syncState;

    @ApiModelProperty(value = "对接公司编码")
    private String appId;

    @ApiModelProperty(value = "数据完整度")
    private Double integrity;
}
