package com.yeejoin.equipmanage.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.equipmanage.common.entity.Car;
import com.yeejoin.equipmanage.common.entity.WlCarMileage;
import com.yeejoin.equipmanage.common.utils.HttpUtil;
import com.yeejoin.equipmanage.controller.Coordinate;
import com.yeejoin.equipmanage.fegin.IotFeign;
import com.yeejoin.equipmanage.mapper.WlCarMileageMapper;
import com.yeejoin.equipmanage.service.ICarService;
import com.yeejoin.equipmanage.service.IWlCarMileageService;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 车量里程表 服务实现类
 *
 * @author duanwei
 * @date 2023-02-01
 */
@Service
public class WlCarMileageServiceImpl extends ServiceImpl<WlCarMileageMapper, WlCarMileage>
		implements IWlCarMileageService {

	@Autowired
	IotFeign iotFeign;

	@Autowired
	ICarService iCarService;

	private final String GUIDE_KEY = "813684495d9a3981dd2c7694916fe404";

	private final String GUIDE_URL = "https://restapi.amap.com/v4/grasproad/driving?";

	@Override
	public Page<WlCarMileage> page(Page<WlCarMileage> page, WlCarMileage wlCarMileage) {
		return this.baseMapper.page(page, wlCarMileage);
	}

	@Override
	public Integer totalMileage(String iotCode) {
		return this.baseMapper.totalMileage(iotCode);
	}

	@Override
	public List<Coordinate> getCoordinateList(long id) {
		double speed = 0;
		WlCarMileage wlCarMileage = this.getById(id);
		String iotCode = wlCarMileage.getIotCode();
		String measurement = "0THMcLKR";
		String deviceName = iotCode.replace(measurement, "");
		// 由于iot存在毫秒故结束时间要+1秒 iot+1秒有bug还是查不到 +2秒
		ResponseModel<List<Object>> result = iotFeign.getLiveData(measurement, deviceName, wlCarMileage.getStartTime(),
				new Date(wlCarMileage.getEndTime().getTime()));
		List<Object> list = result.getResult();
		List<Coordinate> coordinateList = new ArrayList<Coordinate>();
		if (list != null) {
			DateFormat format1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
			DateFormat format2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
			for (Object object : list) {
				JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(object));
				if (jsonObject.get("FireCar_Longitude") != null && jsonObject.get("FireCar_Latitude") != null) {
					Coordinate coordinate = new Coordinate();
					List<Double> lnglat = new ArrayList<Double>();
					lnglat.add(jsonObject.getDoubleValue("FireCar_Longitude"));
					lnglat.add(jsonObject.getDoubleValue("FireCar_Latitude"));
					coordinate.setLnglat(lnglat);
					coordinate.setSpeed(jsonObject.getDoubleValue("FireCar_Speed"));
					speed = speed + jsonObject.getDoubleValue("FireCar_Speed");
					String time = jsonObject.getString("time");
					if (time.length() > 20) {
						try {
							coordinate.setTime(format1.parse(jsonObject.getString("time")).getTime());
						} catch (ParseException e) {
							e.printStackTrace();
						}
					} else {
						try {
							coordinate.setTime(format2.parse(jsonObject.getString("time")).getTime());
						} catch (ParseException e) {
							e.printStackTrace();
						}
					}
					double direction = jsonObject.getDoubleValue("direction");
					if (!ObjectUtils.isEmpty(direction)){
						coordinate.setDirection(jsonObject.getDoubleValue("direction"));
					}else {
						coordinate.setDirection(0);
					}
					coordinateList.add(coordinate);
				}
			}
		}
		// 倒序坐标变为正序
		Collections.reverse(coordinateList);

		// 坐标轨迹纠偏
		double avgSpeed = speed / coordinateList.size();
		double count = Double.valueOf(coordinateList.size()) / 500;
		int ceil = (int) Math.ceil(count);
		ArrayList<Coordinate> resultList = new ArrayList<>();
		for (int i = 1; i <= ceil; i++) {
			if (i == ceil) {
				List<Coordinate> coordinates = coordinateList.subList(500 * (i - 1), coordinateList.size());
				List<Coordinate> check = check(coordinates, avgSpeed);
				resultList.addAll(check);
			} else {
				List<Coordinate> coordinates = coordinateList.subList(500 * (i - 1), 500 + (i - 1) * 500);
				List<Coordinate> check = check(coordinates, avgSpeed);
				resultList.addAll(check);
			}

		}

		return resultList;
	}

	private List<Coordinate> check(List<Coordinate> list, double avgSpeed) {
		ArrayList<Coordinate> coordinates = new ArrayList<>();
		JSONArray objects = new JSONArray();
		int count = 0;
		for (Coordinate coordinate : list) {
			JSONObject jsonObject = new JSONObject();
			// 经度
			jsonObject.put("x", coordinate.getLnglat().get(0));
			// 纬度
			jsonObject.put("y", coordinate.getLnglat().get(1));
			// 角度
			jsonObject.put("ag", coordinate.getDirection());
			// 速度
			jsonObject.put("sp", coordinate.getSpeed());
			// 时间
			if (count == 0) {
				jsonObject.put("tm", coordinate.getTime() / 1000);
			} else {
				jsonObject.put("tm", 3 * count);
			}
			count += 1;
			objects.add(jsonObject);
		}
		String s = objects.toJSONString();
		StringBuilder api = new StringBuilder(GUIDE_URL);
		api.append("key=").append(GUIDE_KEY);
		String result = null;
		try {
			result = HttpUtil.post(api.toString(), s);
		} catch (IOException | NoSuchAlgorithmException | KeyStoreException | KeyManagementException e) {
			e.printStackTrace();
		}
		if (result != null) {
			Map<String, Object> jsonObject = (Map<String, Object>) JSONObject.parseObject(result);
			if (jsonObject.containsKey("data")) {
				JSONObject data3 = JSONObject.parseObject(jsonObject.get("data").toString());
				JSONArray points1 = JSONArray.parseArray(data3.get("points").toString());
				points1.forEach(item -> {
					JSONObject jsonObject1 = JSONObject.parseObject(item.toString());
					List<Double> doubles = new ArrayList<>();
					Coordinate coordinate = new Coordinate();
					doubles.add(Double.valueOf(jsonObject1.get("x").toString()));
					doubles.add(Double.valueOf(jsonObject1.get("y").toString()));
					coordinate.setLnglat(doubles);
					coordinate.setSpeed(avgSpeed);
					coordinates.add(coordinate);
				});
			}
		}

		return coordinates;
	}

	@Override
	public Map<String, Boolean> getCalender(long id, Date date) {
		List<String> daylist = new ArrayList<String>();
		Map<String, Boolean> map = new HashMap<>();
		Car car = iCarService.getById(id);
		if (car == null || car.getIotCode() == null || date == null) {
			return map;
		}
		Calendar c = Calendar.getInstance();
		// 获取上一个月
		c.setTime(date);
		c.add(Calendar.MONTH, -1);
		daylist.addAll(getDayByMonth(c.getTime()));

		// 获取当月
		c.setTime(date);
		daylist.addAll(getDayByMonth(c.getTime()));

		// 获取下一个月
		c.setTime(date);
		c.add(Calendar.MONTH, 1);
		daylist.addAll(getDayByMonth(c.getTime()));
		List<Map<String, Object>> hasList = this.listMaps(new QueryWrapper<WlCarMileage>()
				.select("COUNT(1) AS count,date").lambda().eq(WlCarMileage::getIotCode, car.getIotCode())
				.between(WlCarMileage::getDate, daylist.get(0), daylist.get(daylist.size() - 1))
				.groupBy(WlCarMileage::getDate));
		Map<String, Object> hasMap = new HashMap<>();
		for (Map<String, Object> mapOne : hasList) {
			hasMap.put(String.valueOf(mapOne.get("date")), mapOne.get("count"));
		}
		for (String day : daylist) {
			boolean has = false;
			if (hasMap.containsKey(day)) {
				has = true;
			}
			map.put(day, has);
		}
		return map;
	}

	public static List<String> getDayByMonth(Date date) {
		List<String> data = new ArrayList<>();
		try {
			Calendar c = Calendar.getInstance();
			c.setTime(date);
			// 获取当前的年份
			int year = c.get(Calendar.YEAR);
			// 获取当前的月份（需要加1才是现在的月份）
			int month = c.get(Calendar.MONTH) + 1;
			// 获取本月的总天数
			int dayCount = c.getActualMaximum(Calendar.DAY_OF_MONTH);
			// 定义时间格式
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			// 开始日期为当前年月拼接1号
			Date startDate = sdf.parse(year + "-" + month + "-01");
			// 结束日期为当前年月拼接该月最大天数
			Date endDate = sdf.parse(year + "-" + month + "-" + dayCount);
			// 设置calendar的开始日期
			c.setTime(startDate);
			// 当前时间小于等于设定的结束时间
			while (c.getTime().compareTo(endDate) <= 0) {
				String time = sdf.format(c.getTime());
				data.add(time);
				// 当前日期加1
				c.add(Calendar.DATE, 1);
			}
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return data;
	}

}
