package com.yeejoin.amos.supervision.business.util;

import com.yeejoin.amos.supervision.business.param.PlanTaskPageParam;
import com.yeejoin.amos.supervision.core.common.request.CommonPageable;
import com.yeejoin.amos.supervision.core.common.request.CommonRequest;
import com.yeejoin.amos.supervision.core.enums.QueryOperatorEnum;
import org.springframework.util.ObjectUtils;

import java.util.HashMap;
import java.util.List;

public class PlanTaskPageParamUtil {

	public static PlanTaskPageParam fillChkInfoParam(List<CommonRequest> queryRequests, CommonPageable commonPageable,
                                                     PlanTaskPageParam param, HashMap<String, Object> paramMap) {
		for(int i=0;i<queryRequests.size();i++){
			String name = queryRequests.get(i).getName();
			if("pointNo".equals(name)){
				param.setPointNo(toString(queryRequests.get(i).getValue()));
			}else if("pointName".equals(name)){
				param.setPointName(toString(queryRequests.get(i).getValue()));
			}else if("beginDate".equals(name)){
				param.setBeginDate(toString(queryRequests.get(i).getValue()));
			}else if("endDate".equals(name)){
				param.setEndDate(toString(queryRequests.get(i).getValue()));
			}else if("status".equals(name)){
				param.setStatus(toString(queryRequests.get(i).getValue()));
			}else if("planId".equals(name)){
				param.setPlanId(toString(queryRequests.get(i).getValue()));
			}else if("routeId".equals(name)){
				param.setRouteId(toString(queryRequests.get(i).getValue()));
			}
		}
		param.setOrgCode(paramMap.get("orgCode") == null ? null:paramMap.get("orgCode").toString());
		param.setUserId(paramMap.get("userId") == null ? null:paramMap.get("userId").toString());
		if (!ObjectUtils.isEmpty(commonPageable)) {
			param.setPageNumber(commonPageable.getPageNumber());
			param.setPageSize(commonPageable.getPageSize());
		}
		
		return param;
	}
	
	private static String toString(Object value) {
		if(null ==value || value ==""){
			return null;
		}else{
			return value.toString();
		}		
	}

	public static HashMap<String, Object> fillPlanTask(List<CommonRequest> queryRequests,
			HashMap<String, Object> params) {
		if (ObjectUtils.isEmpty(queryRequests)) {
			return params;
		}
		String order = "";
		for(int i=0;i<queryRequests.size();i++){
			String name = queryRequests.get(i).getName();
			String type = queryRequests.get(i).getType();
			if(type!=null && !"".equals(type)){
				if (!QueryOperatorEnum.ORDER_BY.getName().equals(type)) {
					params.put(name, queryRequests.get(i).getValue());
				} else if  (QueryOperatorEnum.ORDER_BY.getName().equals(type))  {
					order +=name + " " + queryRequests.get(i).getValue();
				}
			}else{
				if(name.equals("orderBy") && queryRequests.get(i).getValue()!=null){
					order +=  queryRequests.get(i).getValue();
				}
				params.put(name, queryRequests.get(i).getValue());
			}
	
			
		}
		if (!ObjectUtils.isEmpty(order)) {
			params.put("orderBy", order);
		}else{
			params.put("orderBy", "beginTime ASC");
		}
		return params;
	}

}
