package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jg.api.dto.ChangeDataDto;
import com.yeejoin.amos.boot.module.jg.api.dto.PieLineDesignChangeDataDto;
import com.yeejoin.amos.boot.module.jg.api.dto.PipelineChangeItemDto;
import com.yeejoin.amos.boot.module.jg.api.dto.ProjectContraptionChangeDataDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgProjectContraption;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class PieLineDataChangeServiceImpl {

    private final CommonEquipDataProcessService commonEquipDataProcessService;

    private final IdxBizJgProjectContraptionServiceImpl idxBizJgProjectContraptionServiceImpl;

    private final EquipChangeDataUpdateService equipChangeDataUpdateService;

    public PieLineDataChangeServiceImpl(CommonEquipDataProcessService commonEquipDataProcessService, IdxBizJgProjectContraptionServiceImpl idxBizJgProjectContraptionServiceImpl, EquipChangeDataUpdateService equipChangeDataUpdateService) {
        this.commonEquipDataProcessService = commonEquipDataProcessService;
        this.idxBizJgProjectContraptionServiceImpl = idxBizJgProjectContraptionServiceImpl;
        this.equipChangeDataUpdateService = equipChangeDataUpdateService;
    }

    public void update(ProjectContraptionChangeDataDto projectContraptionChangeDataDtoNew, List<ChangeDataDto> allChangeColumns) {
        // 原有对象行转列
        ProjectContraptionChangeDataDto projectContraptionChangeDataDtoOld = getOldProjectContratData(projectContraptionChangeDataDtoNew);
        List<ChangeDataDto> newProjectContraptionChangeData = commonEquipDataProcessService.convertBeanField2Column2(projectContraptionChangeDataDtoNew, projectContraptionChangeDataDtoNew.getProjectContraptionId());
        // 新对象构造行转列
        List<ChangeDataDto> oldProjectContraptionChangeData = commonEquipDataProcessService.convertBeanField2Column2(projectContraptionChangeDataDtoOld, projectContraptionChangeDataDtoNew.getProjectContraptionId());
        // 数据比对记录变化字段列表
        allChangeColumns.addAll(commonEquipDataProcessService.mergeChangeFields(newProjectContraptionChangeData, oldProjectContraptionChangeData));
        // 数据入库
        LambdaUpdateWrapper<IdxBizJgProjectContraption> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(BaseEntity::getSequenceNbr, projectContraptionChangeDataDtoNew.getProjectContraptionId());
        updateWrapper.set(IdxBizJgProjectContraption::getProjectContraption, projectContraptionChangeDataDtoNew.getProjectContraption());
        updateWrapper.set(IdxBizJgProjectContraption::getProjectContraptionNo, projectContraptionChangeDataDtoNew.getProjectContraptionNo());
        updateWrapper.set(IdxBizJgProjectContraption::getPipelineLength, projectContraptionChangeDataDtoNew.getPipelineLength());
        updateWrapper.set(IdxBizJgProjectContraption::getProductPhoto, projectContraptionChangeDataDtoNew.getProductPhoto());
        updateWrapper.set(IdxBizJgProjectContraption::getOtherAccessories, projectContraptionChangeDataDtoNew.getOtherAccessories());
        updateWrapper.set(IdxBizJgProjectContraption::getProductQualificationCertificate, projectContraptionChangeDataDtoNew.getProductQualificationCertificate());
        idxBizJgProjectContraptionServiceImpl.update(null, updateWrapper);
    }

    private ProjectContraptionChangeDataDto getOldProjectContratData(ProjectContraptionChangeDataDto projectContraptionChangeDataDtoNew) {
        IdxBizJgProjectContraption projectContraption = idxBizJgProjectContraptionServiceImpl.getById(projectContraptionChangeDataDtoNew.getProjectContraptionId());
        return BeanUtil.copyProperties(projectContraption, ProjectContraptionChangeDataDto.class);
    }

    public void saveDesignForPieLine(String record, List<ChangeDataDto> allChangeColumns, PipelineChangeItemDto pipelineChangeItemDto) {
        // 1.记录变化的数据对象
        PieLineDesignChangeDataDto pieLineDesignChangeDataDto = BeanUtil.copyProperties(pipelineChangeItemDto, PieLineDesignChangeDataDto.class);
        // 构造新对象行转列
        List<ChangeDataDto> designInfoNew = commonEquipDataProcessService.buildDesignInfoNew(pieLineDesignChangeDataDto, record);
        // 老数据查询行转列
        List<ChangeDataDto> designInfoOld = commonEquipDataProcessService.buildDesignInfoOld(record);
        allChangeColumns.addAll(commonEquipDataProcessService.mergeChangeFields(designInfoNew, designInfoOld));
        // 2.更新管道的设计单位名称
        equipChangeDataUpdateService.updatePieLineDesignData(record, pieLineDesignChangeDataDto);
    }
}
