package com.yeejoin.amos.patrol.business.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateTime;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.yeejoin.amos.boot.biz.common.constants.RuleConstant;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.common.api.feign.EquipFeignClient;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.component.robot.AmosRequestContext;
import com.yeejoin.amos.component.rule.RuleTrigger;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.patrol.business.cache.CacheHelper;
import com.yeejoin.amos.patrol.business.constants.XJConstant;
import com.yeejoin.amos.patrol.business.dao.mapper.*;
import com.yeejoin.amos.patrol.business.dao.repository.*;
import com.yeejoin.amos.patrol.business.dto.*;
import com.yeejoin.amos.patrol.business.entity.mybatis.CheckChkExListBo;
import com.yeejoin.amos.patrol.business.entity.mybatis.PointCheckDetailBo;
import com.yeejoin.amos.patrol.business.event.CheckRecordInsertEvent;
import com.yeejoin.amos.patrol.business.feign.Business;
import com.yeejoin.amos.patrol.business.feign.IdxFeign;
import com.yeejoin.amos.patrol.business.feign.JcsFeignClient;
import com.yeejoin.amos.patrol.business.feign.TzsFeign;
import com.yeejoin.amos.patrol.business.param.CheckPtListPageParam;
import com.yeejoin.amos.patrol.business.param.PlanTaskPageParam;
import com.yeejoin.amos.patrol.business.publisher.EventPublisher;
import com.yeejoin.amos.patrol.business.service.intfc.ICheckService;
import com.yeejoin.amos.patrol.business.service.intfc.IPatrolDataSyncService;
import com.yeejoin.amos.patrol.business.service.intfc.IPlanService;
import com.yeejoin.amos.patrol.business.service.intfc.IPlanTaskService;
import com.yeejoin.amos.patrol.business.util.MyByteArrayMultipartFile;
import com.yeejoin.amos.patrol.business.util.PlanTaskUtil;
import com.yeejoin.amos.patrol.business.util.WordTemplateUtils;
import com.yeejoin.amos.patrol.business.vo.*;
import com.yeejoin.amos.patrol.common.enums.*;
import com.yeejoin.amos.patrol.core.common.request.CommonPageable;
import com.yeejoin.amos.patrol.core.common.response.AppCheckInputRespone;
import com.yeejoin.amos.patrol.core.common.response.AppPointCheckRespone;
import com.yeejoin.amos.patrol.core.enums.DefectLevelEnum;
import com.yeejoin.amos.patrol.core.enums.WordTemplateEnum;
import com.yeejoin.amos.patrol.core.util.DateUtil;
import com.yeejoin.amos.patrol.core.util.StringUtil;
import com.yeejoin.amos.patrol.dao.entity.*;
import com.yeejoin.amos.patrol.exception.YeeException;
import com.yeejoin.amos.patrol.feign.RemoteSecurityService;
import com.yeejoin.amos.patrol.quartz.IJobService;
import com.yeejoin.amos.patrol.utils.UserTransmittableUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.compress.utils.Sets;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.alibaba.fastjson.JSON.toJSONString;

@Service("planTaskService")
@EnableAsync
@Slf4j
public class PlanTaskServiceImpl implements IPlanTaskService {
    @Resource
    private DataSource dataSource;

    @Autowired
    ESPlanTaskList esPlanTaskList;

    @Autowired
    ESTaskDetail esTaskDetail;

    @Autowired
    IPlanService planService;

    @Autowired
    PlanTaskMapper planTaskMapper;
    @Autowired
    PlanTaskDetailMapper planTaskDetailMapper;
    @Autowired
    IInputItemDao inputItemDao;

    @Autowired
    private CheckMapper checkMapper;
    @Autowired
    PlanMapper planMapper;
    @Autowired
    IPlanTaskDao iplanTaskDao;
    @Autowired
    IPlanDao iplanDao;
    @Autowired
    IPlanTaskDetailDao iPlanTaskDetailDao;
    @Autowired
    private ICheckDao checkDao;
    @Autowired
    private RemoteSecurityService remoteSecurityService;
    @Autowired
    private IPlanTaskDetailDao planTaskDetail;
    @Autowired
    IRoutePointDao iRoutePointDao;

    @Autowired
    IRouteDao routeDao;

    @Autowired
    IPlanTaskHistoryDao planTaskHistoryDao;

    @Autowired
    IJobService jobService;

    @Autowired
    private ICheckService checkService;

    @Autowired
    private Business business;

    @Autowired
    private EquipFeignClient equipFeign;

    @Autowired
    private RuleTrigger ruleTrigger;

    @Autowired
    RedisUtils redisUtils;

    @Autowired
    JcsFeignClient jcsFeignClient;

    @Autowired
    private IPatrolDataSyncService patrolDataSyncService;

    @Autowired
    private IdxFeign idxFeign;

    @Autowired
    private TzsFeign tzsFeign;


    @Autowired
    PointMapper pointMapper;

    @Autowired
    private RepositoryTs repositoryTs;

    @Autowired
    RestHighLevelClient restHighLevelClient;

    @Autowired
    AmosRequestContext amosRequestContext;

    @Autowired
    Executor asyncServiceExecutor;


    @Autowired
    EventPublisher publisher;

    @Autowired
    CacheHelper cacheHelper;

    private String DB = "amos_tzs_biz.";

    private String P_STATIC_DAY = "p_static_day";

    private String P_STATIC_MONTH = "p_static_month";

    private String P_STATIC_WEEK = "p_static_week";

    @PersistenceContext
    private final EntityManager em;

    public PlanTaskServiceImpl(EntityManager em) {
        this.em = em;
    }

    private final String PATROL_PLAN_TASK_KEY = "PATROL_PLAN_ID:";

    private final String packageId = "消息/addCheckRule";
    private final String msgType = "patrolSystem";
    private final String APP = "APP";
    private final String WEB = "WEB";
    private final String APP_WEB = "APP/WEB";
    private static final String TAB = "\r\n";


    @Override
    public Page<HashMap<String, Object>> getPlanTaskInfo(String toke, String product, String appKey, PlanTaskPageParam params) {
        long total = planTaskMapper.countPlanTask(params);
        List<HashMap<String, Object>> content = planTaskMapper.getPlanTaskInfo(params);

        String userIds = "";
        String deptIds = "";
        Set<String> set = new HashSet<>();
        Set<String> userDeptSet = new HashSet<>();
        content.forEach(s -> {
            if (s.containsKey("userName")) {
                set.add(s.get("userName").toString());
            }
            if (s.containsKey("userDept")) {
                userDeptSet.add(s.get("userDept").toString());
            }
        });

        List<String> userList = new ArrayList<>(set);
        List<String> userDeptList = new ArrayList<>(userDeptSet);

        Map<String, String> LoginName = new HashMap<>();
        Map<String, String> userMap = new HashMap<>();
        Map<String, String> depMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(userList)) {
            userIds = String.join(",", userList);
            List<AgencyUserModel> userModelList = remoteSecurityService.listUserByUserIds(toke, product, appKey, userIds);
            userMap = userModelList.stream().collect(Collectors.toMap(AgencyUserModel::getUserId, AgencyUserModel::getRealName, (k1, k2) -> k2));
            for (AgencyUserModel agencyUserModel : userModelList) {
                LoginName.put(agencyUserModel.getUserId(), agencyUserModel.getMobile() != null ? agencyUserModel.getMobile() : agencyUserModel.getLandlinePhone());
            }
        }
        if (!CollectionUtils.isEmpty(userDeptList)) {
            StringBuilder strBuilder = new StringBuilder();
            for (String str : userDeptList) {
                if (!StringUtils.isEmpty(str)) {
                    String[] userDeptArr = str.split("@");
                    if (strBuilder.length() < 1) {
                        strBuilder.append(userDeptArr[1]);
                    } else {
                        strBuilder.append(",");
                        strBuilder.append(userDeptArr[1]);
                    }
                }
            }
//          String depts = String.join(",", userDeptList);
//          List<LinkedHashMap> deptL = remoteSecurityService.listDepartmentByDeptIds(toke, product, appKey,strBuilder.toString());


            //新安全
            content.forEach(s -> {
                if (s.get("userDept").toString().indexOf("@") > 0) {
                    String[] dept = s.get("userDept").toString().split(",");
                    Arrays.asList(dept).stream().forEach(x -> {
                        String[] deptTemp = x.split("@");
                        List<LinkedHashMap> deptL = remoteSecurityService.listDepartmentByDeptIds(toke, product, appKey, deptTemp[1]);
                        if (deptL.size() > 0) {
                            s.put("userDept", deptTemp[0] + "(" + deptL.get(0).get("departmentName") + ")");
                            depMap.put(deptTemp[0], deptL.get(0).get("departmentName").toString());
                        } else {
                            s.put("userDept", deptTemp[0] + "()");
                            depMap.put(deptTemp[0], "其他");
                        }

                    });
                } else {
                    String[] deptTemp = s.get("userDept").toString().split("@");
                    List<LinkedHashMap> deptL = remoteSecurityService.listDepartmentByDeptIds(toke, product, appKey, deptTemp[1]);
                    if (deptL.size() > 0) {
                        s.put("userDept", deptTemp[0] + "(" + deptL.get(0).get("departmentName") + ")");
                        depMap.put(deptTemp[0], deptL.get(0).get("departmentName").toString());
                    } else {
                        s.put("userDept", deptTemp[0] + "()");
                        depMap.put(deptTemp[0], "其他");
                    }

                }

//                deptL.forEach(s1 -> {
//                    String[] deptTemp = s.get("userDept").toString().split("@");
//                    if (deptTemp[1].equals(s1.get("sequenceNbr")+"")) {
//                        s.put("deptName",s1.get("departmentName")+"");
//                        s.put("userDept", deptTemp[0] + "("+ s1.get("departmentName") +")" );
//                    }
//                });

            });

        }

        Map<String, String> finalUserMap = userMap;
        Map<String, String> finalDeptMap = LoginName;

        content.forEach(c -> {
            StringBuilder userNames = new StringBuilder("");
            List<String> userIdsList = Arrays.asList(c.get("userName").toString().split(","));
//            String userDept = c.get("userDept").toString();

            for (String userId : userIdsList) {
                userNames.append(finalUserMap.get(userId) + "(" + depMap.get(userId) + ")");
                userNames.append(",");

            }
            String deptTemp = c.get("userDept").toString();
            deptTemp = deptTemp.replace(c.get("userName").toString(), "");
            c.put("userName", userNames.substring(0, userNames.lastIndexOf(",")));
            c.put("userDept", userNames.substring(0, userNames.lastIndexOf(",")) + deptTemp);
            if (c.get("userName") != null)

                if (c.get("realName") != null)
                    c.put("LoginName", finalDeptMap.get(c.get("realName")));

        });

        Page<HashMap<String, Object>> result = new PageImpl<HashMap<String, Object>>(content, params, total);
        return result;
    }

    @Override
    public Page<HashMap<String, Object>> getPlanTaskInfoNew(PlanTaskPageParam params) {
        long total = planTaskMapper.countPlanTask(params);
        List<HashMap<String, Object>> content = planTaskMapper.getPlanTaskInfo(params);
        Page<HashMap<String, Object>> result = new PageImpl<HashMap<String, Object>>(content, params, total);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void reGenPlanTask(HashMap<String, Object> param) throws ParseException {
        //1.公共参数准备
        String planId = param.get("planId").toString();//重做的计划编号id
        String strBginDate = param.get("beginDate").toString();//开始日期（yyyy-MM-dd）
        String strEndDate = param.get("endDate").toString();//结束日期（yyyy-MM-dd）
        String flag = param.get("changeFlag").toString();//是否记为合格标记：0-否，1-是
        Plan plan = iplanDao.findById(Long.parseLong(planId)).get();//
        if (plan == null) {
            throw new YeeException("计划不存在");
        }

        if (StringUtil.isNotEmpty(plan.getUserId())) {
            //2.数据必输校验，不满足直接return，不再向下进行
            Boolean fileFlag = PlanTaskUtil.checkMustFile(plan);
            if (!fileFlag) {
                return;
            }

            //3.计算生成数据的日期区间（前10位：yyyy-MM-dd）
            CalDateVo vo = PlanTaskUtil.reGenPlanTaskData(plan, strBginDate, strEndDate);

            if (null == vo) {//计划未开始,则结束
                return;
            }


            if (!vo.getIsGenData()) {//日期不符合条件直接结束
                return;
            }

            //3.删除planTask表，按照计划id+日期
            deletePlanTaskAndDet(param);

            //5.执行数据生成（具体时间 + 人员）
            List<HashMap<String, Object>> list = genAllExeDate(plan, vo, XJConstant.REGEN_FLAG);

            //6.插入planTask及planTaskDetail
            insertPlanTaskAndDet(list, plan, flag, new Date());

            //7.重新统计计划
            if (ObjectUtils.isEmpty(plan.getUserId())) {
                return;
            }

            reformStatisticsPlanTask(strBginDate, strEndDate, plan.getUserId(), plan.getOrgCode());
            //8.通知3d数据统计进行更新（换流站全景监控）
            this.notifyBusinessRefresh(NotifyBusinessTypeEum.planTask.getCode());
        }


    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void reGenPlanTaskNew(HashMap<String, Object> param) throws ParseException {
        //1.公共参数准备
        String planId = param.get("planId").toString();//重做的计划编号id
        String strBginDate = param.get("beginDate").toString();//开始日期（yyyy-MM-dd）
        String strEndDate = param.get("endDate").toString();//结束日期（yyyy-MM-dd）
        String flag = param.get("changeFlag").toString();//是否记为合格标记：0-否，1-是
        Plan plan = iplanDao.findById(Long.parseLong(planId)).get();//
        if (plan == null) {
            throw new YeeException("计划不存在");
        }
        // 校验计划数据是否异常
        if (!checkData(plan.getId())) {
            throw new YeeException("计划数据异常！");
        }
        //2.数据必输校验，不满足直接return，不再向下进行
        Boolean fileFlag = PlanTaskUtil.checkMustFile(plan);
        if (!fileFlag) {
            return;
        }

        //3.计算生成数据的日期区间（前10位：yyyy-MM-dd）
        CalDateVo vo = PlanTaskUtil.reGenPlanTaskData(plan, strBginDate, strEndDate);

        if (null == vo) {//计划未开始,则结束
            return;
        }

        if (!vo.getIsGenData()) {//日期不符合条件直接结束
            return;
        }

        //4.删除对应es中数据
        CompletableFuture.runAsync(() -> deleteEsData(param));

        //5.执行数据生成（具体时间 + 人员）
        List<HashMap<String, Object>> list = genAllExeDate(plan, vo, XJConstant.REGEN_FLAG);

        //6.插入planTask及planTaskDetail
        insertPlanTaskAndDetNew(list, plan, flag, new Date());

        // 更新统计表
        taskStaticExecution(null);
    }

    private void deleteEsData(HashMap<String, Object> param) {
        //删除planTask表，按照计划id+日期
        List<ESPlanTaskListDto> oldEsPlanTaskListDtos = deletePlanTaskAndDet(param);

        //删除planTaskDetail表
        List<String> planTaskIds = oldEsPlanTaskListDtos.stream().map(ESPlanTaskListDto::getPlanTaskId).collect(Collectors.toList());

        if (!ValidationUtil.isEmpty(planTaskIds)) {
            if (planTaskIds.size() > 5000) {
                int index = 5000;
                for (int i = 0; i < planTaskIds.size(); i += 5000) {
                    if (i + 5000 > planTaskIds.size()) {
                        index = planTaskIds.size() - i;
                    }
                    List<String> newList = planTaskIds.subList(i, i + index);
                    String ids = newList.stream().collect(Collectors.joining("','", "('", "')"));
                    List<ESTaskDetailDto> maps = planTaskDetailMapper.findAllByTaskNos(ids);
                    esTaskDetail.deleteAll(maps);
                }
            } else {
                String ids = planTaskIds.stream().collect(Collectors.joining("','", "('", "')"));
                List<ESTaskDetailDto> maps = planTaskDetailMapper.findAllByTaskNos(ids);
                esTaskDetail.deleteAll(maps);
            }
        }

        if (!ValidationUtil.isEmpty(oldEsPlanTaskListDtos)) {
            if (oldEsPlanTaskListDtos.size() > 5000) {
                int index = 5000;
                for (int i = 0; i < oldEsPlanTaskListDtos.size(); i += 5000) {
                    if (i + 5000 > oldEsPlanTaskListDtos.size()) {
                        index = oldEsPlanTaskListDtos.size() - i;
                    }
                    List<ESPlanTaskListDto> newList = oldEsPlanTaskListDtos.subList(i, i + index);
                    esPlanTaskList.deleteAll(newList);
                }
            } else {
                esPlanTaskList.deleteAll(oldEsPlanTaskListDtos);
            }
        }
    }


    private void notifyBusinessRefresh(String type) {
        try {
            business.planTaskInsertToB(type);
        } catch (Exception e) {
            log.error("通知业务进行数据刷新失败->" + type);
        }
    }

    @Override
    public void reformStatisticsPlanTask(String strBginDate, String strEndDate, String userId, String orgCode) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

        Date startTime = sdf.parse(strBginDate);
        Date endTime = sdf.parse(strEndDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(startTime);
        Date currentDate = new Date();
        String strCurrentDate = sdf.format(currentDate);
        long abortTime = endTime.getTime();
        if (endTime.getTime() >= sdf.parse(strCurrentDate).getTime()) {
            abortTime = sdf.parse(strCurrentDate).getTime();
        }
        String[] ids = userId.split(",");
//        StringBuffer orgCodeBuffer = new StringBuffer();
//        Map<String,String> deptMap =new HashMap<>();
//        Set<Object> userIds =new HashSet<>();
//        for (int i = 0; i <ids.length ; i++) {
//            userIds.add(ids[i].toString());
//        }
//        Map<String,AgencyUserModel> agencyUserModelMap = remoteSecurityService.getUsersMap(toke.getToke(),toke.getProduct(),toke.getAppKey(),userIds);
//        List<Map<String, String>> idOrgCodeList = new ArrayList<>();
//        for(Map.Entry<String, AgencyUserModel> entry : agencyUserModelMap.entrySet()){
//            String id = entry.getKey();
//            AgencyUserModel agencyUserModels = entry.getValue();
//            StringBuffer agencyUserOrgcode = new StringBuffer();
//            if(agencyUserModelMap.size() > 0){
//                agencyUserModels.getCompanys().forEach(companyModel -> {
//                    agencyUserOrgcode.append(companyModel.getOrgCode()).append(",");
//                });
//            }
//            Map<String,String> map = new HashMap<>();
//            map.put(id,agencyUserOrgcode.toString().substring(0,agencyUserOrgcode.length()-1));
//        }
//
//        Map<String, String> userIdOrgCodeMap = new HashMap<>(ids.length);
//        if (!CollectionUtils.isEmpty(idOrgCodeList)) {
//            userIdOrgCodeMap = idOrgCodeList.stream().collect(Collectors.toMap(x-> String.valueOf(x.get(
//                    "id")),    x->x.get("org_code")));
//        }
        while (cal.getTime().getTime() <= abortTime) {
            String refDate = sdf.format(cal.getTime());
            for (String id : ids) {
                if (!ObjectUtils.isEmpty(id)) {
                    planTaskMapper.reformStatistics(id, refDate, orgCode);
//                    planTaskMapper.reformStatistics(id, refDate, userIdOrgCodeMap.get(id));

                }
            }
            cal.add(Calendar.DATE, 1);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void planTaskDet(String[] strArry) {
        if (strArry.length <= 0) {
            throw new YeeException("删除数据内容不能为空");
        }
        Set<Long> taskNos = new HashSet<>();
        for (String id : strArry) {
            PlanTaskDetail planTkDet = planTaskDetail.findById(Long.parseLong(id)).get();
            if (null != planTkDet) {
                taskNos.add(planTkDet.getTaskNo());
            }
        }
        planTaskMapper.planTaskDet(strArry);// 删除数据
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("IDS", new ArrayList<>(taskNos));
        param.put("FINISH_YES", XJConstant.PLAN_TASK_DET_FINISH_YES);
        planTaskMapper.updatePlanTaskPtInfo(param);// 更新主表，点数量，完成数量
    }

    @Override
    public List<PlanTaskVo> planTaskReport(String toke, String product, String appKey, PlanTaskPageParam param) {
        List<PlanTaskVo> content = planTaskMapper.getPlanTaskInfoList(param);

        String userIds = "";
        String deptIds = "";
        Set<String> set = new HashSet<>();
        Set<String> deptIdSet = new HashSet<>();
        content.forEach(s -> {
            if (s.getUserName() != null) {
                set.add(s.getUserName());
            }
            if (s.getDeptId() > 0) {
                deptIdSet.add(s.getDeptId() + "");
            }
        });

        List<String> userList = new ArrayList<>(set);
        List<String> deptList = new ArrayList<>(deptIdSet);

        Map<String, String> LoginName = new HashMap<>();
        Map<String, String> userMap = new HashMap<>();
        Map<String, String> depMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(userList)) {
            userIds = String.join(",", userList);
            List<AgencyUserModel> userModelList = remoteSecurityService.listUserByUserIds(toke, product, appKey, userIds);
            userMap = userModelList.stream().collect(Collectors.toMap(AgencyUserModel::getUserId, AgencyUserModel::getRealName, (k1, k2) -> k2));
            for (AgencyUserModel agencyUserModel : userModelList) {
                LoginName.put(agencyUserModel.getUserId(), agencyUserModel.getMobile() != null ? agencyUserModel.getMobile() : agencyUserModel.getLandlinePhone());
            }
        }
//        if(!CollectionUtils.isEmpty(deptList)){
//        String	dept = String.join(",", deptList);
//            List<LinkedHashMap> deptL = remoteSecurityService.listDepartmentByDeptIds(toke, product, appKey,dept);
//            if(deptL!=null&&deptL.size()>0){
//            	  //新安全
//            	content.forEach(s -> {
//            		deptL.forEach(s1 -> {
//                        if ((s.getDeptId()+"").equals(s1.get("sequenceNbr")+"")) {
//                            s.setDeptName(s1.get("departmentName")+"");
//                        }
//                    });
//
//                });
//            }
//        }
        //新安全
        content.forEach(s -> {
            StringBuffer buffer = new StringBuffer();
            if (s.getUserDept().indexOf("@") > 0) {
                String[] dept = s.getUserDept().split(",");
                Arrays.asList(dept).stream().forEach(x -> {
                    String[] deptTemp = x.split("@");
                    List<LinkedHashMap> deptL = remoteSecurityService.listDepartmentByDeptIds(toke, product, appKey, deptTemp[1]);
                    if (deptL.size() > 0) {
                        buffer.append(deptL.get(0).get("departmentName")).append(",");
                    } else {
                        buffer.append("其他").append(",");
                    }

                });
            } else {
                String[] deptTemp = s.getUserDept().split(",");
                List<LinkedHashMap> deptL = remoteSecurityService.listDepartmentByDeptIds(toke, product, appKey, deptTemp[1]);
                if (deptL.size() > 0) {
                    buffer.append(deptL.get(0).get("departmentName")).append(",");
                } else {
                    buffer.append("其他").append(",");
                }

            }
            s.setDeptName(buffer.substring(0, buffer.length() - 1));
        });
        Map<String, String> finalUserMap = userMap;
        content.forEach(c -> {
            StringBuilder userNames = new StringBuilder("");
            List<String> userIdsList = Arrays.asList(c.getUserName().split(","));
            for (String userId : userIdsList) {
                userNames.append(finalUserMap.get(userId));
                userNames.append(",");
            }
            c.setUserName(userNames.toString());
        });


        return content;
    }

    @Override
    public List<PlanTaskVo> planTaskReportNew(PlanTaskPageParam params) {
        List<PlanTaskVo> content = planTaskMapper.getPlanTaskInfoList(params);
        return content;
    }

    /**
     * 校验计划数据是否异常
     *
     * @return
     */
    private Boolean checkData(Long planId) {
        if (planMapper.checkData(planId) > 0) {
            return true;
        }
        return false;
    }

    /**
     * 自动任务执行
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void taskExecution(String runDate) {
        //1.扫描plan表查询，需要生成执行数据的任务信息，无则return
        Date now = new Date();//今天
        if (runDate != null) {//上送则已上送的为准
            now = DateUtil.str2Date(runDate, "yyyyMMdd");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String strDate = df.format(now);
        String tomorrow = DateUtil.getIntervalDateStr(now, 1, "yyyy-MM-dd");//下一天
        List<Plan> planList = iplanDao.queryScheduledPlan(strDate, XJConstant.PLAN_STATUS_START);
        if (planList == null || planList.size() <= 0) {
            log.info(strDate + " " + " 暂无待生成执行数据的计划");
            return;
        }
        //2.循环遍历执行
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (Plan plan : planList) {
            // 校验计划数据是否异常
            if (!checkData(plan.getId())) {
                continue;
            }
            // tzs修改为查询用户组id
            if (StringUtils.isEmpty(plan.getUserGroupId()))
                continue;
            paramMap.clear();
            paramMap.put("id", plan.getId());
            //2.1计划数据合法性校验
            Boolean fileFlag = PlanTaskUtil.checkMustFile(plan);
            if (!fileFlag) {
                paramMap.put("next_gen_date", tomorrow);
                planMapper.updPlanStatusOrGenDate(paramMap);//更新为明天
                continue;
            }
            //2.2.计算生成数据的日期区间
            CalDateVo vo = PlanTaskUtil.reGenPlanTaskData(plan, tomorrow, tomorrow);

            //计划未开始，则更新生成时间为明天
            if (null == vo) {
                paramMap.put("next_gen_date", tomorrow);
                planMapper.updPlanStatusOrGenDate(paramMap);//更新为明天
                continue;
            }
            //计划已过期,则更新status = 1,停用
            if (!vo.getIsGenData()) {
                paramMap.put("status", XJConstant.PLAN_STATUS_STOP);
                planMapper.updPlanStatusOrGenDate(paramMap);
                continue;
            }

            //2.3.执行数据生成（具体时间 + 人员）  tzs改为用户组
            List<HashMap<String, Object>> list = genAllExeDate(plan, vo, XJConstant.SCHED_FLAG);

            if (XJConstant.UPD_PLAN_GEN_DATE.equals(vo.getUpdFlag())) {
                paramMap.put("next_gen_date", tomorrow);
                planMapper.updPlanStatusOrGenDate(paramMap);//更新为明天
                continue;
            } else if (XJConstant.UPD_PLAN_STATUS.equals(vo.getUpdFlag())) {
                paramMap.put("status", XJConstant.PLAN_STATUS_STOP);
                planMapper.updPlanStatusOrGenDate(paramMap);//更新status = 1,停用
                continue;
            }

            //2.4.删除今天可能重做生成的数据（计划重做后进行了计划的编辑）
            if (iplanTaskDao.findById(plan.getPlanTaskId()) != null && plan.getFirstFlag() == XJConstant.PLAN_FIRST_STATUS_YES)
                if (iplanTaskDao.existsById(plan.getPlanTaskId())) {
                    iplanTaskDao.deleteById(plan.getPlanTaskId());
                }

            //2.5.插入planTask及planTaskDetail
            insertPlanTaskAndDetNew(list, plan, XJConstant.SCHED_FLAG, now);

            // 更新统计表
            taskStaticExecution(null);

        }
    }

    /**
     * 自动任务执行
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void taskStaticExecution(String runDate) {
        log.info("开始初始化统计表=======");
        try {
            runDate = DateUtils.dateFormat(new Date(), DateUtils.DATE_PATTERN);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        // 判断当天是不是月第一天
        int date = DateUtils.getDate(new Date());
        int month = DateUtils.getMonth(new Date());
        if (date == 1) {
            // 日统计表按月归档
            Calendar calendar = new GregorianCalendar();
            calendar.setTime(new Date());
            calendar.add(Calendar.DATE, -1);
            Date oldDate = calendar.getTime();
            try {
                String s = DateUtils.dateFormat(oldDate, DateUtils.MONTH_PATTERN);
                s = s.replace("-", "");
                createNeedTime(P_STATIC_DAY, DB, P_STATIC_DAY + "_" + s);
                List<StaticDay> staticDay = planTaskMapper.findStaticDay();
                Iterable join = CompletableFuture.supplyAsync(() -> repositoryTs.batchSave(staticDay)).join();
                if (!ValidationUtil.isEmpty(join)) {
                    planTaskMapper.deleteDate(P_STATIC_DAY);
                }
            } catch (ParseException e) {
                e.printStackTrace();
            }

            if (month == 1) {
                try {
                    String s = DateUtils.dateFormat(oldDate, DateUtils.YEAR_PATTERN);
                    createNeedTime(P_STATIC_WEEK, DB, P_STATIC_WEEK + "_" + s);
                    List<StaticDay> staticWeeks = planTaskMapper.findStaticWeek();
                    Iterable join = CompletableFuture.supplyAsync(() -> repositoryTs.batchSave(staticWeeks)).join();
                    if (!ValidationUtil.isEmpty(join)) {
                        planTaskMapper.deleteDate(P_STATIC_WEEK);
                    }
                } catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }

        planTaskMapper.deleteOne(P_STATIC_DAY, runDate);
        planTaskMapper.deleteOne(P_STATIC_WEEK, runDate);
        planTaskMapper.deleteOne(P_STATIC_MONTH, runDate);
        // 插入日统计表
        List<Map<String, Object>> listDay = checkMapper.planCount(runDate, null, String.valueOf(PlanTaskTypeStatusEnum.day.getValue()), null, null, null);
        List<StaticDay> staticDays = listDay.stream().map(e -> {
            String s = JSON.toJSONString(e);
            StaticDay staticDay = JSON.parseObject(s, StaticDay.class);
            return staticDay;
        }).collect(Collectors.toList());
        // 插入周统计表
        List<Map<String, Object>> listWeek = checkMapper.planCount(runDate, null, String.valueOf(PlanTaskTypeStatusEnum.week.getValue()), null, null, null);
        List<StaticWeek> staticWeeks = listWeek.stream().map(e -> {
            String s = JSON.toJSONString(e);
            StaticWeek staticWeek = JSON.parseObject(s, StaticWeek.class);
            return staticWeek;
        }).collect(Collectors.toList());
        // 插入月统计表
        List<Map<String, Object>> listMonth = checkMapper.planCount(runDate, null, String.valueOf(PlanTaskTypeStatusEnum.month.getValue()), null, null, null);
        List<StaticMonth> staticMonths = listMonth.stream().map(e -> {
            String s = JSON.toJSONString(e);
            StaticMonth staticMonth = JSON.parseObject(s, StaticMonth.class);
            return staticMonth;
        }).collect(Collectors.toList());

        repositoryTs.batchSave(staticDays);
        repositoryTs.batchSave(staticWeeks);
        repositoryTs.batchSave(staticMonths);

        log.info("初始化统计表完成=======");
    }

    /**
     * 删除plantask及det
     *
     * @param param
     */
    public List<ESPlanTaskListDto> deletePlanTaskAndDet(HashMap<String, Object> param) {
        param.put("beginDate", param.get("beginDate") + " " + "00:00:00");
        param.put("endDate", param.get("endDate") + " " + "23:59:59");
        List<Long> ids = planTaskMapper.getGenPlanTask(param);
        List<ESPlanTaskListDto> planTaskList = new ArrayList<>();
        for (long id : ids) {
            iplanTaskDao.deleteById(id);
            ESPlanTaskListDto esPlanTaskListDto = new ESPlanTaskListDto();
            esPlanTaskListDto.setPlanTaskId(String.valueOf(id));
            planTaskList.add(esPlanTaskListDto);
        }
        return planTaskList;
    }

    /**
     * 执行数据生成
     *
     * @param plan
     * @param vo
     * @return
     */
    public List<HashMap<String, Object>> genAllExeDate(Plan plan, CalDateVo vo, String flag) {
        //1.生成前8位日期（yyyy-MM-dd）
        List<HashMap<String, Date>> list = PlanTaskUtil.genExeDate(plan, vo, flag);
        if (list == null || list.size() <= 0) {
            vo.setUpdFlag(XJConstant.UPD_PLAN_GEN_DATE);
            return null;
        }
        //2.生成完整时间（yyyy-MM-dd HH:mm:ss）
        List<HashMap<String, Object>> timeList = PlanTaskUtil.genWholeExeDate(list, plan);
        if (timeList == null || timeList.size() <= 0) {
            vo.setUpdFlag(XJConstant.UPD_PLAN_STATUS);
        }
        //3.生成含有人员信息的日期执行数据
        // 获取路线中的企业类型和设备类型
        Route route = routeDao.getOne(plan.getRouteId());
//        Route route = new Route();
        List<UserDetailsDto> userDetailsDtos = new ArrayList<>();
        // 获取用户组下所有的用户信息
        try {
            ResponseModel<List<UserDetailsDto>> groupAndPersonInfo = tzsFeign.getGroupAndPersonInfo(Long.valueOf(plan.getUserGroupId()));
            userDetailsDtos = groupAndPersonInfo.getResult();
        } catch (Exception e) {
            log.error(e.getMessage());
        }
        System.out.println(userDetailsDtos.size() + "===================");
        return PlanTaskUtil.genWholeExeData(timeList, plan, userDetailsDtos, route);
    }

    private ExecutorService threadPool = Executors.newCachedThreadPool();

    /**
     * plantask及det入库
     *
     * @param list
     * @param plan
     * @param flag 是否初始状态0-初始 1-非初始
     */
    public void insertPlanTaskAndDetNew(List<HashMap<String, Object>> list, Plan plan, String flag, Date now) {
        if (list == null || list.size() <= 0) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("id", plan.getId());
            paramMap.put("next_gen_date", DateUtil.formatDatrToStr(now, "yyyy-MM-dd"));
            planMapper.updPlanStatusOrGenDate(paramMap);// 更新下次任务生成日期
        } else {
            try {
                String isFixDate = plan.getIsFixedDate();// 是否固定日期
                String planType = PlanTaskTypeStatusEnum.getEnum(Integer.valueOf(plan.getPlanType())).getName();
                List<Long> pointIdList = iRoutePointDao.queryRoutePointIds(plan.getRouteId());
                int pointNum = iRoutePointDao.countRoutePoint(plan.getRouteId());
                long batchNo = now.getTime();

                List<PlanTaskDetail> planTaskDetailListSync = new ArrayList<>();
                PlanTask planTask = new PlanTask();
                List<PlanTask> taskList = new ArrayList<>();
                List<ESPlanTaskListDto> esPlanTaskListDtos = new ArrayList<>();
                for (int i = 0; i < list.size(); i++) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String startTime = list.get(i).get("BEGIN_TIME").toString();
                    String endTime = list.get(i).get("END_TIME").toString();
                    String userId = list.get(i).get("USER_ID") == null ? "-1" : list.get(i).get("USER_ID").toString();
                    String userDept = list.get(i).get("USER_DEPT") == null ? "-1" : list.get(i).get("USER_DEPT").toString();
                    String userName = list.get(i).get("USER_NAME") == null ? "-1" : String.valueOf(list.get(i).get("USER_NAME"));
                    String orgCode = list.get(i).get("ORG_CODE") == null ? "-1" : String.valueOf(list.get(i).get("ORG_CODE"));
                    String unitCode = list.get(i).get("UNIT_CODE") == null ? "-1" : String.valueOf(list.get(i).get("UNIT_CODE"));

                    planTask = new PlanTask();

                    //修改巡检p_plan_task orgcode为执行人的org_code  -- add by wujunkai 20201216
                    planTask.setOrgCode(orgCode);
                    planTask.setUserName(userName);
                    planTask.setUseCode(unitCode);
                    planTask.setPlanType(plan.getPlanType());
                    planTask.setPlanId(plan.getId());
                    planTask.setBatchNo(batchNo);
                    planTask.setRouteId(plan.getRouteId());
                    planTask.setInOrder(plan.getInOrder());
                    planTask.setUserId(userId);
                    planTask.setUserDept(userDept);
                    planTask.setPointNum(pointNum);
                    if (XJConstant.FIX_DATE_NO.equals(isFixDate)) {
                        if (sdf.parse(startTime).getTime() <= now.getTime() && sdf.parse(endTime).getTime() >= now.getTime()) {
                            planTask.setFinishStatus(XJConstant.TASK_STATUS_DEAL);
                            planTask.setFinishNum(0);
                        } else {
                            if (sdf.parse(endTime).getTime() < now.getTime()) {
                                planTask.setFinishStatus(XJConstant.TASK_STATUS_TIMEOUT);
                                planTask.setFinishNum(0);
                            }
                        }
                    } else {
                        if (sdf.parse(startTime).getTime() <= now.getTime() && sdf.parse(endTime).getTime() >= now.getTime()) {
                            planTask.setFinishStatus(XJConstant.TASK_STATUS_DEAL);
                            planTask.setFinishNum(0);
                        }
                        if (sdf.parse(endTime).getTime() < now.getTime()) {
                            planTask.setFinishStatus(XJConstant.TASK_STATUS_TIMEOUT);
                            planTask.setFinishNum(0);
                        }
                    }
                    if (XJConstant.CHECK_CHANGE_YES.equals(flag)) {
                        planTask.setFinishStatus(XJConstant.TASK_STATUS_FINISH);
                        planTask.setFinishNum(pointNum);
                    }
                    if (XJConstant.FIX_DATE_YES.equals(isFixDate) || (XJConstant.FIX_DATE_NO.equals(isFixDate)
                            && XJConstant.PLAN_TYPE_DAY.equals(plan.getPlanType()))) {
                        planTask.setCheckDate(list.get(i).get("BEGIN_TIME").toString().substring(0, 10));
                    }
                    planTask.setBeginTime(startTime);
                    planTask.setEndTime(endTime);
                    // 1.保存执行数据主表
                    // iplanTaskDao.saveAndFlush(planTask);
                    taskList.add(planTask);
                    // 发送APP待办消息       (20220617  改为定时任务发送消息)
//                sendMessage(plan, planTask);
                    String executorId = planTask.getUserId();
                    em.persist(planTask);

                    for (int i1 = 0; i1 < pointIdList.size(); i1++) {
                        Number pointId = pointIdList.get(i1);
                        PlanTaskDetail planTaskDetailInstance = new PlanTaskDetail();
                        planTaskDetailInstance.setPointId(pointId.longValue());
                        planTaskDetailInstance.setTaskNo(planTask.getId());
                        planTaskDetailInstance.setStatus("0");
                        if (XJConstant.TASK_STATUS_TIMEOUT == planTask.getFinishStatus()) {
                            planTaskDetailInstance.setIsFinish(Integer.parseInt(XJConstant.PLAN_TASK_DET_FINISH_OUT));
                            planTaskDetailInstance.setStatus("3");
                        }
                        if (XJConstant.CHECK_CHANGE_YES.equals(flag)) {
                            planTaskDetailInstance.setIsFinish(Integer.parseInt(XJConstant.PLAN_TASK_DET_FINISH_YES));
                            planTaskDetailInstance.setStatus("1");
                        }
//                    // 2.保存执行数据明细表
////                    planTaskDetail.saveAndFlush(planTaskDetailInstance);
                        planTaskDetailListSync.add(planTaskDetailInstance);
                    }
                    ESPlanTaskListDto esPlanTaskListDto = JSONObject.parseObject(toJSONString(planTask),
                            ESPlanTaskListDto.class);
                    esPlanTaskListDto.setPlanTaskId(String.valueOf(planTask.getId()));
                    esPlanTaskListDto.setId(String.valueOf(planTask.getId()));
                    esPlanTaskListDto.setPlanId(String.valueOf(plan.getId()));
                    esPlanTaskListDto.setTaskName(plan.getName());
                    esPlanTaskListDto.setType(planType);
                    esPlanTaskListDtos.add(esPlanTaskListDto);
                }
                em.flush();
                em.clear();
                //   mybatisService.saveBatch(taskList);

//            repositoryTs.batchSave(taskList);

                // 定时任务监控
                log.error("计划重做开始添加定时任务监控========");
                jobService.planTaskAddJob(planTask);

                Iterable<PlanTaskDetail> planTaskDetails = repositoryTs.batchSaveNoAsync(planTaskDetailListSync);

                // 3.如果为自动任务调用,则更新id，如果重做或且下次时间大于等于明天，则更新planTaskId到plan表
                Date genDate = DateUtil.str2Date(list.get(list.size() - 1).get("NEXT_GEN_DATE").toString(), "yyyy-MM-dd");//下次生成日期
                Date tomorrow = DateUtil.getIntervalDate(now, 1);//明天
                String strGenDate = list.get(list.size() - 1).get("NEXT_GEN_DATE").toString().substring(0, 10);
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("id", plan.getId());
                paramMap.put("next_gen_date", strGenDate);
                if (XJConstant.SCHED_FLAG.equals(flag)) {
                    paramMap.put("plan_task_id", 0);//修改为初始值
                    paramMap.put("first_flag", XJConstant.PLAN_FIRST_STATUS_NO);
                } else if (!XJConstant.SCHED_FLAG.equals(flag) && (genDate.getTime() - tomorrow.getTime() >= 0) && XJConstant.FIX_DATE_NO.equals(plan.getIsFixedDate())) {//更新日期及plantaskId到plan表
                    long planTaskId = iplanTaskDao.findMaxIdByBatchNo(batchNo);
                    paramMap.put("plan_task_id", planTaskId);// 更新新的任务id到plan
                    paramMap.put("first_flag", XJConstant.PLAN_FIRST_STATUS_NO);
                }
                if (DateUtil.str2Date(strGenDate, "yyyy-MM-dd").getTime() - now.getTime() < 0 || org.apache.commons.lang.StringUtils.isBlank(strGenDate)) {
                    paramMap.put("next_gen_date", DateUtil.formatDatrToStr(now, "yyyy-MM-dd"));
                }
                planMapper.updPlanStatusOrGenDate(paramMap);// 更新下次任务生成日期


                //存在事物,在事务提交之后执行
                asyncSaveEs(planTaskDetails, esPlanTaskListDtos);

            } catch (Exception e) {
                e.printStackTrace();
                log.error(e.getMessage());
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    private void asyncSaveEs(Iterable<PlanTaskDetail> planTaskDetails, List<ESPlanTaskListDto> esPlanTaskListDtos) {
        TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronizationAdapter() {
            @Override
            public void afterCommit() {
                //异步存储任务和任务详情到es
                asyncSavePlanTaskAndDetailListToEs(planTaskDetails, esPlanTaskListDtos);
            }
        });
    }

    @Async
    public void asyncSavePlanTaskAndDetailListToEs(Iterable<PlanTaskDetail> planTaskDetails, List<ESPlanTaskListDto> esPlanTaskListDtos) {
        log.info("异步存储任务和任务详情到es");
        Plan plan = planMapper.getPlan(esPlanTaskListDtos.get(0).getPlanId());
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        List<String> taskIds = planTaskMapper.getPlanTaskIds(plan.getId());
        List<ESTaskDetailDto> esTaskDetailDtos = new ArrayList<>();
        if (!ValidationUtil.isEmpty(taskIds)) {
            if (taskIds.size() > 5000) {
                int index = 5000;
                for (int i = 0; i < taskIds.size(); i += 5000) {
                    if (i + 5000 > taskIds.size()) {
                        index = taskIds.size() - i;
                    }
                    List<String> newList = taskIds.subList(i, i + index);
                    String ids = newList.stream().collect(Collectors.joining("','", "('", "')"));
                    List<ESTaskDetailDto> maps = planTaskMapper.selectTaskDetailList(ids);
                    esTaskDetailDtos.addAll(maps);
                }
            } else {
                String ids = taskIds.stream().collect(Collectors.joining("','", "('", "')"));
                List<ESTaskDetailDto> maps = planTaskMapper.selectTaskDetailList(ids);
                esTaskDetailDtos.addAll(maps);
            }
        }
        stopWatch.stop();
        log.info("获取点详情基础数据，耗时：{} 秒", stopWatch.getTotalTimeSeconds());

        StopWatch stopWatch1 = new StopWatch();
        stopWatch1.start();
        List<ESTaskDetailDto> esTaskInfo = planTaskMapper.selectTaskInfoList(plan.getId());
        stopWatch1.stop();
        log.info("获取点详情其他数据，耗时：{} 秒", stopWatch1.getTotalTimeSeconds());

        List<AppCheckInputRespone> pointInputs = planTaskMapper.selectPointInputs(plan.getRouteId());
        List<Map<String, String>> excludeItems = planTaskMapper.selectExcludeItemsByRoutId(plan.getRouteId());
        StopWatch stopWatch2 = new StopWatch();
        stopWatch2.start();
        Map<String, List<ESTaskDetailDto>> collect1 = esTaskInfo.stream().collect(Collectors.groupingBy(ESTaskDetailDto::getPlanTaskId));
        Map<String, List<AppCheckInputRespone>> collect2 = pointInputs.stream().collect(Collectors.groupingBy(AppCheckInputRespone::getPointId));

        for (Map<String, String> excludeItem : excludeItems) {
            List<AppCheckInputRespone> appCheckInputRespones = collect2.get(String.valueOf(excludeItem.get("point_id")));
            if (excludeItem.containsKey("exclude_items") && !ObjectUtils.isEmpty(excludeItem.get("exclude_items"))) {
                String[] exclude_items = excludeItem.get("exclude_items").split(",");
                List<AppCheckInputRespone> appCheckInputRespones1 = new ArrayList<>();
                for (String exclude_item : exclude_items) {
                    List<AppCheckInputRespone> collect = appCheckInputRespones.stream().filter(x -> x.getPointInputItemId().equals(exclude_item)).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(collect)) {
                        continue;
                    }
                    appCheckInputRespones1.add(collect.get(0));
                }
                appCheckInputRespones.removeAll(appCheckInputRespones1);
            }
            collect2.put(String.valueOf(excludeItem.get("point_id")), appCheckInputRespones);
//                String[] exclude_items = excludeItem.get("exclude_items").split(",");
//                List<AppCheckInputRespone> appCheckInputRespones = collect2.get(String.valueOf(excludeItem.get("point_id")));
//                List<AppCheckInputRespone> appCheckInputRespones1 = new ArrayList<>();
//                for (String exclude_item : exclude_items) {
//                    appCheckInputRespones1.add(appCheckInputRespones.stream().filter(x -> x.getPointInputItemId().equals(exclude_item)).collect(Collectors.toList()).get(0));
//                }
//                appCheckInputRespones.removeAll(appCheckInputRespones1);
//                collect2.put(String.valueOf(excludeItem.get("point_id")), appCheckInputRespones);
        }

        for (ESTaskDetailDto esTaskDetailDto : esTaskDetailDtos) {
            esTaskDetailDto.setPlanName(plan.getName());
            esTaskDetailDto.setBeginTime(collect1.get(esTaskDetailDto.getPlanTaskId()).get(0).getBeginTime());
            esTaskDetailDto.setEndTime(collect1.get(esTaskDetailDto.getPlanTaskId()).get(0).getEndTime());
            esTaskDetailDto.setTaskStatus(collect1.get(esTaskDetailDto.getPlanTaskId()).get(0).getTaskStatus());
            JSONObject appResponeMap = new JSONObject();
            appResponeMap.put("items", collect2.get(esTaskDetailDto.getPointId()));
            esTaskDetailDto.setAppCheckInput(appResponeMap);
        }
        stopWatch2.stop();
        log.info("组装点详情数据，耗时：{} 秒", stopWatch2.getTotalTimeSeconds());
        StopWatch stopWatch3 = new StopWatch();
        stopWatch3.start();
        if (!ValidationUtil.isEmpty(esTaskDetailDtos)) {
            if (esTaskDetailDtos.size() > 5000) {
                int index = 5000;
                for (int i = 0; i < esTaskDetailDtos.size(); i += 5000) {
                    if (i + 5000 > esTaskDetailDtos.size()) {
                        index = esTaskDetailDtos.size() - i;
                    }
                    List<ESTaskDetailDto> newList = esTaskDetailDtos.subList(i, i + index);
                    esTaskDetail.saveAll(newList);
                }
            } else {
                esTaskDetail.saveAll(esTaskDetailDtos);
            }
        }
        stopWatch3.stop();
        log.info("点详情数据存入es，耗时：{} 秒", stopWatch3.getTotalTimeSeconds());

        StopWatch stopWatch4 = new StopWatch();
        stopWatch4.start();
        List<PlanTaskDetail> planTaskDetailList = new ArrayList<>();
        if (!ValidationUtil.isEmpty(taskIds)) {
            if (taskIds.size() > 5000) {
                int index = 5000;
                for (int i = 0; i < taskIds.size(); i += 5000) {
                    if (i + 5000 > taskIds.size()) {
                        index = taskIds.size() - i;
                    }
                    List<String> newList = taskIds.subList(i, i + index);
                    String ids = newList.stream().collect(Collectors.joining(",", "(", ")"));
                    List<PlanTaskDetail> maps = planTaskMapper.selectTaskDetails(ids);
                    planTaskDetailList.addAll(maps);
                }
            } else {
                String ids = taskIds.stream().collect(Collectors.joining(",", "(", ")"));
                List<PlanTaskDetail> maps = planTaskMapper.selectTaskDetails(ids);
                planTaskDetailList.addAll(maps);
            }
        }
        stopWatch4.stop();
        log.info("planTaskDetails转化，耗时：{} 秒", stopWatch4.getTotalTimeSeconds());

        StopWatch stopWatch5 = new StopWatch();
        stopWatch5.start();
        List<String> planTaskIds = esPlanTaskListDtos.stream().map(ESPlanTaskListDto::getPlanTaskId).collect(Collectors.toList());
        List<PlanTaskStaticDto> planTaskStaticListMap = new ArrayList<>();
        if (!ValidationUtil.isEmpty(planTaskIds)) {
            if (planTaskIds.size() > 5000) {
                int index = 5000;
                for (int i = 0; i < planTaskIds.size(); i += 5000) {
                    if (i + 10000 > planTaskIds.size()) {
                        index = planTaskIds.size() - i;
                    }
                    List<String> newList = planTaskIds.subList(i, i + index);
                    String ids = newList.stream().collect(Collectors.joining("','", "('", "')"));
                    List<PlanTaskStaticDto> maps = queryPlanTaskStaticById(ids);
                    planTaskStaticListMap.addAll(maps);
                }
            } else {
                String ids = planTaskIds.stream().collect(Collectors.joining("','", "('", "')"));
                List<PlanTaskStaticDto> maps = queryPlanTaskStaticById(ids);
                planTaskStaticListMap.addAll(maps);
            }
        }
        stopWatch5.stop();
        log.info("esPlanTaskListDtos统计组装，耗时：{} 秒", stopWatch5.getTotalTimeSeconds());

        StopWatch stopWatch6 = new StopWatch();
        stopWatch6.start();
        Map<String, List<PlanTaskStaticDto>> collect3 = planTaskStaticListMap.stream().collect(Collectors.groupingBy(PlanTaskStaticDto::getPlanTaskId));
        Map<Long, List<PlanTaskDetail>> collect = planTaskDetailList.stream().collect(Collectors.groupingBy(PlanTaskDetail::getTaskNo));
        for (ESPlanTaskListDto esPlanTaskListDto : esPlanTaskListDtos) {
            esPlanTaskListDto.setPoints(collect.get(Long.valueOf(esPlanTaskListDto.getPlanTaskId())));
            if (!ValidationUtil.isEmpty(planTaskIds)) {
                esPlanTaskListDto.setFinshNum(ObjectUtils.isEmpty(collect3.get(esPlanTaskListDto.getPlanTaskId()).get(0).getFinshNum()) ? "0" : collect3.get(esPlanTaskListDto.getPlanTaskId()).get(0).getFinshNum());
                esPlanTaskListDto.setOmission(ObjectUtils.isEmpty(collect3.get(esPlanTaskListDto.getPlanTaskId()).get(0).getOmission()) ? "0" : collect3.get(esPlanTaskListDto.getPlanTaskId()).get(0).getOmission());
                esPlanTaskListDto.setUnqualified(ObjectUtils.isEmpty(collect3.get(esPlanTaskListDto.getPlanTaskId()).get(0).getUnqualified()) ? "0" : collect3.get(esPlanTaskListDto.getPlanTaskId()).get(0).getUnqualified());
                esPlanTaskListDto.setUnplan(ObjectUtils.isEmpty(collect3.get(esPlanTaskListDto.getPlanTaskId()).get(0).getUnplan()) ? "0" : collect3.get(esPlanTaskListDto.getPlanTaskId()).get(0).getUnplan());
                esPlanTaskListDto.setTaskPlanNum(ObjectUtils.isEmpty(collect3.get(esPlanTaskListDto.getPlanTaskId()).get(0).getTaskPlanNum()) ? "0" : collect3.get(esPlanTaskListDto.getPlanTaskId()).get(0).getTaskPlanNum());
            } else {
                esPlanTaskListDto.setFinshNum("0");
                esPlanTaskListDto.setOmission("0");
                esPlanTaskListDto.setUnqualified("0");
                esPlanTaskListDto.setUnplan("0");
                esPlanTaskListDto.setTaskPlanNum("0");
            }
        }
        stopWatch6.stop();
        log.info("esPlanTaskListDtos数据组装，耗时：{} 秒", stopWatch6.getTotalTimeSeconds());
        StopWatch stopWatch7 = new StopWatch();
        stopWatch7.start();
        saveEsPlanTaskList(esPlanTaskListDtos);
        stopWatch7.stop();
        log.info("任务存入es，耗时：{} 秒", stopWatch7.getTotalTimeSeconds());
    }


    public static CheckInput paraseSelect(CheckInput checkInput, String json) {
        JSONArray jsonArray = JSONArray.parseArray(json);
        if (!ObjectUtils.isEmpty(jsonArray)) {
            for (int i = 0; i < jsonArray.size(); i++) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String validateName = jsonObject.getString("name");
                String validateIsOk = jsonObject.getString("isOk");
                if (validateIsOk.equals("是")) {
                    checkInput.setInputValue(validateName);
                }
            }
        }
        return checkInput;
    }

    private List<PlanTaskStaticDto> queryPlanTaskStaticById(String planTaskIds) {
        return planTaskMapper.queryPlanTaskStaticById(planTaskIds);
    }


    public void saveEsPlanTaskList(List<ESPlanTaskListDto> esPlanTaskListDtos) {
        if (!ValidationUtil.isEmpty(esPlanTaskListDtos)) {
            if (esPlanTaskListDtos.size() > 5000) {
                int index = 5000;
                for (int i = 0; i < esPlanTaskListDtos.size(); i += 5000) {
                    if (i + 5000 > esPlanTaskListDtos.size()) {
                        index = esPlanTaskListDtos.size() - i;
                    }
                    List<ESPlanTaskListDto> newList = esPlanTaskListDtos.subList(i, i + index);
                    esPlanTaskList.saveAll(newList);
                }
            } else {
                esPlanTaskList.saveAll(esPlanTaskListDtos);
            }
        }
    }


    /**
     * plantask及det入库
     *
     * @param list
     * @param plan
     * @param flag 是否初始状态0-初始 1-非初始
     */
    public void insertPlanTaskAndDet(List<HashMap<String, Object>> list, Plan plan, String flag, Date now) {
        if (list == null || list.size() <= 0) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("id", plan.getId());
            paramMap.put("next_gen_date", DateUtil.formatDatrToStr(now, "yyyy-MM-dd"));
            planMapper.updPlanStatusOrGenDate(paramMap);// 更新下次任务生成日期
        }
        Map<String, String> deptMap = new HashMap<>();
        Map<String, Object> nameMap = new HashMap<>();
        try {
            String isFixDate = plan.getIsFixedDate();// 是否固定日期
            List<Long> pointIdList = iRoutePointDao.queryRoutePointIds(plan.getRouteId());
            int pointNum = iRoutePointDao.countRoutePoint(plan.getRouteId());
            long batchNo = now.getTime();

            List<AgencyUserModel> agencyUserModels = remoteSecurityService.listUserByUserIds(amosRequestContext.getToken(), amosRequestContext.getProduct(), amosRequestContext.getAppKey(), plan.getUserId());
            for (int i = 0; i < agencyUserModels.size(); i++) {
                //遍历获取orgcode
                nameMap.put(agencyUserModels.get(i).getUserId(), agencyUserModels.get(i).getRealName());
            }
            Set<String> departmentIds = new HashSet<>();
            List<String> depts = Arrays.asList(plan.getUserDept().split(","));
            depts.stream().forEach(dept -> {
                deptMap.put(dept.substring(0, dept.indexOf("@")), dept.substring(dept.indexOf("@") + 1));
            });
            for (String entry : deptMap.keySet()) {
                String entryValue = deptMap.get(entry);
                departmentIds.add(entryValue);
            }

            StringBuffer departmentIdBuffer = new StringBuffer();
            Iterator<String> it = departmentIds.iterator();
            while (it.hasNext()) {
                departmentIdBuffer.append(it.next()).append(",");
            }
            Map<String, String> orgCodeMap = new HashMap<>();

            if (departmentIds.size() > 0) {
                List<DepartmentModel> departmentModels = remoteSecurityService.getlistDepartmentByDeptIds(amosRequestContext.getToken(), amosRequestContext.getProduct(), amosRequestContext.getAppKey(), departmentIdBuffer.toString().substring(0, departmentIdBuffer.toString().length() - 1));
                for (String key : deptMap.keySet()) {
                    String entryValue = deptMap.get(key);
                    if ("-1".equals(entryValue)) {
                        orgCodeMap.put(key, plan.getOrgCode());
                        continue;
                    }
                    for (DepartmentModel departmentModel : departmentModels) {
                        if (entryValue.equals(departmentModel.getSequenceNbr().toString())) {
                            orgCodeMap.put(key, departmentModel.getOrgCode());
                        }
                    }
                }
            }

            List<PlanTask> planTaskList = new ArrayList<>();
            for (int i = 0; i < list.size(); i++) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String startTime = list.get(i).get("BEGIN_TIME").toString();
                String endTime = list.get(i).get("END_TIME").toString();
                String userId = list.get(i).get("USER_ID") == null ? "-1" : list.get(i).get("USER_ID").toString();
                String userDept = list.get(i).get("USER_DEPT") == null ? "-1" : list.get(i).get("USER_DEPT").toString();
                PlanTask planTask = iplanTaskDao.findByUserIdAndBeginTimeAndEndTimeAndPlanIdAndRouteId(userId, startTime, endTime, plan.getId(), plan.getRouteId());
                if (planTask != null) {
                    continue;
                }
                planTask = new PlanTask();

                //修改巡检p_plan_task orgcode为执行人的org_code  -- add by wujunkai 20201216
                if (plan.getUserDept().indexOf(",") > 0 && plan.getIsSingleExecution() != true) {

                    Set<String> orgCodes = new HashSet<>();
                    StringBuffer nameBuffer = new StringBuffer();
                    orgCodeMap.forEach((key, entryValue) -> {
                        orgCodes.add(entryValue);
                    });
                    for (Map.Entry<String, Object> entry : nameMap.entrySet()) {
                        String entryValue = entry.getValue().toString();
                        nameBuffer.append(entryValue).append(",");
                    }
                    planTask.setOrgCode(orgCodes.toString().substring(1, orgCodes.toString().length() - 1));
                    planTask.setUserName(nameBuffer.toString().substring(0, nameBuffer.toString().length() - 1));

                } else {
                    planTask.setOrgCode(orgCodeMap.get(userId));
                    planTask.setUserName(nameMap.get(userId).toString());
                }

                planTask.setPlanId(plan.getId());
                planTask.setBatchNo(batchNo);
                planTask.setRouteId(plan.getRouteId());
                planTask.setInOrder(plan.getInOrder());
                planTask.setUserId(userId);
                planTask.setUserDept(userDept);
                planTask.setPointNum(pointNum);
                if (XJConstant.FIX_DATE_NO.equals(isFixDate)) {
                    if (sdf.parse(startTime).getTime() <= now.getTime() && sdf.parse(endTime).getTime() >= now.getTime()) {
                        planTask.setFinishStatus(XJConstant.TASK_STATUS_DEAL);
                        planTask.setFinishNum(0);
                    } else {
                        if (sdf.parse(endTime).getTime() < now.getTime()) {
                            planTask.setFinishStatus(XJConstant.TASK_STATUS_TIMEOUT);
                            planTask.setFinishNum(0);
                        }
                    }
                } else {
                    if (sdf.parse(startTime).getTime() <= now.getTime() && sdf.parse(endTime).getTime() >= now.getTime()) {
                        planTask.setFinishStatus(XJConstant.TASK_STATUS_DEAL);
                        planTask.setFinishNum(0);
                    }
                    if (sdf.parse(endTime).getTime() < now.getTime()) {
                        planTask.setFinishStatus(XJConstant.TASK_STATUS_TIMEOUT);
                        planTask.setFinishNum(0);
                    }
                }
                if (XJConstant.CHECK_CHANGE_YES.equals(flag)) {
                    planTask.setFinishStatus(XJConstant.TASK_STATUS_FINISH);
                    planTask.setFinishNum(pointNum);
                }
                if (XJConstant.FIX_DATE_YES.equals(isFixDate) || (XJConstant.FIX_DATE_NO.equals(isFixDate)
                        && XJConstant.PLAN_TYPE_DAY.equals(plan.getPlanType()))) {
                    planTask.setCheckDate(list.get(i).get("BEGIN_TIME").toString().substring(0, 10));
                }
                planTask.setBeginTime(startTime);
                planTask.setEndTime(endTime);
                // 1.保存执行数据主表
                iplanTaskDao.saveAndFlush(planTask);
                // 发送APP待办消息       (20220617  改为定时任务发送消息)
//                sendMessage(plan, planTask);
                String executorId = planTask.getUserId();
                long planId = planTask.getId();
                for (int i1 = 0; i1 < pointIdList.size(); i1++) {
                    Number pointId = pointIdList.get(i1);
                    PlanTaskDetail planTaskDetailInstance = new PlanTaskDetail();
                    planTaskDetailInstance.setPointId(pointId.longValue());
                    planTaskDetailInstance.setTaskNo(planId);
                    planTaskDetailInstance.setStatus("0");
                    if (XJConstant.TASK_STATUS_TIMEOUT == planTask.getFinishStatus()) {
                        planTaskDetailInstance.setIsFinish(Integer.parseInt(XJConstant.PLAN_TASK_DET_FINISH_OUT));
                        planTaskDetailInstance.setStatus("3");
                    }
                    if (XJConstant.CHECK_CHANGE_YES.equals(flag)) {
                        planTaskDetailInstance.setIsFinish(Integer.parseInt(XJConstant.PLAN_TASK_DET_FINISH_YES));
                        planTaskDetailInstance.setStatus("1");
                    }
                    // 2.保存执行数据明细表
                    planTaskDetail.saveAndFlush(planTaskDetailInstance);
                }
                // 定时任务监控
                jobService.planTaskAddJob(planTask);
                planTaskList.add(planTask);
            }

            // 3.如果为自动任务调用,则更新id，如果重做或且下次时间大于等于明天，则更新planTaskId到plan表
            Date genDate = DateUtil.str2Date(list.get(list.size() - 1).get("NEXT_GEN_DATE").toString(), "yyyy-MM-dd");//下次生成日期
            Date tomorrow = DateUtil.getIntervalDate(now, 1);//明天
            String strGenDate = list.get(list.size() - 1).get("NEXT_GEN_DATE").toString().substring(0, 10);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("id", plan.getId());
            paramMap.put("next_gen_date", strGenDate);
            if (XJConstant.SCHED_FLAG.equals(flag)) {
                paramMap.put("plan_task_id", 0);//修改为初始值
                paramMap.put("first_flag", XJConstant.PLAN_FIRST_STATUS_NO);
            } else if (!XJConstant.SCHED_FLAG.equals(flag) && (genDate.getTime() - tomorrow.getTime() >= 0) && XJConstant.FIX_DATE_NO.equals(plan.getIsFixedDate())) {//更新日期及plantaskId到plan表
                long planTaskId = iplanTaskDao.findMaxIdByBatchNo(batchNo);
                paramMap.put("plan_task_id", planTaskId);// 更新新的任务id到plan
                paramMap.put("first_flag", XJConstant.PLAN_FIRST_STATUS_NO);
            }
            if (DateUtil.str2Date(strGenDate, "yyyy-MM-dd").getTime() - now.getTime() < 0 || org.apache.commons.lang.StringUtils.isBlank(strGenDate)) {
                paramMap.put("next_gen_date", DateUtil.formatDatrToStr(now, "yyyy-MM-dd"));
            }
            planMapper.updPlanStatusOrGenDate(paramMap);// 更新下次任务生成日期
            //  巡检站端与中心级数据同步
            TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronization() {
                @Override
                public void afterCommit() {
                    // 事物提交后业务逻辑
                    patrolDataSyncService.planTaskDataSync(planTaskList);
                }
            });
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }


    //bug 5980 待办任务消息应只触发执行中的任务，漏检的任务和未开始的任务不需要触发待办任务消息.
    @Override
    @Transactional
    public void taskMessage(String runDate) {

        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        //1.扫描plan表查询，需要生成执行数据的任务信息，无则return
        Date now = new Date();//今天
        String format = df.format(now);
        if (runDate != null) {//上送则已上送的为准
            runDate = runDate + " " + format;
            now = DateUtil.str2Date(runDate, "yyyyMMdd HH:mm:ss");
        }
        List<Plan> planIdsByDate = planTaskMapper.getPlanIdsByDate(now);
        List<PlanTask> planTaskList = planTaskMapper.getPlanTaskList(now);
        Map<Long, Plan> collect = planIdsByDate.stream().collect(Collectors.toMap(Plan::getId, t -> t));

        for (PlanTask planTask : planTaskList) {
            if (!redisUtils.hasKey(PATROL_PLAN_TASK_KEY + planTask.getId())) {
                try {
                    sendMessage(collect.get(planTask.getPlanId()), planTask);
                } catch (Exception e) {
                    e.printStackTrace();
                }
                redisUtils.set(PATROL_PLAN_TASK_KEY + planTask.getId(), 1, (long) collect.get(planTask.getPlanId()).getDuration() * 60);
            }
        }
    }


    public void sendMessage(Plan plan, PlanTask planTask) throws Exception {
        RequestContext.setToken(amosRequestContext.getToken());
        RequestContext.setProduct(amosRequestContext.getProduct());
        RequestContext.setAppKey(amosRequestContext.getAppKey());

        MsgRo msgRo = new MsgRo();
        // 标题
        msgRo.setName(plan.getName());
        // 内容
        String body = "";
        body += "待执行巡检任务" + TAB;
        body += "巡检任务名称：" + plan.getName() + TAB;
        body += "执行时间：" + planTask.getBeginTime() + "-" + planTask.getEndTime();
        msgRo.setContent(body);
        // 接收人
        ArrayList<String> userIdList = new ArrayList<>();
        userIdList.add(planTask.getUserId());
        msgRo.setRecivers(userIdList);
        msgRo.setMsgType(msgType);
        msgRo.setTerminal(APP_WEB);
        msgRo.setSendTime(DateTime.now().toString());
        // 关联id
        msgRo.setRelationId(String.valueOf(plan.getId()));
        // 扩展参数
        HashMap<String, String> extras = new HashMap<>();
        extras.put("type", msgType);
        extras.put("planId", String.valueOf(plan.getId()));
        extras.put("planTaskId", String.valueOf(planTask.getId()));
        msgRo.setExtras(extras);
        msgRo.setIsSendApp(true);
        msgRo.setIsSendWeb(true);
        msgRo.setCategory(RuleConstant.TASK);
//        PushMsgParam pushMsgParam = new PushMsgParam();
//        rulePlanService.sendRule(pushMsgParam);
        log.info("巡检待办任务：%s {}", JSON.toJSON(msgRo));
        //触发规则
        ruleTrigger.publish(msgRo, packageId, new String[0]);
    }

    @Override
    public List<PlanTask> getPlanTaskByRouteId(Long routeId) {
        List<PlanTask> planTaskList = planTaskMapper.getPlanTaskByRouteId(routeId);
        return planTaskList;
    }

    @Override
    public void disablePlanTask(Long[] planTaskIds) {
        // planTask表中status字段置为1
        for (long planTaskId : planTaskIds) {
            List<PlanTask> planTaskList = getPlanTaskByRouteId(planTaskId);
            for (PlanTask planTask : planTaskList) {
                planTask.setStatus((byte) 1);
                iplanTaskDao.save(planTask);
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void handleAll(String id, String userId) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        // todo 1.改成批量查询
        Optional<PlanTask> planTaskOptional = iplanTaskDao.findById(Long.valueOf(id));
        PlanTask planTask = planTaskOptional.get();
        stopWatch.stop();
        log.info("一键提交=========> 获取planTask耗时 :{}s", stopWatch.getTotalTimeSeconds());
        if (planTask.getFinishStatus() == XJConstant.TASK_STATUS_DEAL) {
            planTask.setFinishStatus(XJConstant.TASK_STATUS_FINISH);
            if (planTask.getRiskStatus() != 1) {
                planTask.setRiskStatus(XJConstant.NORISK_NUM);
            }
            stopWatch.start();
            iplanTaskDao.saveAndFlush(planTask);
            stopWatch.stop();
            log.info("一键提交=========> 更新planTask耗时 :{}s", stopWatch.getTotalTimeSeconds());
            stopWatch.start();
            // 生成巡检记录
            jobService.createCheckRecord(planTask, userId);
            stopWatch.stop();
            log.info("一键提交=========> 生成createCheckRecord检记录耗时 :{}s", stopWatch.getTotalTimeSeconds());

            // 更新统计表
            if (planTask.getPlanType().equals(String.valueOf(PlanTaskTypeStatusEnum.day.getValue()))) {
                planTaskMapper.updateSingle(P_STATIC_DAY, XJConstant.RISK_NUM == planTask.getRiskStatus() ? 1 : 0,
                        XJConstant.NORISK_NUM == planTask.getRiskStatus() ? 1 : 0,
                        planTask.getOrgCode(), planTask.getCheckDate());
            } else if (planTask.getPlanType().equals(String.valueOf(PlanTaskTypeStatusEnum.week.getValue()))) {
                planTaskMapper.updateSingle(P_STATIC_WEEK, XJConstant.RISK_NUM == planTask.getRiskStatus() ? 1 : 0,
                        XJConstant.NORISK_NUM == planTask.getRiskStatus() ? 1 : 0,
                        planTask.getOrgCode(), planTask.getCheckDate());
            } else {
                planTaskMapper.updateSingle(P_STATIC_WEEK, XJConstant.RISK_NUM == planTask.getRiskStatus() ? 1 : 0,
                        XJConstant.NORISK_NUM == planTask.getRiskStatus() ? 1 : 0,
                        planTask.getOrgCode(), planTask.getCheckDate());
            }
            stopWatch.start();
            List<PlanTaskDetail> planTaskDetails = iPlanTaskDetailDao.findAllByTaskNoAndStatus(planTask.getId(), PlanTaskDetailStatusEnum.NOTSTARTED.getValue());
            stopWatch.stop();
            log.info("一键提交=========> planTaskDetails 耗时： {}s", stopWatch.getTotalTimeSeconds());
            List<ESTaskDetailDto> esTaskDetailDtos = new ArrayList<>();

            if (!planTaskDetails.isEmpty()) {
                Long routId = planTaskMapper.selectRoutId(id);
                planTaskDetails.stream().map(action -> {
                    action.setStatus(PlanTaskDetailStatusEnum.QUALIFIED.getValue());
                    iPlanTaskDetailDao.saveAndFlush(action);
//                    planTaskDetailMapper.finishTaskDetail(action.getId(), action.getPointId(),
//                            action.getPlanTask().getId(), userId);
//                    AppPointCheckRespone appPointCheckRespone = planService.queryPointPlanTaskDetail(null, null, null, action.getTaskNo(), action.getPointId());
                    ESTaskDetailDto esTaskDetailDto = esTaskDetail.findById(String.valueOf(action.getId())).get();

                    JSONObject appCheckInput = esTaskDetailDto.getAppCheckInput();

                    Map<String, List<Map<String, Object>>> mapList = (Map<String, List<Map<String, Object>>>) JSON.parse(appCheckInput.toJSONString());

                    List<AppCheckInputRespone> appCheckInputRespones = new ArrayList<>();

                    for (Map<String, Object> map : mapList.get("items")) {
                        AppCheckInputRespone appCheckInputRespone = new AppCheckInputRespone();
                        BeanUtils.copyProperties(appCheckInputRespone, map);

                        Long checkInputId = Long.valueOf(map.get("checkInputId").toString());
                        InputItem inputItem = inputItemDao.findById(checkInputId).get();
                        CheckInput checkInput = new CheckInput();

                        String itemType = String.valueOf(map.get("itemType"));
                        if (XJConstant.INPUT_ITEM_SELECT.equals(itemType)) {
                            checkInput = paraseSelect(checkInput, String.valueOf(map.get("dataJson")));
                            appCheckInputRespone = JSONObject.parseObject(toJSONString(checkInput),
                                    AppCheckInputRespone.class);
                        } else if (XJConstant.INPUT_ITEM_NUMBER.equals(itemType)) {
                            appCheckInputRespone.setInputValue(inputItem.getDefaultValue());
                        } else if (XJConstant.INPUT_ITEM_TEXT.equals(itemType)) {
                            appCheckInputRespone.setInputValue(inputItem.getDefaultValue());
                        }

                        appCheckInputRespone.setPointInputImgUrls(new ArrayList<>());
                        appCheckInputRespones.add(appCheckInputRespone);
                    }
                    appCheckInput.put("items", appCheckInputRespones);
                    esTaskDetailDto.setPointImgUrls(new ArrayList<>());
                    esTaskDetailDto.setAppCheckInput(appCheckInput);
                    esTaskDetailDto.setPointStatus(String.valueOf(PlanTaskDetailIsFinishEnum.FINISHED.getValue()));
                    esTaskDetail.save(esTaskDetailDto);

                    JSONObject jsonObject = jobService.getCheckInput(routId, action.getPointId(), "update", null);
                    esTaskDetailDto.setAppCheckInput(jsonObject);
                    esTaskDetailDto.setPointImgUrls(new ArrayList<>());
                    esTaskDetailDtos.add(esTaskDetailDto);
                    return action;
                }).collect(Collectors.toList());
            }
            esTaskDetail.saveAll(esTaskDetailDtos);

            ESPlanTaskListDto esPlanTaskListDto = esPlanTaskList.findById(String.valueOf(planTask.getId())).get();

            Map task = queryPlanTaskById(Long.valueOf(id));
            esPlanTaskListDto.setFinishStatus(String.valueOf(PlanTaskFinishStatusEnum.FINISHED.getValue()));
            esPlanTaskListDto.setFinshNum(ObjectUtils.isEmpty(task.get("finshNum")) ? "0" : task.get("finshNum").toString());
            esPlanTaskListDto.setOmission(ObjectUtils.isEmpty(task.get("omission")) ? "0" : task.get("omission").toString());
            esPlanTaskListDto.setUnqualified(ObjectUtils.isEmpty(task.get("unqualified")) ? "0" : task.get("unqualified").toString());
            esPlanTaskListDto.setUnplan(ObjectUtils.isEmpty(task.get("unplan")) ? "0" : task.get("unplan").toString());
            esPlanTaskListDto.setTaskPlanNum(ObjectUtils.isEmpty(task.get("taskPlanNum")) ? "0" : task.get("taskPlanNum").toString());
            List<PlanTaskDetail> planTaskDetailList = planTaskMapper.selectTaskDetails("('" + esPlanTaskListDto.getPlanTaskId() + "')");
            esPlanTaskListDto.setPoints(planTaskDetailList);

            esPlanTaskList.save(esPlanTaskListDto);
        }
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void handleAllBatch(String planTaskIds, String userId) {
//        StopWatch stopWatchAll = new StopWatch();
//        stopWatchAll.start();
//        StopWatch stopWatch1 = new StopWatch();
//        stopWatch1.start();
        // 1.数组准备：查询要一键提交的任务及更新状态
        List<PlanTask> planTasks = getPlanTasks(planTaskIds);
        if (planTasks.isEmpty()) {
            return;
        }
//        stopWatch1.stop();
//        log.info("planTasks耗时:{}",stopWatch1.getTotalTimeSeconds());

        // 2.数组准备：查询未完成状态的任务明细及更新状态
//        StopWatch stopWatch2 = new StopWatch();
//        stopWatch2.start();
        List<PlanTaskDetail> planTaskDetails = getWaitingDealPlanTaskDetails(planTasks);
//        stopWatch2.stop();
//        log.info("planTaskDetails耗时:{}",stopWatch2.getTotalTimeSeconds());

        // 3.数组准备: es存储数据组装
//        StopWatch stopWatch3 = new StopWatch();
//        stopWatch3.start();
        List<ESTaskDetailDto> esTaskDetailDtos = this.buildESTaskDetailDtoData(planTaskIds, planTaskDetails);
//        stopWatch3.stop();
//        log.info("esTaskDetailDtos耗时:{}",stopWatch3.getTotalTimeSeconds());

//        StopWatch stopWatch4 = new StopWatch();
//        stopWatch4.start();
        List<ESPlanTaskListDto> esPlanTaskListDtos = this.buildESPlanTaskListDtoData(planTaskIds, esTaskDetailDtos, planTaskDetails);
//        stopWatch4.stop();
//        log.info("esPlanTaskListDtos耗时:{}",stopWatch4.getTotalTimeSeconds());

        // 4.保存页面必须的数据
//        StopWatch stopWatch5 = new StopWatch();
//        stopWatch5.start();
        saveMustData(esTaskDetailDtos, esPlanTaskListDtos, planTasks);
//        stopWatch5.stop();
//        log.info("saveMustData耗时:{}",stopWatch5.getTotalTimeSeconds());

//        StopWatch stopWatch6 = new StopWatch();
//        stopWatch6.start();
        this.sendInsertMessage(planTasks, planTaskDetails);
//        stopWatch6.stop();
//        log.info("sendInsertMessage耗时:{}",stopWatch6.getTotalTimeSeconds());
//        stopWatchAll.stop();
//        log.info("handleAllBatch总耗时:{}",stopWatchAll.getTotalTimeSeconds());
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void handleAllBatch2(String planTaskIds, String userId) {
        List<Long> planTaskIdsList = Arrays.stream(planTaskIds.split(","))
                .map(Long::parseLong)
                .collect(Collectors.toList());
        // 1.数组准备：查询要一键提交的任务及更新状态
        CompletableFuture<List<PlanTask>> planTasksFuture = CompletableFuture.supplyAsync(() -> iplanTaskDao.findAllByIdIn(planTaskIdsList), asyncServiceExecutor);
        // 2.数组准备：查询未完成状态的任务明细及更新状态
        CompletableFuture<List<PlanTaskDetail>> planTaskDetailsFuture = CompletableFuture.supplyAsync(() -> planTaskDetailMapper.findAllByIdIn(planTaskIdsList), asyncServiceExecutor);
        // 3.数组准备: es存储数据组装1
        CompletableFuture<List<ESTaskDetailDto>> allESTaskDetailDtosFuture = CompletableFuture.supplyAsync(() -> this.queryTaskDetailEs(planTaskIds), asyncServiceExecutor);
        // 4.数组准备: es存储数据组装2
        CompletableFuture<List<ESPlanTaskListDto>> esPlanTaskListDtosFuture = CompletableFuture.supplyAsync(() -> this.queryTaskListEs(planTaskIds), asyncServiceExecutor);
        CompletableFuture.allOf(planTasksFuture, planTaskDetailsFuture, allESTaskDetailDtosFuture, esPlanTaskListDtosFuture).join();
        List<PlanTask> planTasks = planTasksFuture.join();
        List<PlanTaskDetail> planTaskDetails = planTaskDetailsFuture.join();
        List<ESTaskDetailDto> esTaskDetailDtos = allESTaskDetailDtosFuture.join();
        List<ESPlanTaskListDto> esPlanTaskListDtos = esPlanTaskListDtosFuture.join();
        buildESTaskDetailDtoData2(esTaskDetailDtos, planTaskDetails);
        finishPlanTask(planTasks, planTaskDetails);
        buildESPlanTaskListDtoData2(esPlanTaskListDtos, esTaskDetailDtos, planTaskDetails);
        saveMustData(esTaskDetailDtos, esPlanTaskListDtos, planTasks);
        this.sendInsertMessage(planTasks, planTaskDetails);
    }

    private List<ESPlanTaskListDto> queryTaskListEs(String planTaskIds) {
        List<ESPlanTaskListDto> esPlanTaskListDtos = new ArrayList<>();
        BoolQueryBuilder boolMust = QueryBuilders.boolQuery();
        boolMust.must(QueryBuilders.termsQuery("planTaskId", planTaskIds.split(",")));
        esPlanTaskList.search(boolMust).forEach(esPlanTaskListDtos::add);
        return esPlanTaskListDtos;
    }

    private List<ESTaskDetailDto> queryTaskDetailEs(String planTaskIds) {
        List<ESTaskDetailDto> esTaskDetailDtos = new ArrayList<>();
        BoolQueryBuilder boolMust = QueryBuilders.boolQuery();
        boolMust.must(QueryBuilders.termsQuery("planTaskId", planTaskIds.split(",")));
        esTaskDetail.search(boolMust).forEach(esTaskDetailDtos::add);
        return esTaskDetailDtos;
    }

    private void finishPlanTask(List<PlanTask> planTasks, List<PlanTaskDetail> planTaskDetails) {
        planTasks.forEach(planTask -> {
            planTask.setFinishStatus(XJConstant.TASK_STATUS_FINISH);
            if (planTask.getRiskStatus() != 1) {
                planTask.setRiskStatus(XJConstant.NORISK_NUM);
            }
        });
        planTaskDetails.stream().filter(p-> PlanTaskDetailStatusEnum.NOTSTARTED.getValue().equals(p.getStatus())).forEach(planTaskDetail -> {
            planTaskDetail.setStatus(PlanTaskDetailStatusEnum.QUALIFIED.getValue());
            planTaskDetail.setIsFinish(PlanTaskDetailIsFinishEnum.FINISHED.getValue());
        });
    }


    private void sendInsertMessage(List<PlanTask> planTasks, List<PlanTaskDetail> planTaskDetails) {
        CheckRecordDataDto dataDto = new CheckRecordDataDto();
        dataDto.setPlanTasks(planTasks);
        dataDto.setPlanTaskDetails(planTaskDetails);
        dataDto.setRequestContextModel(UserTransmittableUtils.getUser());
        publisher.publish(new CheckRecordInsertEvent(this, dataDto));
    }

    private void saveMustData(List<ESTaskDetailDto> esTaskDetailDtos, List<ESPlanTaskListDto> esPlanTaskListDtos, List<PlanTask> planTasks) {
        // 保存es数据
        CompletableFuture<Void> future1 = CompletableFuture.runAsync(() -> savePlanTaskDetails(esTaskDetailDtos), asyncServiceExecutor);
        CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> savePlanTasks(esPlanTaskListDtos), asyncServiceExecutor);
        // 更新统计数据表
        CompletableFuture<Void> future3 = CompletableFuture.runAsync(() -> updateStaticTable(planTasks), asyncServiceExecutor);
        CompletableFuture<Void> allOfFuture = CompletableFuture.allOf(future1, future2, future3);
        allOfFuture.join();
    }

    private void savePlanTaskDetails(List<ESTaskDetailDto> esTaskDetailDtos) {
        try {
            List<EsEntity<ESTaskDetailDto>> batchList = esTaskDetailDtos.stream()
                    .map(item -> new EsEntity<>(item.getId().toString(), item)).collect(Collectors.toList());
            this.updateBatch("web_app_task_detail", batchList);
//            esTaskDetail.saveAll(esTaskDetailDtos);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    /**
     * Description: 批量插入数据
     *
     * @param index index
     * @param list  插入列表
     * @author LiuLin
     */
    public <T> void insertBatch(String index, List<EsEntity<T>> list) {
        BulkRequest request = new BulkRequest();
        list.forEach(item -> request.add(new IndexRequest(index).id(item.getId())
                .source(JSON.toJSONString(item.getData()), XContentType.JSON)));
        try {
            restHighLevelClient.bulk(request, RequestOptions.DEFAULT);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Description: 批量修改数据
     *
     * @param index index
     * @param list  更新列表
     * @author LiuLin
     */
    public <T> void updateBatch(String index, List<EsEntity<T>> list) {
        BulkRequest request = new BulkRequest();
        list.forEach(item -> request.add(new UpdateRequest(index, item.getId())
                .doc(JSON.toJSONString(item.getData()), XContentType.JSON)));
        try {
            request.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            restHighLevelClient.bulk(request, RequestOptions.DEFAULT);
            list.forEach(s -> log.info("===========索引：【{}】，主键：【{}】修改成功", index, s.getId()));
        } catch (Exception e) {
            log.error("索引：[{}]", index, e);
        }
    }

    private void savePlanTasks(List<ESPlanTaskListDto> esPlanTaskListDtos) {
        try {
//            esPlanTaskList.saveAll(esPlanTaskListDtos);
            List<EsEntity<ESPlanTaskListDto>> batchList = esPlanTaskListDtos.stream()
                    .map(item -> new EsEntity<>(item.getPlanTaskId(), item)).collect(Collectors.toList());
            this.updateBatch("web_app_plan_task_list", batchList);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }


    private void updateStaticTable(List<PlanTask> planTasks) {
        List<StaticTableUpdateDto> staticTableUpdateDtos = planTasks.stream().map(planTask -> {
            StaticTableUpdateDto updateDto = new StaticTableUpdateDto();
            updateDto.setTable(this.getTable(planTask));
            updateDto.setRiskEnd(XJConstant.RISK_NUM == planTask.getRiskStatus() ? 1 : 0);
            updateDto.setNoRiskEnd(XJConstant.NORISK_NUM == planTask.getRiskStatus() ? 1 : 0);
            updateDto.setOrgCode(planTask.getOrgCode());
            updateDto.setCheckTime(planTask.getCheckDate());
            return updateDto;
        }).collect(Collectors.toList());
        planTaskMapper.updateStaticTableBatch(staticTableUpdateDtos);
    }

    private String getTable(PlanTask planTask) {
        if (planTask.getPlanType().equals(String.valueOf(PlanTaskTypeStatusEnum.day.getValue()))) {
            return P_STATIC_DAY;
        } else if (planTask.getPlanType().equals(String.valueOf(PlanTaskTypeStatusEnum.week.getValue()))) {
            return P_STATIC_WEEK;
        } else {
            return P_STATIC_MONTH;
        }
    }

    private List<ESTaskDetailDto> buildESTaskDetailDtoData(String planTaskIds, List<PlanTaskDetail> planTaskDetails) {
        //  查询所有的
        List<ESTaskDetailDto> allESTaskDetailDtos = this.queryTaskDetailEs(planTaskIds);
        Map<Long, ESTaskDetailDto> esTaskDetailDtoMap = allESTaskDetailDtos.stream().collect(Collectors.toMap(ESTaskDetailDto::getId, Function.identity()));
        // 只更新未完成状态
        planTaskDetails.forEach(planTaskDetail -> {
            ESTaskDetailDto esTaskDetailDto = esTaskDetailDtoMap.get(planTaskDetail.getId());
            JSONObject appCheckInput = esTaskDetailDto.getAppCheckInput();
            Map<String, List<Map<String, Object>>> mapList = (Map<String, List<Map<String, Object>>>) JSON.parse(appCheckInput.toJSONString());
            List<AppCheckInputRespone> appCheckInputRespones = new ArrayList<>();
            for (Map<String, Object> map : mapList.get("items")) {
                AppCheckInputRespone appCheckInputRespone = new AppCheckInputRespone();
                BeanUtil.copyProperties(map, appCheckInputRespone);
                InputItem inputItem = inputItemDao.getOne(Long.parseLong(map.get("checkInputId").toString()));
                CheckInput checkInput = new CheckInput();
                String itemType = String.valueOf(map.get("itemType"));
                if (XJConstant.INPUT_ITEM_SELECT.equals(itemType)) {
                    paraseSelect(checkInput, String.valueOf(map.get("dataJson")));
                    appCheckInputRespone.setInputValue(checkInput.getInputValue());
                } else if (XJConstant.INPUT_ITEM_NUMBER.equals(itemType)) {
                    appCheckInputRespone.setInputValue(inputItem.getDefaultValue());
                } else if (XJConstant.INPUT_ITEM_TEXT.equals(itemType)) {
                    appCheckInputRespone.setInputValue(inputItem.getDefaultValue());
                }

                appCheckInputRespone.setPointInputImgUrls(new ArrayList<>());
                appCheckInputRespones.add(appCheckInputRespone);
            }
            appCheckInput.put("items", appCheckInputRespones);
            esTaskDetailDto.setPointImgUrls(new ArrayList<>());
            esTaskDetailDto.setAppCheckInput(appCheckInput);
            esTaskDetailDto.setPointStatus(String.valueOf(PlanTaskDetailIsFinishEnum.FINISHED.getValue()));
            esTaskDetailDto.setPointImgUrls(new ArrayList<>());
        });
        return allESTaskDetailDtos;

    }

    private void buildESTaskDetailDtoData2(List<ESTaskDetailDto> allESTaskDetailDtos, List<PlanTaskDetail> planTaskDetails) {
        // 查询所有的
        Map<Long, ESTaskDetailDto> esTaskDetailDtoMap = allESTaskDetailDtos.stream().collect(Collectors.toMap(ESTaskDetailDto::getId, Function.identity()));
        // 只更新未完成状态
        planTaskDetails.stream().filter(p-> PlanTaskDetailStatusEnum.NOTSTARTED.getValue().equals(p.getStatus())).forEach(planTaskDetail -> {
            ESTaskDetailDto esTaskDetailDto = esTaskDetailDtoMap.get(planTaskDetail.getId());
            JSONObject appCheckInput = esTaskDetailDto.getAppCheckInput();
            Map<String, List<Map<String, Object>>> mapList = (Map<String, List<Map<String, Object>>>) JSON.parse(appCheckInput.toJSONString());
            List<AppCheckInputRespone> appCheckInputRespones = new ArrayList<>();
            for (Map<String, Object> map : mapList.get("items")) {
                AppCheckInputRespone appCheckInputRespone = new AppCheckInputRespone();
                BeanUtil.copyProperties(map, appCheckInputRespone);
                InputItem inputItem = inputItemDao.getOne(Long.parseLong(map.get("checkInputId").toString()));
                CheckInput checkInput = new CheckInput();
                String itemType = String.valueOf(map.get("itemType"));
                if (XJConstant.INPUT_ITEM_SELECT.equals(itemType)) {
                    paraseSelect(checkInput, String.valueOf(map.get("dataJson")));
                    appCheckInputRespone.setInputValue(checkInput.getInputValue());
                } else if (XJConstant.INPUT_ITEM_NUMBER.equals(itemType)) {
                    appCheckInputRespone.setInputValue(inputItem.getDefaultValue());
                } else if (XJConstant.INPUT_ITEM_TEXT.equals(itemType)) {
                    appCheckInputRespone.setInputValue(inputItem.getDefaultValue());
                }

                appCheckInputRespone.setPointInputImgUrls(new ArrayList<>());
                appCheckInputRespones.add(appCheckInputRespone);
            }
            appCheckInput.put("items", appCheckInputRespones);
            esTaskDetailDto.setPointImgUrls(new ArrayList<>());
            esTaskDetailDto.setAppCheckInput(appCheckInput);
            esTaskDetailDto.setPointStatus(String.valueOf(PlanTaskDetailIsFinishEnum.FINISHED.getValue()));
            esTaskDetailDto.setPointImgUrls(new ArrayList<>());
        });
    }

    private List<ESPlanTaskListDto> buildESPlanTaskListDtoData(String planTaskIds, List<ESTaskDetailDto> esTaskDetailDtos, List<PlanTaskDetail> planTaskDetails) {
        List<ESPlanTaskListDto> esPlanTaskListDtos = this.queryTaskListEs(planTaskIds);
        esPlanTaskListDtos.forEach(esPlanTaskListDto -> {
            esPlanTaskListDto.setFinishStatus(String.valueOf(PlanTaskFinishStatusEnum.FINISHED.getValue()));
            esPlanTaskListDto.setFinshNum(this.filterByStatus("1", esPlanTaskListDto.getPlanTaskId(), esTaskDetailDtos));
            esPlanTaskListDto.setOmission(this.filterByStatus("3", esPlanTaskListDto.getPlanTaskId(), esTaskDetailDtos));
            esPlanTaskListDto.setUnqualified(this.filterByStatus("2", esPlanTaskListDto.getPlanTaskId(), esTaskDetailDtos));
            esPlanTaskListDto.setUnplan(this.filterByStatus("0", esPlanTaskListDto.getPlanTaskId(), esTaskDetailDtos));
            esPlanTaskListDto.setTaskPlanNum(this.filterByStatus("1", esPlanTaskListDto.getPlanTaskId(), esTaskDetailDtos));
            esPlanTaskListDto.setPoints(this.buildPlanTaskPoint(esPlanTaskListDto.getPlanTaskId(), planTaskDetails));
        });
        return esPlanTaskListDtos;
    }

    private void buildESPlanTaskListDtoData2(List<ESPlanTaskListDto> esPlanTaskListDtos, List<ESTaskDetailDto> esTaskDetailDtos, List<PlanTaskDetail> planTaskDetails) {
        esPlanTaskListDtos.forEach(esPlanTaskListDto -> {
            esPlanTaskListDto.setFinishStatus(String.valueOf(PlanTaskFinishStatusEnum.FINISHED.getValue()));
            esPlanTaskListDto.setFinshNum(this.filterByStatus("1", esPlanTaskListDto.getPlanTaskId(), esTaskDetailDtos));
            esPlanTaskListDto.setOmission(this.filterByStatus("3", esPlanTaskListDto.getPlanTaskId(), esTaskDetailDtos));
            esPlanTaskListDto.setUnqualified(this.filterByStatus("2", esPlanTaskListDto.getPlanTaskId(), esTaskDetailDtos));
            esPlanTaskListDto.setUnplan(this.filterByStatus("0", esPlanTaskListDto.getPlanTaskId(), esTaskDetailDtos));
            esPlanTaskListDto.setTaskPlanNum(this.filterByStatus("1", esPlanTaskListDto.getPlanTaskId(), esTaskDetailDtos));
            esPlanTaskListDto.setPoints(this.buildPlanTaskPoint(esPlanTaskListDto.getPlanTaskId(), planTaskDetails));
        });
    }

    private List<PlanTaskDetail> buildPlanTaskPoint(String planTaskId, List<PlanTaskDetail> planTaskDetails) {
        return planTaskDetails.stream().filter(t -> Long.parseLong(planTaskId) == t.getTaskNo()).collect(Collectors.toList());
    }

    private String filterByStatus(String status, String planTaskId, List<ESTaskDetailDto> esTaskDetailDtos) {
        long count = esTaskDetailDtos.stream().filter(e -> e.getPlanTaskId().equals(planTaskId) && e.getPointStatus().equals(status)).count();
        return String.valueOf(count);
    }

    private List<PlanTaskDetail> getWaitingDealPlanTaskDetails(List<PlanTask> planTasks) {
        List<Long> planTaskIdsList = planTasks.stream().map(BasicEntity::getId).collect(Collectors.toList());
        List<PlanTaskDetail> planTaskDetails = planTaskDetailMapper.findAllByIdInAndStatus(planTaskIdsList, PlanTaskDetailStatusEnum.NOTSTARTED.getValue());
        planTaskDetails.forEach(planTaskDetail -> {
            planTaskDetail.setStatus(PlanTaskDetailStatusEnum.QUALIFIED.getValue());
        });
        return planTaskDetails;
    }

    private List<PlanTask> getPlanTasks(String planTaskIds) {
        List<Long> planTaskIdsList = Arrays.stream(planTaskIds.split(","))
                .map(Long::parseLong)
                .collect(Collectors.toList());
        List<PlanTask> planTasks = iplanTaskDao.findAllByIdIn(planTaskIdsList);
        List<PlanTask> result = planTasks.stream().filter(p -> p.getFinishStatus() == XJConstant.TASK_STATUS_DEAL).collect(Collectors.toList());
        result.forEach(planTask -> {
            planTask.setFinishStatus(XJConstant.TASK_STATUS_FINISH);
            if (planTask.getRiskStatus() != 1) {
                planTask.setRiskStatus(XJConstant.NORISK_NUM);
            }
        });
        return result;
    }


    @Override
    public List getPlanTaskInfo(HashMap<String, Object> param) {
        return planTaskMapper.getPlanTaskByPointId(param);
    }

    @Override
    public Map findPlanTaskByTaskIdAndPointId(long plantaskId, long pointId) {
        return planTaskDetailMapper.findPlanTaskByTaskIdAndPointId(plantaskId, pointId);
    }

    @Override
    public Page<Map<String, Object>> getPlanTasks(String toke, String product, String appKey, HashMap<String, Object> params) {
        CommonPageable pageParam = new CommonPageable();
        List<Map<String, Object>> content = Lists.newArrayList();
        if (params.containsKey("finishStatus")) {
            params.put("finishStatus", String.valueOf(PlanTaskTheStatusEnum.getValue(params.get("finishStatus").toString())));
        }

        SearchRequest request = new SearchRequest();
        request.indices("web_app_plan_task_list");
        SearchSourceBuilder builder = new SearchSourceBuilder();
        builder.trackTotalHits(true);
        BoolQueryBuilder boolMust = QueryBuilders.boolQuery();

        if (!ObjectUtils.isEmpty(params.get("userId"))) {
            BoolQueryBuilder meBuilder = QueryBuilders.boolQuery();
            String test = QueryParser.escape(params.get("userId").toString());
            meBuilder.must(QueryBuilders.wildcardQuery("userId", "*" + test + "*"));
            boolMust.must(meBuilder);
        }

        if (!ObjectUtils.isEmpty(params.get("finishStatus"))) {
            BoolQueryBuilder query = QueryBuilders.boolQuery();
            query.must(QueryBuilders.matchPhraseQuery("finishStatus", "*" + params.get("finishStatus") + "*"));
            boolMust.must(query);
        }
        if (!ObjectUtils.isEmpty(params.get("type"))) {
            BoolQueryBuilder query = QueryBuilders.boolQuery();
            query.must(QueryBuilders.matchPhraseQuery("type", "*" + params.get("type") + "*"));
            boolMust.must(query);
        }

        if (!ObjectUtils.isEmpty(params.get("startTime"))) {
            BoolQueryBuilder query = QueryBuilders.boolQuery();
            query.must(QueryBuilders.rangeQuery("beginTime").gte(params.get("startTime")));
            boolMust.must(query);
        }

        if (!ObjectUtils.isEmpty(params.get("endTime"))) {
            BoolQueryBuilder query = QueryBuilders.boolQuery();
            query.must(QueryBuilders.rangeQuery("endTime").lte(params.get("endTime")));
            boolMust.must(query);
        }

        builder.query(boolMust);
        if (!ValidationUtil.isEmpty(params.get("orderBy"))) {
            String[] split = params.get("orderBy").toString().split(" ");
            builder.sort(split[0], split[1].equals("desc") ? SortOrder.DESC : SortOrder.ASC);
        } else {
            builder.sort("checkDate", SortOrder.DESC);
        }


        builder.from((Integer.parseInt(params.get("number").toString())) * Integer.parseInt(params.get("size").toString()));
        builder.size(Integer.parseInt(params.get("size").toString()));
        request.source(builder);

        List<Map<String, Object>> list = new LinkedList<>();
        SearchResponse response = null;

        long totle = 0;
        try {
            response = restHighLevelClient.search(request, RequestOptions.DEFAULT);
            for (org.elasticsearch.search.SearchHit hit : response.getHits().getHits()) {
                JSONObject jsonObject = (JSONObject) JSONObject.toJSON(hit);
                JSONObject dto2 = jsonObject.getJSONObject("sourceAsMap");
                Map map = dto2;
                list.add(map);
            }
            totle = response.getInternalResponse().hits().getTotalHits().value;
            if (!CollectionUtils.isEmpty(list)) {
                list.forEach(e -> {
                    e.put("executiveName", e.get("userName"));
                });
            }
            return new PageImpl<>(list, pageParam, totle);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return new PageImpl<>(new ArrayList<>(), pageParam, 0);
    }

    @Override
    public Map queryPlanTaskById(Long planTaskId) {
        return planTaskMapper.queryPlanTaskById(planTaskId);
    }

    @Override
    public List getPlanTaskPoints(Long planTaskId) {
        return planTaskMapper.getPlanTaskPoints(planTaskId);
    }

    @Override
    public int getCurrentPlanTaskCount(String userId) {
        return planTaskMapper.getCurrentPlanTaskCount(userId);
    }

    @Override
    public List<PlanTaskVo> getPlanTaskListByIds(String toke, String product, String appKey, Long[] ids) {
        List<PlanTaskVo> content = planTaskMapper.getPlanTaskListByIds(ids);

        String userIds = "";
        String deptIds = "";
        Set<String> set = new HashSet<>();
        Set<String> deptIdSet = new HashSet<>();
        Map<Long, Set<String>> deptMap = new HashMap<>();
        content.forEach(s -> {
            String userDept = s.getUserDept();
            if (!ValidationUtil.isEmpty(userDept)) {
                String[] udStrs = userDept.split(",");
                for (String udStr : udStrs) {
                    try {
                        String[] split = udStr.split("@");
                        set.add(split[0]);
                        if (split.length > 1) {
                            if (!"-1".equals(split[1])) {
                                deptIdSet.add(split[1]);
                            }
                            if (!deptMap.containsKey(s.getId())) {
                                deptMap.put(s.getId(), new HashSet<>());
                            }
                            deptMap.get(s.getId()).add(split[1]);
                        }
                    } catch (Exception e) {
                    }
                }
            }
        });
        List<String> userList = new ArrayList<>(set);
        List<String> deptList = new ArrayList<>(deptIdSet);

        Map<String, String> LoginName = new HashMap<>();
        Map<String, String> userMap = new HashMap<>();
        Map<String, String> depMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(userList)) {
            userIds = String.join(",", userList);
            List<AgencyUserModel> userModelList = remoteSecurityService.listUserByUserIds(toke, product, appKey, userIds);
            userMap = userModelList.stream().collect(Collectors.toMap(AgencyUserModel::getUserId, AgencyUserModel::getRealName, (k1, k2) -> k2));
            for (AgencyUserModel agencyUserModel : userModelList) {
                LoginName.put(agencyUserModel.getUserId(), agencyUserModel.getMobile() != null ? agencyUserModel.getMobile() : agencyUserModel.getLandlinePhone());
            }
        }
        if (!CollectionUtils.isEmpty(deptList)) {
            String dept = String.join(",", deptList);
            List<LinkedHashMap> deptL = remoteSecurityService.listDepartmentByDeptIds(toke, product, appKey, dept);
            if (deptL != null && deptL.size() > 0) {
                //新安全
                content.forEach(s -> {
                    Set<String> set1 = deptMap.get(s.getId());
                    if (!ValidationUtil.isEmpty(set1)) {
                        deptL.forEach(s1 -> {
                            if (set1.contains(s1.get("sequenceNbr"))) {
                                if (!ValidationUtil.isEmpty(s.getDeptName())) {
                                    s.setDeptName(s.getDeptName() + "," + s1.get("departmentName"));
                                } else {
                                    s.setDeptName(s1.get("departmentName").toString());
                                }
                            }
                        });
                        if (set1.contains("-1")) {
                            if (!ValidationUtil.isEmpty(s.getDeptName())) {
                                s.setDeptName(s.getDeptName() + "," + "其他");
                            } else {
                                s.setDeptName("其他");
                            }
                        }
                    }
                });
            }
        }
        Map<String, String> finalUserMap = userMap;
        content.forEach(c -> {
            StringBuilder userNames = new StringBuilder("");
            List<String> userIdsList = Arrays.asList(c.getUserName().split(","));
            for (String userId : userIdsList) {
                userNames.append(finalUserMap.get(userId));
                userNames.append(",");
            }
            c.setUserName(userNames.toString());
        });
        return content;
    }

    @Override
    public List<PlanTaskVo> getPlanTaskListByIdsNew(Long[] ids) {
        List<PlanTaskVo> content = planTaskMapper.getPlanTaskListByIds(ids);

        return content;
    }

    @Override
    public Page<CheckChkExListBo> getChkExList(String toke, String product, String appKey, CheckPtListPageParam param) {
        long total = planTaskMapper.countChkExListData(param);
        List<CheckChkExListBo> content = planTaskMapper.getChkExList(param);

        //获取用户联系方式
        String userIds = "";
        Set<String> set = new HashSet<>();
        content.forEach(s -> {
            if (s.getRealName() != null) {
                String[] sArr = s.getRealName().split(",");
                set.addAll(Arrays.asList(sArr));
            }
        });
        List<String> userList = new ArrayList<>(set);
        Map<String, AgencyUserModel> agencyUserModelMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(userList)) {
            userIds = String.join(",", userList);
            List<AgencyUserModel> userModelList = remoteSecurityService.listUserByUserIds(toke, product, appKey, userIds);
            agencyUserModelMap = userModelList.stream().collect(Collectors.toMap(AgencyUserModel::getUserId, Function.identity()));
        }
        for (CheckChkExListBo bo : content) {
            ArrayList<String> names = new ArrayList<>();
            ArrayList<String> mobiles = new ArrayList<>();
            String nameStrings = String.join(",", names);

            String[] realNames = bo.getRealName().split(",");
            if (realNames.length > 1) {
                System.out.println("asd");
            }
            for (int i = 0; i < realNames.length; i++) {
                if (agencyUserModelMap.containsKey(realNames[i])) {
                    AgencyUserModel agencyUserModel = agencyUserModelMap.get(realNames[i]);
                    names.add(agencyUserModel.getRealName());
                    if (StringUtil.isNotEmpty(agencyUserModel.getMobile())) {
                        mobiles.add(agencyUserModel.getMobile());
                    }
                }

            }
            bo.setRealName(String.join(",", names));
            if (mobiles.size() > 0) {
                bo.setLoginName(String.join(",", mobiles));
            }
        }
        Page<CheckChkExListBo> result = new PageImpl<CheckChkExListBo>(content, param, total);
        return result;
    }


    @Override
    public HashMap<String, Object> getChkExListNew(String orgCode, CommonPageable commonPageable) {
        CheckPtListPageParam param = new CheckPtListPageParam();
        param.setPageNumber(commonPageable.getPageNumber());
        param.setPageSize(commonPageable.getPageSize());
        param.setOrgCode(orgCode);
        DateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        Date date = new Date();
        String c = dateFormat.format(date);
        param.setCheckDate(c);
        long total = planTaskMapper.countChkExListDataNew(param);
        List<CheckChkExListBo> content = planTaskMapper.getChkExListNew(param);
        Page<CheckChkExListBo> result = new PageImpl<CheckChkExListBo>(content, param, total);

        List<HashMap<String, Object>> colModel = new ArrayList<>();
        HashMap<String, Object> temph1 = new HashMap<>();
        temph1.put("fid", "name");
        temph1.put("dataIndex", "name");
        temph1.put("name", "巡检计划名称");
        temph1.put("title", "巡检计划名称");
        temph1.put("type", "name");
        temph1.put("key", "name");
        HashMap<String, Object> temph2 = new HashMap<>();
        temph2.put("fid", "lastTime");
        temph2.put("dataIndex", "lastTime");
        temph2.put("name", "开始时间");
        temph2.put("title", "开始时间");
        temph2.put("type", "lastTime");
        temph2.put("key", "lastTime");
        HashMap<String, Object> temph3 = new HashMap<>();
        temph3.put("fid", "endTime");
        temph3.put("dataIndex", "endTime");
        temph3.put("name", "结束时间");
        temph3.put("title", "结束时间");
        temph3.put("type", "endTime");
        temph3.put("key", "endTime");
        HashMap<String, Object> temph4 = new HashMap<>();
        temph4.put("fid", "finishStatus");
        temph4.put("dataIndex", "finishStatus");
        temph4.put("name", "完成情况");
        temph4.put("title", "完成情况");
        temph4.put("type", "finishStatus");
        temph4.put("key", "finishStatus");
        HashMap<String, Object> temph5 = new HashMap<>();
        temph5.put("fid", "realName");
        temph5.put("dataIndex", "realName");
        temph5.put("name", "巡检人员");
        temph5.put("title", "巡检人员");
        temph5.put("type", "realName");
        temph5.put("key", "realName");
        colModel.add(temph1);
        colModel.add(temph2);
        colModel.add(temph3);
        colModel.add(temph4);
        colModel.add(temph5);
        HashMap<String, Object> dataGridMock = new HashMap<>();
        dataGridMock.put("current", result.getNumber() + 1);
        dataGridMock.put("total", result.getTotalElements());
        dataGridMock.put("pagination", true);
        dataGridMock.put("totalPage", result.getTotalPages());
        dataGridMock.put("dataList", result.getContent());
        dataGridMock.put("pageSize", result.getSize());

        HashMap<String, Object> DATE = new HashMap<>();
        DATE.put("dataGridMock", dataGridMock);
        DATE.put("colModel", colModel);
        return DATE;
    }


    @Override
    public Map<String, Object> getPlanTaskStatisticsForApp(HashMap<String, Object> params) {
        return planTaskMapper.getPlanTaskStatisticsForApp(params);
    }


    @Override
    public AppPointCheckRespone queryPointPlanTaskDetailInVersion2(String toke, String product, String appKey, Long planTaskId, Long pointId) {
        AppPointCheckRespone pointCheckRespone = new AppPointCheckRespone();
        Check check = checkDao.findByPlanTaskIdAndPointId(planTaskId, pointId);
        if (check != null) {
            pointCheckRespone = checkService.queryCheckPointDetailInVersion2(toke, product, appKey, check.getId(), null, null);
        } else {
            PointCheckDetailBo planPointInfo = planTaskMapper.getPointPlanTaskInfo(planTaskId, pointId);

            if (planPointInfo != null) {
                pointCheckRespone.setPointId(pointId);
                pointCheckRespone.setPointName(planPointInfo.getPointName());
                pointCheckRespone.setPointNo(planPointInfo.getPointNo());
                pointCheckRespone.setPointStatus("0");
                pointCheckRespone.setPlanName(planPointInfo.getPlanName());
                List<AgencyUserModel> userModelList = remoteSecurityService.listUserByUserIds(toke, product, appKey, planPointInfo.getUserId());
                for (AgencyUserModel userModel : userModelList) {
                    pointCheckRespone.setUsername(userModel.getRealName());
                }
//                DepartmentModel departmentModel= remoteSecurityService.getDepartmentByDeptId(toke, product, appKey,planPointInfo.getCheckDepartmentId());
                DepartmentModel departmentModel = new DepartmentModel();
                pointCheckRespone.setDepartmentName(departmentModel.getDepartmentName());
                List<PointCheckDetailBo> pointInputs = planTaskMapper.getPointInputByRouteIdAndPointId(planPointInfo.getRouteId(), planPointInfo.getPointId());

                JSONObject appResponeMap = new JSONObject();
                pointInputs.forEach(action -> {
                    AppCheckInputRespone input = new AppCheckInputRespone();
                    input.setInputName(action.getInputName());
                    input.setCheckInputId(action.getCheckInputId());
                    input.setDataJson(action.getDataJson());
                    input.setIsMultiline(action.getIsMultiline());
                    input.setIsMust(action.getIsMust());
                    input.setItemType(action.getItemType());
                    input.setOrderNo(action.getOrderNo());
                    input.setPictureJson(action.getPictureJson());
                    input.setClassifyId(action.getClassifyId());
                    input.setClassifyName(action.getClassifyName());
                    String classifyName = action.getClassifyName();
                    if (!StringUtil.isNotEmpty(classifyName)) {
                        classifyName = "其他";
                    }
                    String riskDesc = action.getRiskDesc();
                    if (!StringUtil.isNotEmpty(riskDesc)) {
                        riskDesc = XJConstant.DEFAULT_RISKDESC;
                    }
                    JSONObject classifyJson;
                    if (appResponeMap.containsKey(classifyName)) {
                        classifyJson = appResponeMap.getJSONObject(classifyName);
                    } else {
                        classifyJson = new JSONObject();
                    }
                    JSONArray riskDescArr;
                    if (classifyJson.containsKey(riskDesc)) {
                        riskDescArr = classifyJson.getJSONArray(riskDesc);
                    } else {
                        riskDescArr = new JSONArray();
                    }
                    riskDescArr.add(action);
                    classifyJson.put(riskDesc, riskDescArr);
                    appResponeMap.put(classifyName, classifyJson);
                });
                pointCheckRespone.setAppCheckInput(appResponeMap);
            } else {
                return null;
            }
        }
        return pointCheckRespone;
    }


    @Override
    public AppPointCheckRespone queryPointPlanTaskDetailInVersion2New(Long planTaskId, Long pointId) {
        AppPointCheckRespone pointCheckRespone = new AppPointCheckRespone();
        Check check = checkDao.findByPlanTaskIdAndPointId(planTaskId, pointId);
        if (check != null) {
            pointCheckRespone = checkService.queryCheckPointDetailInVersion2New(check.getId());
        } else {
            PointCheckDetailBo planPointInfo = planTaskMapper.getPointPlanTaskInfo(planTaskId, pointId);

            if (planPointInfo != null) {
                pointCheckRespone.setPointId(pointId);
                pointCheckRespone.setPointName(planPointInfo.getPointName());
                pointCheckRespone.setPointNo(planPointInfo.getPointNo());
                pointCheckRespone.setPointStatus("0");
                pointCheckRespone.setPlanName(planPointInfo.getPlanName());
                List<PointCheckDetailBo> pointInputs = planTaskMapper.getPointInputByRouteIdAndPointId(planPointInfo.getRouteId(), planPointInfo.getPointId());

                JSONObject appResponeMap = new JSONObject();
                pointInputs.forEach(action -> {
                    AppCheckInputRespone input = new AppCheckInputRespone();
                    input.setInputName(action.getInputName());
                    input.setCheckInputId(action.getCheckInputId());
                    input.setDataJson(action.getDataJson());
                    input.setIsMultiline(action.getIsMultiline());
                    input.setIsMust(action.getIsMust());
                    input.setItemType(action.getItemType());
                    input.setOrderNo(action.getOrderNo());
                    input.setPictureJson(action.getPictureJson());
                    input.setClassifyId(action.getClassifyId());
                    input.setClassifyName(action.getClassifyName());
                    String classifyName = action.getClassifyName();
                    if (!StringUtil.isNotEmpty(classifyName)) {
                        classifyName = "其他";
                    }
                    String riskDesc = action.getRiskDesc();
                    if (!StringUtil.isNotEmpty(riskDesc)) {
                        riskDesc = XJConstant.DEFAULT_RISKDESC;
                    }
                    JSONObject classifyJson;
                    if (appResponeMap.containsKey(classifyName)) {
                        classifyJson = appResponeMap.getJSONObject(classifyName);
                    } else {
                        classifyJson = new JSONObject();
                    }
                    JSONArray riskDescArr;
                    if (classifyJson.containsKey(riskDesc)) {
                        riskDescArr = classifyJson.getJSONArray(riskDesc);
                    } else {
                        riskDescArr = new JSONArray();
                    }
                    riskDescArr.add(action);
                    classifyJson.put(riskDesc, riskDescArr);
                    appResponeMap.put(classifyName, classifyJson);
                });
                pointCheckRespone.setAppCheckInput(appResponeMap);
            } else {
                return null;
            }
        }
        return pointCheckRespone;
    }


    @Override
    public String getCumulativePlanCountByOrgCode(String loginOrgCode) {
        return planTaskMapper.getCumulativePlanCountByOrgCode(loginOrgCode);
    }

    @Override
    public List<LeavePlanTaskVo> queryLeavePlanTask(HashMap<String, Object> params) {
        return planTaskMapper.queryLeavePlanTask(params);
    }

    @Override
    public List<CodeOrderVo> queryCodeOrderVo(HashMap<String, Object> params) {
        return planTaskMapper.queryCodeOrderVo(params);
    }

    @Override
    public PlanTask selectPlanTaskStatus(Long id) {
        // TODO Auto-generated method stub
        if (iplanTaskDao.existsById(id)) {
            return iplanTaskDao.findById(id).get();
        }
        return null;
    }

    @Override
    public void initPlanStatusOrGenDate() {
        planMapper.initUpdatePlanStatus();
        planMapper.initUpdatePlanNextGenDate();
    }

    @Override
    public List<Map<String, Object>> queryPlanTaskTimeAxis(Long userId, Integer createDate) {
        HashMap<String, Object> params = new HashMap<>();
        params.put("userId", userId);
        String endTime = DateUtil.getShortCurrentDate();
        ;
        String beginTime = "";
        if (createDate != null && createDate == 7) {
            beginTime = DateUtil.getIntervalDateStr(new Date(), -7, "yyyy-MM-dd");
        } else if (createDate != null && createDate == 30) {
            beginTime = DateUtil.getIntervalDateStr(new Date(), -30, "yyyy-MM-dd");
        } else {
            beginTime = DateUtil.getShortCurrentDate();
        }

        params.put("beginTime", beginTime + " 00:00:00");
        params.put("endTime", endTime + " 23:59:59");
        List<Map<String, Object>> content = planTaskMapper.queryPlanTaskTimeAxis(params);
        if (!CollectionUtils.isEmpty(content)) {
            Set<String> userIds = Sets.newHashSet();
            content.forEach(e -> {

                String id = e.get("userId").toString();
                if (StringUtil.isNotEmpty(id)) {
                    userIds.add(id);
                }
            });
            List<AgencyUserModel> userModelList = remoteSecurityService.listUserByUserIds(amosRequestContext.getToken(), amosRequestContext.getProduct(), amosRequestContext.getAppKey(), Joiner.on(",").join(userIds));
            Map<String, String> userModelMap = userModelList.stream().collect(Collectors.toMap(AgencyUserModel::getUserId, AgencyUserModel::getRealName, (k1, k2) -> k2));

            content.forEach(e -> {
                StringBuffer userNames = new StringBuffer();
                List<String> userIds1 = Arrays.asList(e.get("userId").toString().split(","));
                for (String userId1 : userIds1) {
                    userNames.append(userModelMap.get(userId1)).append(",");
                }
                e.put("userName", userNames.substring(0, userNames.length() - 1));
                e.put("beginTime", DateUtil.formatDatrToStr((Date) e.get("beginTime"), DateUtil.LONG_PATTERN));
                e.put("endTime", DateUtil.formatDatrToStr((Date) e.get("endTime"), DateUtil.LONG_PATTERN));
            });
        }
        return content;
    }

    @Override
    public List<Map<String, Object>> queryTimeAxis(Long userId, Integer createDate) {
        HashMap<String, Object> params = new HashMap<>();
        params.put("userId", userId);
        String endTime = DateUtil.getShortCurrentDate();
        ;
        String beginTime = "";
        if (createDate != null && createDate == 7) {
            beginTime = DateUtil.getIntervalDateStr(new Date(), -7, "yyyy-MM-dd");
        } else if (createDate != null && createDate == 30) {
            beginTime = DateUtil.getIntervalDateStr(new Date(), -30, "yyyy-MM-dd");
        } else {
            beginTime = DateUtil.getShortCurrentDate();
        }

        params.put("beginTime", beginTime + " 00:00:00");
        params.put("endTime", endTime + " 23:59:59");
        String structListString = equipFeign.getStructureNameAll();
        JSONObject jsonObject = JSONObject.parseObject(structListString);
        JSONArray structList = jsonObject.getJSONArray("result");
        List<Map<String, Object>> result = new ArrayList<>();

        List<Map<String, Object>> content = planTaskMapper.queryTimeAxis(params);
        if (!CollectionUtils.isEmpty(content)) {
            Set<String> userIds = Sets.newHashSet();
            content.forEach(e -> {

                String id = e.get("userId").toString();
                if (StringUtil.isNotEmpty(id)) {
                    userIds.add(id);
                }
            });
            List<AgencyUserModel> userModelList = remoteSecurityService.listUserByUserIds(amosRequestContext.getToken(), amosRequestContext.getProduct(), amosRequestContext.getAppKey(), Joiner.on(",").join(userIds));
            Map<String, String> userModelMap = userModelList.stream().collect(Collectors.toMap(AgencyUserModel::getUserId, AgencyUserModel::getRealName, (k1, k2) -> k2));

            content.forEach(e -> {
                StringBuffer userNames = new StringBuffer();
                List<String> userIds1 = Arrays.asList(e.get("userId").toString().split(","));
                for (String userId1 : userIds1) {
                    userNames.append(userModelMap.get(userId1)).append(",");
                }
                HashMap<String, Object> map = new HashMap();
                map.put("userName", userNames.substring(0, userNames.length() - 1));
                map.put("beginTime", DateUtil.formatDatrToStr((Date) e.get("beginTime"), DateUtil.LONG_PATTERN));
                map.put("endTime", DateUtil.formatDatrToStr((Date) e.get("endTime"), DateUtil.LONG_PATTERN));
                map.put("leftName", "巡检点");
                map.put("titleName", userNames.substring(0, userNames.length() - 1) + "-" + e.get("name").toString() + "-" + e.get("STATUS").toString());
                String structName = "";
                if (!StringUtils.isEmpty(e.get("risk_source_id"))) {
                    for (int i = 0; i < structList.size(); i++) {
                        if (structList.getJSONObject(i).get("id").equals(e.get("risk_source_id"))) {
                            structName = structList.getJSONObject(i).get("name").toString();
                        }
                    }
                } else {
                    structName = "无";
                }

                if (!StringUtils.isEmpty(e.get("executorDate"))) {
                    map.put("firstPropsValue", structName + "-" + e.get("executorDate"));
                } else {
                    map.put("firstPropsValue", structName + "-无");
                }

                result.add(map);
            });
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> firePatrolStatics(String bizOrgCode) {
        return planTaskMapper.firePatrolStatics(bizOrgCode);
    }

    @Override
    public Page<HashMap<String, Object>> getPlanTaskPageList(PlanTaskPageParam param) {
        CommonPageable commonPageable = new CommonPageable(param.getPageNumber() - 1, param.getPageSize());
        if (param.getPageNumber() >= 1) {
            param.setPageNumber((param.getPageNumber() - 1) * param.getPageSize());
        }
        long total = planTaskMapper.countData(param);
        List<HashMap<String, Object>> content = planTaskMapper.planTaskPage(param);
        Page<HashMap<String, Object>> result = new PageImpl<>(content, commonPageable, total);
        return result;
    }

    @Override
    public Map<String, String> preview(String taskDetailId) {
        WordTemplateUtils instance = WordTemplateUtils.getInstance();
        Map<String, Object> map = getWordMap(taskDetailId);
        String urlString = "";
        File filepdf = null;
        try {
            filepdf = instance.getWordFileItem(map, (String) map.get("document_name"), WordTemplateEnum.firePatrolPlanTaskReport.getTemplateFile(), "pdf");
            filepdf.getAbsolutePath();
            MultipartFile multipartFile = new MyByteArrayMultipartFile("file", "file.pdf", "application/pdf", file2byte(filepdf));
            FeignClientResult<Map<String, String>> result = Systemctl.fileStorageClient.updateCommonFile(multipartFile);
            if (result != null) {
                Iterator<String> it = result.getResult().keySet().iterator();
                while (it.hasNext()) {
                    urlString = it.next();
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (filepdf != null) {
                filepdf.delete();
            }
        }
        HashMap<String, String> resultMap = new HashMap<>();
        resultMap.put("pdfUrl", urlString);
        return resultMap;
    }

    @Override
    public Map<String, Object> queryPatrolInfoList(String bizOrgCode, Date startDate, Date endDate) {
        Map<String, Object> map = new HashMap<>();
        map = planTaskMapper.queryPatrolInfoList(bizOrgCode, startDate, endDate);
        Map<String, Object> map1 = new HashMap<>();
        map1 = planTaskMapper.queryPatrolEquipInfo(bizOrgCode, startDate, endDate);
        map.put("equipment_count", map1.get("equipment_count"));
        map.put("checked_equipment_count", map1.get("checked_equipment_count"));
        map.put("unchecked_equipment_count", map1.get("unchecked_equipment_count"));
        return map;
    }


    @Override
    public void download(HttpServletRequest request, HttpServletResponse response, String taskDetailId) throws UnsupportedEncodingException {
        WordTemplateUtils instance = WordTemplateUtils.getInstance();
        Map<String, Object> map = getWordMap(taskDetailId);
        try {
            instance.exportMillCertificateWord(request, response, map, (String) map.get("document_name"), WordTemplateEnum.firePatrolPlanTaskReport.getTemplateFile());
        } catch (IOException e) {
            throw new BadRequest("下载巡查任务报表失败");
        }
    }

    private Map<String, Object> getWordMap(String taskDetailId) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotEmpty(taskDetailId)) {
            Map<String, Object> infoMap = planTaskMapper.getPlanTaskBasicInfo(taskDetailId);
            SimpleDateFormat dateStat = new SimpleDateFormat("yyyy年MM月dd日 HH:mm:ss");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            LocalDateTime beginTime = (LocalDateTime) infoMap.get("beginTime");
            LocalDateTime endTime = (LocalDateTime) infoMap.get("endTime");
            String begin = dateStat.format(Date.from(beginTime.atZone(ZoneId.systemDefault()).toInstant()));
            String end = dateStat.format(Date.from(endTime.atZone(ZoneId.systemDefault()).toInstant()));
            // 设置文档文件名
            map.put("document_name", infoMap.get("taskName") + " " + begin + "-" + end + "消防设施巡查报告");
            // 换流站名称
            map.put("station_name", infoMap.get("stationName"));
            map.put("station_check_time", begin + " - " + end);
            map.put("document_create_date", dateStat.format(new Date()));
            map.put("task_name", infoMap.get("taskName"));
            map.put("begin_time", begin);
            map.put("end_time", end);
            String timestr = DateUtils.secondsToTimeStr(Integer.parseInt(infoMap.get("difSecond").toString()));
            map.put("task_total_time", timestr);
            map.put("task_status", infoMap.get("taskStatus"));
            Map<String, Object> executeInfoMap = planTaskMapper.getPlanTaskExecuteInfo(taskDetailId);
            // 执行情况参数
            int total_count = Integer.valueOf(String.valueOf(executeInfoMap.get("should_check_equip_num")));
            int real_count = Integer.valueOf(String.valueOf(executeInfoMap.get("real_check_equip_num")));
            map.put("should_check_equip_num", total_count);
            map.put("real_check_equip_num", real_count);
            double complete_task_percent;
            if (0 == total_count) {
                complete_task_percent = 0.0;
                log.error("-----------------------------应巡查总数是 0，请检查！-----------------------------");
            } else {
                complete_task_percent = (Double.valueOf(real_count) / Double.valueOf(total_count)) * 100;
            }
            map.put("check_equip_rate", complete_task_percent);
            int qualified_count = Integer.valueOf(String.valueOf(executeInfoMap.get("qualified_equip_num")));
            map.put("qualified_equip_num", qualified_count);
            map.put("not_qualified_equip_num", executeInfoMap.get("not_qualified_equip_num"));
            double qualified_task_percent;
            if (0 == total_count) {
                qualified_task_percent = 0.0;
                log.error("-----------------------------应巡查总数是 0，请检查！-----------------------------");
            } else {
                qualified_task_percent = (Double.valueOf(qualified_count) / Double.valueOf(total_count)) * 100;
            }
            map.put("qualified_equip_rate", qualified_task_percent);
            int missed_count = Integer.valueOf(String.valueOf(executeInfoMap.get("missed_equip_num")));
            map.put("missed_check_equip_num", missed_count);
            double miss_task_percent;
            if (0 == total_count) {
                miss_task_percent = 0.0;
                log.error("-----------------------------应巡查总数是 0，请检查！-----------------------------");
            } else {
                miss_task_percent = (Double.valueOf(missed_count) / Double.valueOf(total_count)) * 100;
            }
            map.put("missed_equip_rate", miss_task_percent);
            List<String> codes = planTaskMapper.getDefinitionObjCode(taskDetailId);
            String checkId = planTaskMapper.getCheckIdByDetailId(taskDetailId);
            FeignClientResult responseModel = new FeignClientResult();
            List result = new ArrayList();
            try {
                responseModel = idxFeign.queryDefectByCodes(codes, checkId);
                result = (List) responseModel.getResult();
            } catch (Exception e) {
                e.printStackTrace();
            }
            List<DefectVo> res = new ArrayList();
            if (result != null && 0 < result.size()) {
                for (Object object : result) {
                    DefectVo vo = JSON.parseObject(JSON.toJSONString(object), DefectVo.class);
                    res.add(vo);
                }
            }
            map.put("defect_report_num", res.size());
            // 上报缺陷
            List<Map<String, Object>> defects = new ArrayList<>();
            if (!CollectionUtils.isEmpty(res)) {
                res.forEach(x -> {
                    Map defectMap = new LinkedHashMap();
                    defectMap.put("defect_num", x.getDefectNum());
                    defectMap.put("defect_level", DefectLevelEnum.getByKey(x.getDefectLevel()).getValue());
                    defectMap.put("defect_equip_name", x.getDefectEquipmentName());
                    StringBuffer sb = new StringBuffer();
                    if (!StringUtils.isEmpty(x.getDefectEquipmentIds())) {
                        if (x.getDefectEquipmentIds().contains(",")) {
                            String[] ids = x.getDefectEquipmentIds().split(",");
                            List<String> equipIds = Arrays.asList(ids);
                            if (0 < equipIds.size()) {
                                for (String s : equipIds) {
                                    sb.append(planTaskMapper.getDefectEquipInfo(x.getDefectEquipmentIds()) == null ? "" : planTaskMapper.getDefectEquipInfo(x.getDefectEquipmentIds()).get("equipLocation")).append(",");
                                }
                            }
                        } else {
                            sb.append(planTaskMapper.getDefectEquipInfo(x.getDefectEquipmentIds()) == null ? "" : planTaskMapper.getDefectEquipInfo(x.getDefectEquipmentIds()).get("equipLocation"));
                        }
                    }
                    defectMap.put("defect_equip_position", sb == null ? "" : sb);
                    defectMap.put("defect_equip_describe", x.getDefectDescribe());
                    defectMap.put("defect_report_time", sdf.format(x.getAddTime()));
                    defectMap.put("defect_discovery_name", x.getDefectDiscover());
                    defects.add(defectMap);
                });
            }
            map.put("defect_list", defects);
            // 漏检设备
            List<Map<String, Object>> missedMaps = planTaskMapper.getCheckMissedEquipInfo(taskDetailId);
            List<Map<String, Object>> missedList = new ArrayList<>();
            if (!CollectionUtils.isEmpty(missedMaps)) {
                for (int i = 0; i < missedMaps.size(); i++) {
                    Map defectMap = new LinkedHashMap();
                    defectMap.put("missed_equip_index", i + 1);
                    defectMap.put("missed_equip_name", missedMaps.get(i).get("equipName"));
                    defectMap.put("missed_equip_position", missedMaps.get(i).get("equipPosition"));
                    defectMap.put("missed_equip_result", missedMaps.get(i).get("result"));
                    defectMap.put("missed_equip_remark", missedMaps.get(i).get("remark"));
                    missedList.add(defectMap);
                }
            }
            map.put("missed_equip_list", missedList);
            // 合格设备
            List<Map<String, Object>> qualifiedMaps = planTaskMapper.getCheckQualifiedEquipInfo(taskDetailId);
            List<Map<String, Object>> qualifiedEquipLists = new ArrayList<>();
            if (!CollectionUtils.isEmpty(qualifiedMaps)) {
                for (int i = 0; i < qualifiedMaps.size(); i++) {
                    Map qualifiedMap = new LinkedHashMap();
                    qualifiedMap.put("qualified_equip_index", i + 1);
                    qualifiedMap.put("qualified_equip_name", qualifiedMaps.get(i).get("equipName"));
                    qualifiedMap.put("qualified_equip_position", qualifiedMaps.get(i).get("equipPosition"));
                    qualifiedMap.put("qualified_equip_check_item", qualifiedMaps.get(i).get("checkItem"));
                    qualifiedMap.put("qualified_equip_result", qualifiedMaps.get(i).get("result"));
                    LocalDateTime checkTime = (LocalDateTime) qualifiedMaps.get(i).get("checkDate");
                    String qualifiedTime = sdf.format(Date.from(checkTime.atZone(ZoneId.systemDefault()).toInstant()));
                    qualifiedMap.put("qualified_equip_check_time", qualifiedTime);
                    qualifiedMap.put("qualified_equip_check_user", qualifiedMaps.get(i).get("checkUserName"));
                    qualifiedEquipLists.add(qualifiedMap);
                }
            }
            map.put("qualified_equip_list", qualifiedEquipLists);
            // 不合格设备
            List<Map<String, Object>> notQualifiedMaps = planTaskMapper.getCheckNotQualifiedEquipInfo(taskDetailId);
            List<Map<String, Object>> notQualifiedEquipLists = new ArrayList<>();
            if (!CollectionUtils.isEmpty(notQualifiedMaps)) {
                for (int i = 0; i < notQualifiedMaps.size(); i++) {
                    Map notQualifiedMap = new LinkedHashMap();
                    notQualifiedMap.put("not_qualified_equip_index", i + 1);
                    notQualifiedMap.put("not_qualified_equip_name", notQualifiedMaps.get(i).get("equipName"));
                    notQualifiedMap.put("not_qualified_equip_position", notQualifiedMaps.get(i).get("equipPosition"));
                    notQualifiedMap.put("not_qualified_equip_check_item", notQualifiedMaps.get(i).get("checkItem"));
                    notQualifiedMap.put("not_qualified_equip_result", notQualifiedMaps.get(i).get("result"));
                    LocalDateTime notQualifiedCheckTime = (LocalDateTime) notQualifiedMaps.get(i).get("checkDate");
                    String notQualifiedTime = sdf.format(Date.from(notQualifiedCheckTime.atZone(ZoneId.systemDefault()).toInstant()));
                    notQualifiedMap.put("not_qualified_equip_check_time", notQualifiedTime);
                    notQualifiedMap.put("not_qualified_equip_check_user", notQualifiedMaps.get(i).get("checkUserName"));
                    if (0 < res.size()) {
                        for (DefectVo vo : res) {
                            if (StringUtil.isNotEmpty(vo.getDefectEquipmentCode()) && String.valueOf(notQualifiedMaps.get(i).get("objCode")).equals(vo.getDefectEquipmentCode())) {
                                notQualifiedMap.put("not_qualified_equip_defect_num", vo.getDefectNum());
                                break;
                            }
                        }
                    }
                    notQualifiedEquipLists.add(notQualifiedMap);
                }
            }
            map.put("not_qualified_equip_list", notQualifiedEquipLists);
        }
        return map;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
//    @ShardingSphereTransactionType(TransactionType.XA)
    public void backPatrolInfo() {
        long sTime = System.currentTimeMillis();
        backChcek();
        backChcekInput();
        backPlanTask();
        backChcekShot();
        backPlanTaskDetail();
        long eTime = System.currentTimeMillis();
        System.out.printf("执行时长：%d 毫秒.", (sTime - eTime));
    }


    @Transactional(rollbackFor = Exception.class)
    public void backPlanTask() {
        log.info("开始归档p_plan_task表========");
        List<PlanTask> list = planTaskMapper.findPlanTask();
        List<PlanTaskHistory> collect = list.stream().map(e -> {
            PlanTaskHistory d = new PlanTaskHistory();
            BeanUtils.copyProperties(e, d);
            return d;
        }).collect(Collectors.toList());

        repositoryTs.batchSave(collect);
        log.info("归档p_plan_task表完成========");
    }

    @Transactional(rollbackFor = Exception.class)
    public void backPlanTaskDetail() {
        log.info("开始归档p_plan_task_detail表========");
        List<PlanTaskDetail> list = planTaskMapper.findPlanTaskDetail();
        List<PlanTaskDetailHistory> collect = list.stream().map(e -> {
            PlanTaskDetailHistory d = new PlanTaskDetailHistory();
            BeanUtils.copyProperties(e, d);
            return d;
        }).collect(Collectors.toList());
        repositoryTs.batchSave(collect);
        log.info("归档p_plan_task_detail表完成========");
    }

    @Transactional(rollbackFor = Exception.class)
    public void backChcek() {
        log.info("开始归档p_check表========");
        List<Check> list = planTaskMapper.findCheck();
        List<CheckHistory> collect = list.stream().map(e -> {
            CheckHistory d = new CheckHistory();
            BeanUtils.copyProperties(e, d);
            return d;
        }).collect(Collectors.toList());
        repositoryTs.batchSave(collect);
        log.info("归档p_check表完成========");
    }

    @Transactional(rollbackFor = Exception.class)
    public void backChcekInput() {
        log.info("开始归档p_check_input表========");
        List<CheckInput> list = planTaskMapper.findCheckInput();
        List<CheckInputHistory> collect = list.stream().map(e -> {
            CheckInputHistory d = new CheckInputHistory();
            BeanUtils.copyProperties(e, d);
            return d;
        }).collect(Collectors.toList());
        repositoryTs.batchSave(collect);
        log.info("归档p_check_input表完成========");
    }

    @Transactional(rollbackFor = Exception.class)
    public void backChcekShot() {
        log.info("开始归档p_check_shot表========");
        List<CheckShot> list = planTaskMapper.findCheckShot();
        List<CheckShotHistory> collect = list.stream().map(e -> {
            CheckShotHistory d = new CheckShotHistory();
            BeanUtils.copyProperties(e, d);
            return d;
        }).collect(Collectors.toList());

        repositoryTs.batchSave(collect);
        log.info("归档p_check_shot表完成========");
    }

    @Override
    public List<Map<String, Object>> getStatics(String companyCode, String bizOrgCode) {
        if (StringUtils.isEmpty(bizOrgCode) && StringUtil.isNotEmpty(companyCode)) {
            bizOrgCode = planTaskMapper.queryByCompanyCode(companyCode);
        }
        List<Map<String, Object>> statics = planTaskMapper.getStatics(bizOrgCode);
        int xcdw = 0;
        int hgdw = 0;
        int lcdw = 0;
        int zxcdw = 0;
        for (Map<String, Object> map : statics
        ) {
            if (map.get("code").equals("xfxcjrljxcdw")) {
                xcdw = Integer.parseInt(map.get("value").toString());
            }
            if (map.get("code").equals("xfxchg")) {
                hgdw = Integer.parseInt(map.get("value").toString());
            }
            if (map.get("code").equals("xfxcjrlcdw")) {
                lcdw = Integer.parseInt(map.get("value").toString());
            }
            if (map.get("code").equals("xfxcjrzxcdw")) {
                zxcdw = Integer.parseInt(map.get("value").toString());
            }
        }
        if (xcdw == 0) {
            for (Map<String, Object> map : statics
            ) {
                if (map.get("code").equals("xfxchgzb")) {
                    map.put("value", "0");
                }
            }
        } else {
            for (Map<String, Object> map : statics
            ) {
                if (map.get("code").equals("xfxchgzb")) {
                    map.put("value", String.format("%.2f", (((double) hgdw / (double) xcdw)) * 100));
                }
            }
        }
        if (zxcdw == 0) {
            for (Map<String, Object> map : statics
            ) {
                if (map.get("code").equals("xfxclcl")) {
                    map.put("value", "0");
                }
            }
        } else {
            for (Map<String, Object> map : statics
            ) {
                if (map.get("code").equals("xfxclcl")) {
                    map.put("value", String.format("%.2f", (((double) lcdw / (double) zxcdw)) * 100));
                }
            }
        }

        return statics;
    }

    public static byte[] file2byte(File file) {
        try {
            FileInputStream in = new FileInputStream(file);
            //当文件没有结束时，每次读取一个字节显示
            byte[] data = new byte[in.available()];
            in.read(data);
            in.close();
            return data;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }


    private void createNeedTime(String table, String db, String create) {
        DataSource dataSource = this.dataSource;
        String sql = "SHOW CREATE TABLE " + table;
        String existSql = "select * from information_schema.tables where table_name ='" + table + "'; ";
        doCreate(dataSource, sql, existSql, create, db, table);
    }

    private void doCreate(DataSource dataSource, String sql, String existSql, String create, String db, String table) {
        String msg = " create table: " + create + "  origin table: " + table + "  db: " + db;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = dataSource.getConnection().getMetaData().getConnection();
            stmt = conn.createStatement();
            ResultSet resultSet = stmt.executeQuery(existSql);
            Assert.isTrue(resultSet.next(), msg + "初始化表不存在");

            ResultSet resTable = stmt.executeQuery(sql);
            Assert.isTrue(resTable.next(), msg + "初始化表不存在");
            String existTableName = resTable.getString(1);
            String createSqlOrigin = resTable.getString(2);
            // log.info(existTableName, createSqlOrigin);

            String existSqlNew = org.apache.commons.lang3.StringUtils.replaceOnce(existSql, existTableName, create);
            ResultSet executeQuery = stmt.executeQuery(existSqlNew);
            if (executeQuery.next()) {
                log.info("table exist :" + msg);
            } else {
                createSqlOrigin = createSqlOrigin.substring(0, createSqlOrigin.indexOf(";"));
                String creatsql = org.apache.commons.lang3.StringUtils.replace(createSqlOrigin, existTableName, create).replaceFirst(create, DB + create).replace("bigint(64)", "int8").replace("smallint(16)", "int2");
                if (0 == stmt.executeUpdate(creatsql)) {
                    log.info(msg + "success ！");

                } else {
                    log.error(msg + "fail ！");
                }
            }
        } catch (Exception e) {
            log.error("create  table fail  error : {} ", e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                    log.error("SQLException", e);
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                } catch (SQLException e) {
                    log.error("SQLException", e);
                }
            }
        }
    }
}
