package com.yeejoin.amos.boot.module.tzs.flc.api.dto;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.amos.boot.biz.common.constants.CommonConstant;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.common.api.dto.AttachmentDto;
import com.yeejoin.amos.boot.module.common.api.entity.DynamicFormInstance;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 企业人员信息表
 *
 * @author system_generator
 * @date 2021-11-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="UnitPersonInfoDto", description="企业人员信息表")
public class UnitPersonInfoDto extends BaseDto {

   private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "人员名称")
    private String bizOrgName;

    @ApiModelProperty(value = "人员编码")
    private String bizOrgCode;

    @ApiModelProperty(value = "amos中公司/部门ID")
    private String amosOrgId;

    @ApiModelProperty(value = "amos中公司/部门编码")
    private String amosOrgCode;

    @ApiModelProperty(value = "机构类型（部门：DEPARTMENT，单位：COMPANY，人员：PERSON）")
    private String bizOrgType = CommonConstant.BIZ_ORG_TYPE_PERSON;

    @ApiModelProperty(value = "所在单位")
    private String parentId;

    @ApiModelProperty(value = "所在单位名称")
    private String parentName;

    @ApiModelProperty(value = "用户名")
    private String org_expand_attr1;

    @ApiModelProperty(value = "用户密码")
    private String org_expand_attr2;

    @ApiModelProperty(value = "所属组织id")
    private String org_expand_attr3;

    @ApiModelProperty(value = "管理应用")
    private String org_expand_attr4;

    @ApiModelProperty(value = "角色")
    private String org_expand_attr5;

   @ApiModelProperty(value = "更新人")
   @TableField(fill= FieldFill.INSERT_UPDATE)
   private String recUserName;

   @ApiModelProperty(value = "动态表单值")
   private List<DynamicFormInstance> dynamicFormValue;

   @ApiModelProperty(value = "资质信息")
   private PersonQualityDto personQualityDto;

   @ApiModelProperty(value = "培训教育信息")
   private PersonEducationDto personEducationDto;

    @ApiModelProperty(value = "证照图片")
    private List<AttachmentDto> licencePic;

    @ApiModelProperty(value = "头像")
    private List<AttachmentDto> headshot;


}
