package com.yeejoin.equipmanage.common.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 车量里程表
 *
 * @author duanwei
 * @date 2023-02-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value="WlCarMileage对象", description="车量里程表")
public class WlCarMileageDto extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "iot编码")
    private String iotCode;

    @ApiModelProperty(value = "里程km")
    private Double travel;

    @ApiModelProperty(value = "日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date date;

    @ApiModelProperty(value = "开始时间")
    private String startTime;

    @ApiModelProperty(value = "结束时间")
    private String endTime;

    @ApiModelProperty(value = "耗时")
    private Long takeTime;
    
    @ApiModelProperty(value = "开始地址")
    private String startName;

    @ApiModelProperty(value = "结束地址")
    private String endName;
    
    @ApiModelProperty(value = "开始精度")
    private Double startLongitude;

    @ApiModelProperty(value = "开始纬度")
    private Double startLatitude;
    
    @ApiModelProperty(value = "结束精度")
    private Double endLongitude;

    @ApiModelProperty(value = "结束纬度")
    private Double endLatitude;
    
    @ApiModelProperty(value = "开始速度km/h")
    private Integer startSpeed;

    @ApiModelProperty(value = "结束速度km/h")
    private Integer endSpeed;

    @TableField(exist = false)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date filterDate;

    @TableField(exist = false)
    private String name;

    @TableField(exist = false)
    private String time;

    @TableField(exist = false)
    private long carId;
    
    @TableField(exist = false)
    private String startFullTime;

    @TableField(exist = false)
    private String endFullTime;
}
