package com.yeejoin.equipmanage.common.entity.vo;

import com.yeejoin.equipmanage.common.entity.ManufacturerInfo;
import com.yeejoin.equipmanage.common.entity.UploadFile;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author ZeHua Li
 * @date 2020/9/15 14:10
 * @since v2.0
 * app设备详情
 */
@Data
@ApiModel(value = "EquipmentAppVO实体", description = "app查询装备详情实体类")
public class EquipmentAppVO {
    @ApiModelProperty(value = "设备基础信息")
    private EquipmentBaseAppVO equipmentBase;
    @ApiModelProperty(value = "性能指标")
    private List<EquipmentIndexVO> equipmentIndexVOS;
    @ApiModelProperty(value = "文件")
    private List<UploadFile> excel;
    @ApiModelProperty(value = "供应商信息")
    private ManufacturerInfo manufacturerInfo;


}
