package com.yeejoin.equipmanage.fegin;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.typroject.tyboot.core.restful.utils.ResponseModel;


/**
 * @author DELL
 */
@FeignClient(name = "${idx.feign.name}", path = "idx", configuration = {FeignConfiguration.class})
public interface IdxFeign {

    /***
     * <pre>
     * @Description: 根据告警id查询缺陷治理情况
     * </pre>
     *
     * @MethodName:
     * @Param:
     * @Return: null
     * @Throws
     * @Author keyong
     * @Date 2022/9/27 17:46
     */
    @RequestMapping(value = "/defect/alarm/{alarmLogId}", method = RequestMethod.GET)
    ResponseModel<JSONObject> queryDefectByBatchId(@PathVariable(value = "alarmLogId") String alarmLogId);

}
