package com.yeejoin.amos.patrol.business.service.intfc;

import com.yeejoin.amos.patrol.business.entity.mybatis.CheckChkExListBo;
import com.yeejoin.amos.patrol.business.param.CheckPtListPageParam;
import com.yeejoin.amos.patrol.business.param.PlanTaskPageParam;
import com.yeejoin.amos.patrol.business.vo.CodeOrderVo;
import com.yeejoin.amos.patrol.business.vo.LeavePlanTaskVo;
import com.yeejoin.amos.patrol.business.vo.PlanTaskVo;
import com.yeejoin.amos.patrol.core.common.request.CommonPageable;
import com.yeejoin.amos.patrol.core.common.response.AppPointCheckRespone;
import com.yeejoin.amos.patrol.dao.entity.PlanTask;
import org.springframework.data.domain.Page;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface IPlanTaskService {


	/**
	 * 计划执行查询
	 */
	Page<HashMap<String, Object>> getPlanTaskInfo(String toke,String product,String appKey,PlanTaskPageParam params);



	/**
	 * 计划执行查询新
	 */
	Page<HashMap<String, Object>> getPlanTaskInfoNew(PlanTaskPageParam params);



	/**
	 * 计划执行重做
	 */
	void reGenPlanTask(HashMap<String, Object> param) throws ParseException;

	/**
	 * 计划执行重做
	 */
	void reGenPlanTaskNew(HashMap<String, Object> param) throws ParseException;

	/**
	 * 计划执行删除
	 */
	void planTaskDet(String[] strArry);

	/**
	 * 执行计划导出
	 */
	List<PlanTaskVo> planTaskReport(String toke,String product,String appKey,PlanTaskPageParam params);


	List<PlanTaskVo> planTaskReportNew(PlanTaskPageParam params);

	/**
	 * 自动任务执行
	 * @param runDate
	 */
	void taskExecution(String runDate);

	/**
	 * 定时任务发送消息执行中的消息
	 *
	 * @param runDate
	 */
	void taskMessage(String runDate);

	/**
	 * 根据路线id获取关联的所有计划任务
	 *
	 * @param routeId
	 * @return
	 */
	List<PlanTask> getPlanTaskByRouteId(Long routeId);

	/**
	 * 停用计划任务
	 *
	 * @param routeIds
	 */
	void disablePlanTask(Long[] routeIds);

	/**
	 * app 根据条件查询用户权限内所有当前巡检计划任务
	 * @param params
	 * @return
	 */
	List getPlanTaskInfo(HashMap<String, Object> params);

	/**
	 * 根据计划任务ID查询任务想起
	 * @param id
	 * @return
	 */
	Map findPlanTaskByTaskIdAndPointId(long id, long pointId);

	/**
	 *	 天剑查询假话任务信息
	 * @param params
	 * @return
	 */
	Page<Map<String, Object>> getPlanTasks(String toke,String product,String appKey,HashMap<String, Object> params);

	/**
	 *  根据计划任务Id获取计划任务信息
	 * @param planTaskId
	 * @return
	 */
	Map queryPlanTaskById(Long planTaskId);

	/**
	 * 	根据计划ID获取所有的 任务计划巡检点
	 * @param planTaskId
	 * @return
	 */
	List getPlanTaskPoints(Long planTaskId);

	/**
	 * 	获取用户当前所有有的计划任务
	 * @param userId
	 * @return
	 */
	int getCurrentPlanTaskCount(String userId);
    /**
     * 今日执行情况
     * @param params
     * @return
     */
	Page<CheckChkExListBo> getChkExList(String toke,String product,String appKey,CheckPtListPageParam params);
	HashMap<String, Object> getChkExListNew(String orgCode, CommonPageable commonPageable);
	/**
	 * 根据id获取执行计划
	 * @param ids
	 * @return
	 */
	List<PlanTaskVo> getPlanTaskListByIds(String toke,String product,String appKey,Long[] ids);
	List<PlanTaskVo> getPlanTaskListByIdsNew(Long[] ids);
	/**
	 * 根据任务id点id 获取点详情
	 * @param planTaskId
	 * @param pointId
	 * @return
	 */
	AppPointCheckRespone queryPointPlanTaskDetail(String toke,String product,String appKey,Long planTaskId,Long pointId);

	AppPointCheckRespone queryPointPlanTaskDetailInVersion2(String toke,String product,String appKey,Long planTaskId,Long pointId);


	AppPointCheckRespone queryPointPlanTaskDetailInVersion2New(Long planTaskId,Long pointId);


	Map<String, Object> getPlanTaskStatisticsForApp(HashMap<String, Object> params);

	/**
	 * 获取公司计划累计情况
	 * @param loginOrgCode
	 * @return
	 */
	String getCumulativePlanCountByOrgCode(String loginOrgCode);

	List<LeavePlanTaskVo> queryLeavePlanTask(HashMap<String, Object> params);


	List<CodeOrderVo> queryCodeOrderVo(HashMap<String, Object> params);

	PlanTask selectPlanTaskStatus(Long id);

	public void reformStatisticsPlanTask(String strBginDate, String strEndDate, String userId, String orgCode) throws ParseException;

	void initPlanStatusOrGenDate();

	List<Map<String,Object>> queryPlanTaskTimeAxis(Long userId,Integer createDate);

	List<Map<String,Object>> queryTimeAxis(Long userId,Integer createDate);

	/**
	 * 消防巡检信息统计
	 * @param bizOrgCode 业务公司编码
	 * @return 消防巡检信息统计
	 */
	List<Map<String,Object>> firePatrolStatics(String bizOrgCode);

	List<Map<String,Object>> getStatics(String companyCode);

	/**
	 * 计划执行查询
	 */
	Page<HashMap<String, Object>> getPlanTaskPageList(PlanTaskPageParam params);

	Map<String, String> preview(String taskDetailId);

	void download(HttpServletRequest request, HttpServletResponse response, String taskDetailId) throws UnsupportedEncodingException;
}
