package com.yeejoin.amos.patrol.business.feign;

import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

// 机场服务
@FeignClient(name = "${jcs.fegin.name}", path = "jcs", configuration = FeignConfiguration.class)
public interface JcsFeignClient {

    /**
     * 根据机场人员ids获取amos平台人员列表
     *
     * @param orgUserId 机场单位人员ids
     * @return AgencyUserModel 平台人员信息列表
     **/
    @RequestMapping(value = "/org-usr/amos/list/{orgUserId}", method = RequestMethod.GET)
    ResponseModel<List<AgencyUserModel>> getAmosUserByUserId(@PathVariable String orgUserId);

    /**
     * 根据机场单位id获取单位下人员列表
     *
     * @param companyId 机场单位id
     * @return Object 单位下人员列表
     **/
    @RequestMapping(value = "/org-usr/{companyId}/person/list", method = RequestMethod.GET)
    ResponseModel<List<Map<String, Object>>> getPersonListByCompanyId(@PathVariable String companyId);
}

