package com.yeejoin.amos.api.householdapi.face.service.impl;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.api.householdapi.Utils.KsolarRequestUtil;
import com.yeejoin.amos.api.householdapi.constant.GoLangConstant;
import com.yeejoin.amos.api.householdapi.constant.KSolarConstant;
import com.yeejoin.amos.api.householdapi.face.dto.AlarmDto;
import com.yeejoin.amos.api.householdapi.face.dto.CollectorDetailDto;
import com.yeejoin.amos.api.householdapi.face.dto.KsolarAlarmDto;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpCollector;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpInverter;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpInverterElectricity;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpStation;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.*;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.KsolarStationCollectList;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpCollectorMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpInverterElectricityMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpInverterMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpStationMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.tdengine.*;
import com.yeejoin.amos.api.householdapi.face.service.KSolarDataAcquisitionService;
import com.yeejoin.amos.openapi.enums.PVProducerInfoEnum;
import fastjson.JSON;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * @author DELL
 */
@Service
public class KsolarDataAcquisitionServiceImpl implements KSolarDataAcquisitionService {


    @Autowired
    KsolarRequestUtil kSolarRequestUtil;

    @Autowired
    KsolarStationMapper kSolarStationMapper;

    @Autowired
    private JpStationMapper jpStationMapper;

    @Autowired
    private HYGFJPStationPowerHistoryMapper hygfjpStationPowerHistoryMapper;

    @Autowired
    private HYGFJPInverterHistoryMapper hygfjpInverterHistoryMapper;

    @Autowired
    private HYGFJPCollectorHistoryMapper hygfjpCollectorHistoryMapper;

    @Autowired
    private HYGFJPInverterWarnMapper hygfjpInverterWarnMapper;

    @Autowired
    private HYGFJPInverterElecHistoryMapper hygfjpInverterElecHistoryMapper;

    @Autowired
    private HYGFJPDayPowerMapper hygfjpDayPowerMapper;

    @Autowired
    private KsolarStationDetailsMapper ksolarStationDetailsMapper;

    @Autowired
    private KsolarStationEarnMapper ksolarStationEarnMapper;

    @Autowired
    private KsolarStationCollectListMapper ksolarStationCollectListMapper;

    @Autowired
    private JpCollectorMapper jpCollectorMapper;

    @Autowired
    private JpInverterMapper jpInverterMapper;
    //监盘逆变器电量mapper
    @Autowired
    private JpInverterElectricityMapper jpInverterElectricityMapper;
    @Autowired
    private TdHYGFInverterDayGenerateMapper tdHYGFInverterDayGenerateMapper;
    @Autowired
    private TdHYGFInverterMonthGenerateMapper tdHYGFInverterMonthGenerateMapper;
    @Autowired
    private TdHYGFInverterYearGenerateMapper tdHYGFInverterYearGenerateMapper;
    @Autowired
    private TdHYGFStationDayGenerateMapper tdHYGFStationDayGenerateMapper;
    @Autowired
    private TdHYGFStationMonthGenerateMapper tdHYGFStationMonthGenerateMapper;
    @Autowired
    private TdHYGFStationYearGenerateMapper tdHYGFStationYearGenerateMapper;
    @Autowired
    private TdHYGFInverterTotalGenerateMapper tdHYGFInverterTotalGenerateMapper;
    @Autowired
    TdJpStationMapper tdJpStationMapper;
    
    @Scheduled(cron = "${dataRequstScheduled.keshida}")
    @Override
    public void stationList() {
        HashMap<String, Object> requestInfo = new HashMap<>();
        String requestParaminfo = JSON.toJSONString(requestInfo);
        List<KsolarStationList> kSolarStationListList = kSolarRequestUtil.getResPonse(
                KSolarConstant.stationListUrl,
                KSolarConstant.requestGET,
                requestParaminfo,
                KSolarConstant.resovle_rows,
                KsolarStationList.class);
        for (KsolarStationList kSolarStation : kSolarStationListList) {
            kSolarStation.setCreatedTime(System.currentTimeMillis());
            kSolarStationMapper.insert(kSolarStation);
        }
    }

    @Scheduled(cron = "${dataRequstScheduled.keshida}")
    @Override
    public void stationDetail() {
        List<String> stationIds = kSolarStationMapper.getStationIds();
        String today = DateUtil.today();
        String hour = new Date().getHours() + ":00";

        for (String stationId : stationIds) {
            LambdaQueryWrapper<KsolarStationList> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(KsolarStationList::getStationId, stationId);
            wrapper.orderByDesc(KsolarStationList::getCreatedTime);
            List<KsolarStationList> ksolarStationLists = kSolarStationMapper.selectList(wrapper);
            if (!CollectionUtils.isEmpty(ksolarStationLists)) {
                KsolarStationList ksolarStation = ksolarStationLists.get(0);
                try {
                    TimeUnit.SECONDS.sleep(1);
                } catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                HashMap<String, Object> requestInfo = new HashMap<>(1);
                String requestParaminfo = JSON.toJSONString(requestInfo);
                String url = KSolarConstant.stationInfoByIdUrl + "?stationId=" + ksolarStation.getStationId();
                // 获取电站详情
                List<KsolarStationDetails> ksolarStationDetailsList = kSolarRequestUtil.getResPonse(
                        url,
                        KSolarConstant.requestPOST,
                        requestParaminfo,
                        KSolarConstant.resovle_data,
                        KsolarStationDetails.class);
                // 获取单个电站的发电量和收益
                KsolarStationEarn stationEarn = getStationEarn(ksolarStation.getStationId());

                // 获取单个电站月收益
                Map<String, Double> monthEarn = getStationMonthEarn(ksolarStation.getStationId(), "month");

                // 获取单个电站年收益
                Map<String, Double> yearEarn = getStationMonthEarn(ksolarStation.getStationId(), "year");

                for (KsolarStationDetails ksolarStationDetail : ksolarStationDetailsList) {

                    ksolarStationDetail.setCreatedTime(System.currentTimeMillis());
                    JpStation jpStation = jpStationMapper.selectOne(new QueryWrapper<JpStation>().
                            eq("third_code", PVProducerInfoEnum.KSOLAR.getCode()).
                            eq("third_station_id", ksolarStation.getStationId()));
                    // 给户用光伏存储的数据赋值
                    if (ObjectUtils.isEmpty(jpStation)) {
                        jpStation = new JpStation();
                    }
                    jpStation.setThirdStationId(ksolarStation.getStationId());
                    jpStation.setCapacity(ksolarStationDetail.getInstallCapacity());
                    jpStation.setName(ksolarStationDetail.getStationName());
                    jpStation.setPrice(ksolarStationDetail.getElecPrice());
                    jpStation.setAddress(ksolarStationDetail.getStationAddressDetail());
                    jpStation.setLongitude(ksolarStationDetail.getLongitude());
                    jpStation.setOnGridType("自发自用");//客户确认
                    jpStation.setRatedPower(4360.4);//客户确认
                    jpStation.setLatitude(ksolarStationDetail.getLatitude());
                    jpStation.setThirdCode(PVProducerInfoEnum.KSOLAR.getCode());
                    // 业主姓名
                    jpStation.setUserName(ksolarStation.getUserName());
                    jpStation.setState(KSolarConstant.collectStaus.get(String.valueOf(ksolarStation.getStatus())));
                    jpStation.setRealTimePower(ksolarStation.getPowerInter() != null ? ksolarStation.getPowerInter() / 1000 : 0.0);

                    jpStation.setDayGenerate(ksolarStation.getDayGeneration());
                    jpStation.setAccumulatedPower(ksolarStation.getTotalGeneration());
                    jpStation.setArea(ksolarStation.getAddress());
                    // 日收益
                    jpStation.setDayIncome(stationEarn.getDayEarn());
                    // 月发电量
                    jpStation.setMonthGenerate(stationEarn.getMonthGeneration());
                    // 年发电量
                    jpStation.setYearGenerate(stationEarn.getYearGeneration());

                    jpStation.setType("工商业");

                    // 月收益
                    jpStation.setMonthIncome(monthEarn.get("monthEarn"));
                    // 年收益
                    jpStation.setYearIncome(yearEarn.get("yearEarn"));
                    // 累计收益
                    jpStation.setCumulativeIncome(stationEarn.getTotalEarn());

                    // 并网类型
                    //                jpStation.setOnGridType(GoLangConstant.intoNetWorkStatus.get(String.valueOf(golangStationDetail.getStationtypenew())));
                    //                // 邮箱
                    //                jpStation.setEmail(golangStationDetail.getUseremail());
                    //                // 并网时间
                    //                jpStation.setOnGridTime(new Date(golangStationDetail.getFispowertime()));
                    //                // 接入平台时间
                    //                jpStation.setAccessTime(new Date(golangStationDetail.getFisgeneratetime()));
                    //                // 创建时间
                    //                jpStation.setCreateTime(new Date(golangStationDetail.getCreatedate()));
                    //                // 额定功率
                    //                jpStation.setRatedPower(Double.valueOf(golangStationDetail.getInverterpower()));
                    // 第三方电站id
                    //                jpStation.setThirdStationId(String.valueOf(golangStationDetail.getId()));
                    // 第三方厂商标识
                    //                jpStation.setThirdCode(PVProducerInfoEnum.JLY.getCode());
                    // 业主电话
                    //                jpStation.setUserPhone(String.valueOf(golangStationDetail.getUsermobile()));
                    // 电站联系人
                    //                jpStation.setStationContact(String.valueOf(golangStationDetail.getMobile()).toLowerCase().replace("null", ""));
                    // 组件数量
                    //                jpStation.setModuleCount(ObjectUtils.isEmpty(Math.toIntExact(golangStationDetail.getModule()))?0:Math.toIntExact(golangStationDetail.getModule()));
                    jpStation.setRecDate(new Date());
                    if (!ObjectUtils.isEmpty(jpStation.getSequenceNbr())) {
                        jpStationMapper.updateById(jpStation);
                    } else {
                        jpStationMapper.insert(jpStation);
                    }




                    //增加td 电站区域公司，经销商绑定表
//                    TdJpStation tdJpStation = tdJpStationMapper.selectOne(new QueryWrapper<TdJpStation>().
//                            eq("third_code",PVProducerInfoEnum.KSOLAR.getCode()).
//                            eq("third_station_id",  ksolarStation.getStationId()));
//                    //判断是否存在
//                    if (ObjectUtils.isEmpty(tdJpStation)) {
//                        tdJpStation = new TdJpStation();
//                    }
//                    tdJpStation.setAmosCompanyCode(jpStation.getAmosCompanyCode());
//                    tdJpStation.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
//                    tdJpStation.setThirdStationId( ksolarStation.getStationId());
//                    tdJpStation.setThirdCode(PVProducerInfoEnum.KSOLAR.getCode());
//                    tdJpStation.setIsDelete(jpStation.getIsDelete()?1:0);
//                    tdJpStation.setStationName(jpStation.getName());
//
//                    if (!ObjectUtils.isEmpty(tdJpStation.getCreatedTime())) {
//                        tdJpStationMapper.insert(tdJpStation);
//                    } else {
//                        tdJpStation.setCreatedTime(System.currentTimeMillis());
//                        tdJpStationMapper.insert(tdJpStation);
//                    }

                    HYGFJPStationPowerHistory hygfjpStationPowerHistory = new HYGFJPStationPowerHistory();
                    hygfjpStationPowerHistory.setCreatedTime(System.currentTimeMillis());
                    hygfjpStationPowerHistory.setThirdStationId(jpStation.getThirdStationId());
                    hygfjpStationPowerHistory.setPower(ksolarStation.getPowerInter());
                    hygfjpStationPowerHistory.setThirdCode(jpStation.getThirdCode());
                    hygfjpStationPowerHistory.setTime(System.currentTimeMillis());

                    //新加
                    hygfjpStationPowerHistory.setAmosCompanyCode(jpStation.getAmosCompanyCode());
                    hygfjpStationPowerHistory.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
                    hygfjpStationPowerHistory.setStationName(jpStation.getName());
                    hygfjpStationPowerHistory.setStationState(jpStation.getState());



                    hygfjpStationPowerHistoryMapper.insert(hygfjpStationPowerHistory);
                    HYGFJPDayPower hygfjpDayPower = hygfjpDayPowerMapper.selectOne(
                            new QueryWrapper<HYGFJPDayPower>().
                                    eq("tation_id", ksolarStation.getStationId()).
                                    eq("year_month_day", today).
                                    eq("hour", hour)
                    );
                    if (ObjectUtils.isEmpty(hygfjpDayPower)) {
                        hygfjpDayPower = new HYGFJPDayPower();
                    }
                    hygfjpDayPower.setTationId(ksolarStation.getStationId());
                    hygfjpDayPower.setHour(hour);
                    hygfjpDayPower.setYearMonthDay(today);
                    hygfjpDayPower.setPower(ksolarStation.getPowerInter());

                    //新加
                    hygfjpDayPower.setAmosCompanyCode(jpStation.getAmosCompanyCode());
                    hygfjpDayPower.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
                    hygfjpDayPower.setStationName(jpStation.getName());
                    hygfjpDayPower.setStationState(jpStation.getState());

                    if (ObjectUtils.isEmpty(hygfjpDayPower.getCreatedTime())) {
                        hygfjpDayPower.setCreatedTime(System.currentTimeMillis());
                        hygfjpDayPowerMapper.insert(hygfjpDayPower);
                    } else {
                        hygfjpDayPowerMapper.insert(hygfjpDayPower);
                    }
                    ksolarStationDetail.setCreatedTime(System.currentTimeMillis());

                    ksolarStationDetailsMapper.insert(ksolarStationDetail);
                    Date today1 = new Date();
                    //户用场站日发电量
                    TdHYGFStationDayGenerate tdHYGFStationDayGenerate = tdHYGFStationDayGenerateMapper.selectOne(new QueryWrapper<TdHYGFStationDayGenerate>()
                            .eq("third_station_id", stationId)
                            .eq("day_time", DateUtil.format(today1, "yyyy-MM-dd"))
                            .eq("year_month", DateUtil.format(today1, "yyyy-MM")));
                    if (ObjectUtils.isEmpty(tdHYGFStationDayGenerate)) {
                        tdHYGFStationDayGenerate = new TdHYGFStationDayGenerate();
                    }
                    tdHYGFStationDayGenerate.setThirdStationId(stationId);
                    tdHYGFStationDayGenerate.setDayTime(DateUtil.format(today1, "yyyy-MM-dd"));
                    tdHYGFStationDayGenerate.setYearMonth(DateUtil.format(today1, "yyyy-MM"));
                    tdHYGFStationDayGenerate.setGenerate(jpStation.getDayGenerate());
                    tdHYGFStationDayGenerate.setFullhour(jpStation.getDayGenerate() / jpStation.getCapacity());
                    tdHYGFStationDayGenerate.setIncome(jpStation.getDayIncome());

                    //新加
                    tdHYGFStationDayGenerate.setAmosCompanyCode(jpStation.getAmosCompanyCode());
                    tdHYGFStationDayGenerate.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
                    tdHYGFStationDayGenerate.setStationName(jpStation.getName());
                    tdHYGFStationDayGenerate.setStationState(jpStation.getState());

                    if (ObjectUtils.isEmpty(tdHYGFStationDayGenerate.getCreatedTime())) {
                        tdHYGFStationDayGenerate.setCreatedTime(System.currentTimeMillis());
                        tdHYGFStationDayGenerateMapper.insert(tdHYGFStationDayGenerate);
                    } else {
                        tdHYGFStationDayGenerateMapper.insert(tdHYGFStationDayGenerate);
                    }
                    //户用场站月发电量
                    TdHYGFStationMonthGenerate tdHYGFStationMonthGenerate = tdHYGFStationMonthGenerateMapper.selectOne(new QueryWrapper<TdHYGFStationMonthGenerate>()
                            .eq("third_station_id", stationId)
                            .eq("month_time", DateUtil.format(today1, "yyyy-MM"))
                            .eq("year", DateUtil.format(today1, "yyyy")));
                    if (ObjectUtils.isEmpty(tdHYGFStationMonthGenerate)) {
                        tdHYGFStationMonthGenerate = new TdHYGFStationMonthGenerate();
                    }
                    tdHYGFStationMonthGenerate.setThirdStationId(stationId);
                    tdHYGFStationMonthGenerate.setMonthTime(DateUtil.format(today1, "yyyy-MM"));
                    tdHYGFStationMonthGenerate.setYear(DateUtil.format(today1, "yyyy"));
                    tdHYGFStationMonthGenerate.setGenerate(jpStation.getMonthGenerate());
                    tdHYGFStationMonthGenerate.setFullhour(jpStation.getMonthGenerate() / jpStation.getCapacity());
                    tdHYGFStationMonthGenerate.setIncome(jpStation.getMonthIncome());

                    //新加
                    tdHYGFStationMonthGenerate.setAmosCompanyCode(jpStation.getAmosCompanyCode());
                    tdHYGFStationMonthGenerate.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
                    tdHYGFStationMonthGenerate.setStationName(jpStation.getName());
                    tdHYGFStationMonthGenerate.setStationState(jpStation.getState());

                    if (ObjectUtils.isEmpty(tdHYGFStationMonthGenerate.getCreatedTime())) {
                        tdHYGFStationMonthGenerate.setCreatedTime(System.currentTimeMillis());
                        tdHYGFStationMonthGenerateMapper.insert(tdHYGFStationMonthGenerate);
                    } else {
                        tdHYGFStationMonthGenerateMapper.insert(tdHYGFStationMonthGenerate);
                    }
                    //户用场站年发电量
                    TdHYGFStationYearGenerate tdHYGFStationYearGenerate = tdHYGFStationYearGenerateMapper.selectOne(new QueryWrapper<TdHYGFStationYearGenerate>()
                            .eq("third_station_id", stationId)
                            .eq("year_time", DateUtil.format(today1, "yyyy"))
                            .eq("year", DateUtil.format(today1, "yyyy")));
                    if (ObjectUtils.isEmpty(tdHYGFStationYearGenerate)) {
                        tdHYGFStationYearGenerate = new TdHYGFStationYearGenerate();
                    }
                    tdHYGFStationYearGenerate.setThirdStationId(stationId);
                    tdHYGFStationYearGenerate.setYearTime(DateUtil.format(today1, "yyyy"));
                    tdHYGFStationYearGenerate.setYear(DateUtil.format(today1, "yyyy"));
                    tdHYGFStationYearGenerate.setGenerate(jpStation.getYearGenerate());
                    tdHYGFStationYearGenerate.setFullhour(jpStation.getYearGenerate() / jpStation.getCapacity());
                    tdHYGFStationYearGenerate.setIncome(jpStation.getYearIncome());
                    //新加
                    tdHYGFStationYearGenerate.setAmosCompanyCode(jpStation.getAmosCompanyCode());
                    tdHYGFStationYearGenerate.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
                    tdHYGFStationYearGenerate.setStationName(jpStation.getName());
                    tdHYGFStationYearGenerate.setStationState(jpStation.getState());

                    if (ObjectUtils.isEmpty(tdHYGFStationYearGenerate.getCreatedTime())) {
                        tdHYGFStationYearGenerate.setCreatedTime(System.currentTimeMillis());
                        tdHYGFStationYearGenerateMapper.insert(tdHYGFStationYearGenerate);
                    } else {
                        tdHYGFStationYearGenerateMapper.insert(tdHYGFStationYearGenerate);
                    }
                }
            }
        }
    }

    /**
     * 获取单个站的发电量
     *
     * @param stationId 站id
     * @return 发电量实体
     */
    private KsolarStationEarn getStationEarn(String stationId) {
        KsolarStationEarn ksolarStationEarn = new KsolarStationEarn();
        // 获取单个电站的发电量和收益
        try {
            TimeUnit.SECONDS.sleep(1);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, Object> requestInfo = new HashMap<>(1);
        String requestParaminfo = JSON.toJSONString(requestInfo);
        String url = KSolarConstant.stationEarnUrl + "?stationId=" + stationId;
        List<KsolarStationEarn> ksolarStationEarns = kSolarRequestUtil.getResPonse(
                url,
                KSolarConstant.requestGET,
                requestParaminfo,
                KSolarConstant.resovle_data,
                KsolarStationEarn.class);

        if (!CollectionUtils.isEmpty(ksolarStationEarns)) {
            ksolarStationEarn = ksolarStationEarns.get(0);
            ksolarStationEarn.setCreatedTime(System.currentTimeMillis());
            ksolarStationEarnMapper.insert(ksolarStationEarn);
        }
        return ksolarStationEarn;
    }

    Map<String, Double> getStationMonthEarn(String stationId, String type) {
        Map<String, Double> map = new HashMap<>(1);
        try {
            TimeUnit.SECONDS.sleep(1);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, Object> requestInfo = new HashMap<>(1);
        String requestParaminfo = JSON.toJSONString(requestInfo);
        // 获取当前日期
        Date currentDate = new Date();
        // 创建SimpleDateFormat实例，指定日期格式
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        // 格式化日期为字符串
        String formattedDate = sdf.format(currentDate);
        // 从格式化后的字符串中提取年份和月份
        String year = formattedDate.substring(0, 4);
        String month = formattedDate;
        String attribId = "201";
        String stime = month;
        if ("year".equals(type)) {
            attribId = "202";
            stime = year;
        }
        String url = KSolarConstant.stationEarnChartUrl + "?stationId=" + stationId + "&attribId=" + attribId + "&stime=" + stime;
        List<KsolarStationEarnChart> ksolarStationEarnCharts = kSolarRequestUtil.getResPonse(
                url,
                KSolarConstant.requestGET,
                requestParaminfo,
                KSolarConstant.resovle_arr,
                KsolarStationEarnChart.class);
        double earnValues = 0;
        if (!CollectionUtils.isEmpty(ksolarStationEarnCharts)) {
            earnValues += ksolarStationEarnCharts.stream().mapToDouble(ksolarStationEarnChart -> Double.parseDouble(ksolarStationEarnChart.getEarnValue())).sum();
        }
        if ("year".equals(type)) {
            map.put("yearEarn", earnValues);
        } else {
            map.put("monthEarn", earnValues);
        }
        return map;
    }

    @Scheduled(cron = "${dataRequstScheduled.keshida}")
    @Override
    public void collectorList() {
        List<String> stationIds = kSolarStationMapper.getStationIds();
        for (String stationId : stationIds) {
            LambdaQueryWrapper<KsolarStationList> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(KsolarStationList::getStationId, stationId);
            wrapper.orderByDesc(KsolarStationList::getCreatedTime);
            List<KsolarStationList> ksolarStationLists = kSolarStationMapper.selectList(wrapper);
            if (!CollectionUtils.isEmpty(ksolarStationLists)) {
                KsolarStationList ksolarStationList = ksolarStationLists.get(0);
                try {
                    TimeUnit.SECONDS.sleep(1);
                } catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                HashMap<String, Object> requestInfo = new HashMap<>(1);
                String requestParaminfo = JSON.toJSONString(requestInfo);
                String url = KSolarConstant.stationCollectListUrl + "?stationId=" + ksolarStationList.getStationId() + "&pageNumber=1&pageSize=200";
                List<KsolarStationCollectList> result = kSolarRequestUtil.getResPonse(
                        url,
                        KSolarConstant.requestGET,
                        requestParaminfo,
                        KSolarConstant.resovle_rows,
                        KsolarStationCollectList.class
                );
                for (KsolarStationCollectList ksolarStationCollectList : result) {

                    ksolarStationCollectList.setCreatedTime(System.currentTimeMillis());
                    ksolarStationCollectList.setThirdStationId(ksolarStationList.getStationId());
                    ksolarStationCollectListMapper.insert(ksolarStationCollectList);

                    JpCollector jpCollector = jpCollectorMapper.selectOne(new QueryWrapper<JpCollector>().
                            eq("third_station_id", ksolarStationCollectList.getThirdStationId()).
                            eq("sn_code", ksolarStationCollectList.getCollectId().trim()).
                            eq("third_code", PVProducerInfoEnum.KSOLAR.getCode()));
                    if (ObjectUtils.isEmpty(jpCollector)) {
                        jpCollector = new JpCollector();
                    }
//                //出场日期
//                jpCollector.setDischargeDate(new Date(collectorDetailDto.getFactoryTime()));
//                //生产日期
//                jpCollector.setProductDate(new Date(collectorDetailDto.getFactoryTime()));
//                //数据上传间隔
//                jpCollector.setDataPeriod(collectorDetailDto.getDataUploadCycle());
//                //本次上电时间
//                jpCollector.setThisWorkTime(new DateTime(collectorDetailDto.getCurrentWorkingTime()));
//                //累计工作时间
//                jpCollector.setTotalWorkTime(new DateTime(collectorDetailDto.getTotalWorkingTime()));

                    // sn编码
                    jpCollector.setSnCode(ksolarStationCollectList.getCollectId().trim());
                    // 更新时间
                    jpCollector.setUpdateTime(new Date());
                    // 第三方电站id
                    jpCollector.setThirdStationId(ksolarStationCollectList.getThirdStationId());
                    // 第三方厂商标识
                    jpCollector.setThirdCode(PVProducerInfoEnum.KSOLAR.getCode());
                    //第三方厂商标识
                    jpCollector.setState(KSolarConstant.collectStaus.get(ksolarStationCollectList.getStatus()));
                    jpCollector.setStationName(ksolarStationCollectList.getStationName());
                    jpCollector.setAddr(ksolarStationCollectList.getAddress());
                    jpCollector.setName(ksolarStationCollectList.getCollectName());
                    jpCollector.setVersion(ksolarStationCollectList.getCollectVersion());
                    jpCollector.setType(ksolarStationCollectList.getDeviceModel());
                    //信号强度
                    jpCollector.setSignalStrength(String.valueOf(ksolarStationCollectList.getSignal()));
                    jpCollector.setRecDate(new Date());
                    if (ObjectUtils.isEmpty(jpCollector.getSequenceNbr())) {
                        jpCollectorMapper.insert(jpCollector);
                    } else {
                        jpCollectorMapper.updateById(jpCollector);
                    }
                    HYGFJPCollectorHistory hygfjpCollectorHistory = new HYGFJPCollectorHistory();
                    hygfjpCollectorHistory.setTime(System.currentTimeMillis());
                    hygfjpCollectorHistory.setCreatedTime(System.currentTimeMillis());
                    hygfjpCollectorHistory.setSnCode(ksolarStationCollectList.getCollectId().trim());
                    hygfjpCollectorHistory.setSignalStrength(ksolarStationCollectList.getSignal());
                    hygfjpCollectorHistory.setThirdStationId(ksolarStationCollectList.getThirdStationId());
                    hygfjpCollectorHistory.setThirdCode(PVProducerInfoEnum.KSOLAR.getCode());
                    hygfjpCollectorHistoryMapper.insert(hygfjpCollectorHistory);
                }
            }
        }
    }

    @Scheduled(cron = "${dataRequstScheduled.keshida}")
    @Override
    public void collectorDetail() {

        List<JpCollector> jpCollectorlist = jpCollectorMapper.selectList(new QueryWrapper<JpCollector>().
                eq("third_code", PVProducerInfoEnum.KSOLAR.getCode()));
        List<String> collectIds = ksolarStationCollectListMapper.getCollectIds();
        if (!CollectionUtils.isEmpty(collectIds)) {
            collectIds.forEach(collectId -> {
                LambdaQueryWrapper<KsolarStationCollectList> wrapper = new LambdaQueryWrapper<>();
                wrapper.eq(KsolarStationCollectList::getCollectId, collectId);
                wrapper.orderByDesc(KsolarStationCollectList::getCreatedTime);
                List<KsolarStationCollectList> ksolarStationCollectLists = ksolarStationCollectListMapper.selectList(wrapper);
                if (!CollectionUtils.isEmpty(ksolarStationCollectLists)) {
                    KsolarStationCollectList ksolarStationCollectList = ksolarStationCollectLists.get(0);
                    try {
                        TimeUnit.SECONDS.sleep(1);
                    } catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    HashMap<String, Object> requestInfo = new HashMap<>(1);
                    String requestParaminfo = JSON.toJSONString(requestInfo);
                    String url = KSolarConstant.stationCollectDataUrl + "?collectId=" + collectId;
                    List<KsolarStationCollectData> result = kSolarRequestUtil.getResPonse(
                            url,
                            KSolarConstant.requestGET,
                            requestParaminfo,
                            KSolarConstant.resovle_data,
                            KsolarStationCollectData.class
                    );
                    if (jpCollectorlist != null && jpCollectorlist.size() > 0) {

                        JpCollector jpCollectorflag = null;
                        for (JpCollector jpCollector : jpCollectorlist) {
                            if (jpCollector.getSnCode().equals(ksolarStationCollectList.getCollectId().trim()) && KSolarConstant.collectStaus.get("1").equals(jpCollector.getState())) {
                                jpCollectorflag = jpCollector;
                                break;
                            }
                        }
                        if (jpCollectorflag != null) {
                            //离线状态
                            JpInverter jpInverter = jpInverterMapper.selectOne(new QueryWrapper<JpInverter>().
                                    eq("collector_sn_code", jpCollectorflag.getSnCode().trim()) );
                            if (ObjectUtils.isEmpty(jpInverter)) {
                                jpInverter = new JpInverter();
                            }

                            jpInverter.setCapacity(KSolarConstant.Capacity.get(StringUtils.lowerCase(jpCollectorflag.getName())));
                            jpInverter.setSnCode(jpInverter.getSnCode());
                            jpInverter.setId(jpInverter.getId());
                            jpInverter.setState(jpCollectorflag.getState());
                            jpInverter.setCollectorId(ksolarStationCollectList.getCollectId().trim());
                            jpInverter.setCollectorSnCode(ksolarStationCollectList.getCollectId().trim());
                            jpInverter.setUpdateTime(new Date());
                            jpInverter.setCurrentPower(null);
                            jpInverter.setDayPowerGeneration(jpInverter.getDayPowerGeneration());
                            jpInverter.setMonthPowerGeneration(jpInverter.getMonthPowerGeneration());
                            jpInverter.setYearPowerGeneration(jpInverter.getYearPowerGeneration());
                            jpInverter.setTotalPowerGeneration(jpInverter.getTotalPowerGeneration());
                            jpInverter.setModel(jpInverter.getModel());
                            jpInverter.setVersion(jpInverter.getVersion());
                            jpInverter.setThirdStationId(ksolarStationCollectList.getThirdStationId());
                            jpInverter.setThirdCode(PVProducerInfoEnum.KSOLAR.getCode());
                            jpInverter.setName(ksolarStationCollectList.getCollectName());
                            jpInverter.setStationName(ksolarStationCollectList.getStationName());
                            jpInverter.setAddr(ksolarStationCollectList.getAddress());
                            jpInverter.setRecDate(new Date());
                            if (!ObjectUtils.isEmpty(jpInverter.getSequenceNbr())) {
                                jpInverterMapper.updateById(jpInverter);
                            } else {
                                if(StringUtils.isNotEmpty(jpInverter.getSnCode())){
                                    jpInverterMapper.insert(jpInverter);
                                }

                            }


                            for (int k1 = 1; k1 < 13; k1++) {
                                JpInverterElectricity jpInverterElectricity = jpInverterElectricityMapper.selectOne(new QueryWrapper<JpInverterElectricity>().
                                        eq("sn_code", jpInverter.getSnCode().trim()).
                                        eq("type", "直流").
                                        eq("name", "PV" + k1)
                                );
                                if (ObjectUtils.isEmpty(jpInverterElectricity)) {
                                    jpInverterElectricity = new JpInverterElectricity();
                                }
                                jpInverterElectricity.setInverterId(jpInverter.getSnCode());
                                jpInverterElectricity.setSnCode(jpInverter.getSnCode());
                                jpInverterElectricity.setThirdCode(PVProducerInfoEnum.KSOLAR.getCode());
                                jpInverterElectricity.setThirdStationId(ksolarStationCollectList.getThirdStationId());
                                jpInverterElectricity.setType("直流");
                                jpInverterElectricity.setName("PV" + k1);
                                jpInverterElectricity.setVoltage(null);
                                jpInverterElectricity.setCurrent(null);
                                jpInverterElectricity.setPower(null);
                                if (ObjectUtils.isEmpty(jpInverterElectricity.getSequenceNbr())) {
                                    jpInverterElectricityMapper.insert(jpInverterElectricity);
                                } else {
                                    jpInverterElectricityMapper.updateById(jpInverterElectricity);
                                }
                            }

                            JpInverterElectricity jpInverterElectricityR = jpInverterElectricityMapper.selectOne(new QueryWrapper<JpInverterElectricity>().
                                    eq("sn_code", jpInverter.getSnCode().trim()).
                                    eq("type", "交流").
                                    eq("name", "RS")
                            );
                            if (ObjectUtils.isEmpty(jpInverterElectricityR)) {
                                jpInverterElectricityR = new JpInverterElectricity();
                            }
                            jpInverterElectricityR.setInverterId(jpInverter.getSnCode());
                            jpInverterElectricityR.setSnCode(jpInverter.getSnCode());
                            jpInverterElectricityR.setThirdCode(PVProducerInfoEnum.KSOLAR.getCode());
                            jpInverterElectricityR.setThirdStationId(ksolarStationCollectList.getThirdStationId());
                            jpInverterElectricityR.setFrequency(null);
                            jpInverterElectricityR.setType("交流");
                            jpInverterElectricityR.setName("RS");
                            jpInverterElectricityR.setVoltage(null);
                            jpInverterElectricityR.setCurrent(null);
                            if (ObjectUtils.isEmpty(jpInverterElectricityR.getSequenceNbr())) {
                                jpInverterElectricityMapper.insert(jpInverterElectricityR);
                            } else {
                                jpInverterElectricityMapper.updateById(jpInverterElectricityR);
                            }

                            JpInverterElectricity jpInverterElectricityS = jpInverterElectricityMapper.selectOne(new QueryWrapper<JpInverterElectricity>().
                                    eq("sn_code", jpInverter.getSnCode().trim()).
                                    eq("type", "交流").
                                    eq("name", "ST")
                            );
                            if (ObjectUtils.isEmpty(jpInverterElectricityS)) {
                                jpInverterElectricityS = new JpInverterElectricity();
                            }
                            jpInverterElectricityS.setInverterId(jpInverter.getSnCode());
                            jpInverterElectricityS.setSnCode(jpInverter.getSnCode());
                            jpInverterElectricityS.setThirdCode(PVProducerInfoEnum.KSOLAR.getCode());
                            jpInverterElectricityS.setThirdStationId(ksolarStationCollectList.getThirdStationId());
                            jpInverterElectricityS.setType("交流");
                            jpInverterElectricityS.setName("ST");
                            jpInverterElectricityS.setVoltage(null);
                            jpInverterElectricityS.setCurrent(null);
                            if (ObjectUtils.isEmpty(jpInverterElectricityS.getSequenceNbr())) {
                                jpInverterElectricityMapper.insert(jpInverterElectricityS);
                            } else {
                                jpInverterElectricityMapper.updateById(jpInverterElectricityS);
                            }


                            JpInverterElectricity jpInverterElectricityT = jpInverterElectricityMapper.selectOne(new QueryWrapper<JpInverterElectricity>().
                                    eq("sn_code", jpInverter.getSnCode().trim()).
                                    eq("type", "交流").
                                    eq("name", "TR")
                            );
                            if (ObjectUtils.isEmpty(jpInverterElectricityT)) {
                                jpInverterElectricityT = new JpInverterElectricity();
                            }
                            jpInverterElectricityT.setInverterId(jpInverter.getSnCode());
                            jpInverterElectricityT.setSnCode(jpInverter.getSnCode());
                            jpInverterElectricityT.setThirdCode(PVProducerInfoEnum.KSOLAR.getCode());
                            jpInverterElectricityT.setThirdStationId(ksolarStationCollectList.getThirdStationId());
                            jpInverterElectricityT.setType("交流");
                            jpInverterElectricityT.setName("TR");
                            jpInverterElectricityT.setVoltage(null);
                            jpInverterElectricityT.setCurrent(null);
                            if (ObjectUtils.isEmpty(jpInverterElectricityT.getSequenceNbr())) {
                                jpInverterElectricityMapper.insert(jpInverterElectricityT);
                            } else {
                                jpInverterElectricityMapper.updateById(jpInverterElectricityT);
                            }

//
                            HYGFJPInverterElecHistory hygfjpInverterElecHistory = new HYGFJPInverterElecHistory();
                            hygfjpInverterElecHistory.setThirdStationId(ksolarStationCollectList.getThirdStationId());
                            hygfjpInverterElecHistory.setCreatedTime(System.currentTimeMillis());
                            hygfjpInverterElecHistory.setSnCode(jpInverter.getSnCode());

                            hygfjpInverterElecHistory.setUAcCurrent(null);
                            hygfjpInverterElecHistory.setVAcCurrent(null);
                            hygfjpInverterElecHistory.setWAcCurrent(null);
                            hygfjpInverterElecHistory.setUAcVoltage(null);
                            hygfjpInverterElecHistory.setVAcVoltage(null);
                            hygfjpInverterElecHistory.setWAcVoltage(null);
                            hygfjpInverterElecHistory.setThirdCode(PVProducerInfoEnum.KSOLAR.getCode());
                            hygfjpInverterElecHistory.setTime(System.currentTimeMillis());
                            hygfjpInverterElecHistoryMapper.insert(hygfjpInverterElecHistory);

                            // 逆变器历史
                            String today = DateUtil.today();
                            HYGFJPInverterHistory hygfjpInverterHistory = hygfjpInverterHistoryMapper.selectOne(
                                    new QueryWrapper<HYGFJPInverterHistory>().eq("sn_code", jpInverter.getSnCode().trim()).eq("date", today));
                            if (ObjectUtils.isEmpty(hygfjpInverterHistory)) {
                                hygfjpInverterHistory = new HYGFJPInverterHistory();
                            }

                            // 满发小时数
//                        hygfjpInverterHistory.setGenerationHours(inverterDetailDto.getFullHour());
                            hygfjpInverterHistory.setDate(today);
                            hygfjpInverterHistory.setThirdStationId(ksolarStationCollectList.getThirdStationId());
                            hygfjpInverterHistory.setInverterId(jpInverter.getSnCode());
                            hygfjpInverterHistory.setSnCode(jpInverter.getSnCode());
                            hygfjpInverterHistory.setThirdCode(PVProducerInfoEnum.KSOLAR.getCode());
                            hygfjpInverterHistory.setPowerGeneration(null);
                            if (ObjectUtils.isEmpty(hygfjpInverterHistory.getCreatedTime())) {
                                hygfjpInverterHistory.setCreatedTime(System.currentTimeMillis());
                                hygfjpInverterHistoryMapper.insert(hygfjpInverterHistory);
                            } else {
                                hygfjpInverterHistoryMapper.insert(hygfjpInverterHistory);
                            }


                        } else {

                            if (!CollectionUtils.isEmpty(result)) {
                                result.forEach(ksolarStationCollectData -> {
                                    List<JpInverter> jpInverterList = jpInverterMapper.selectList(new QueryWrapper<JpInverter>().
                                            eq("third_station_id", ksolarStationCollectList.getThirdStationId()).
                                            eq("third_code", PVProducerInfoEnum.KSOLAR.getCode()).
                                            like("sn_code", ksolarStationCollectData.getInverterId().trim())
                                            .isNotNull("sn_code")
                                            .orderByDesc("update_time"));
                                    JpInverter jpInverter =jpInverterList.get(0);
                                    if (ObjectUtils.isEmpty(jpInverter)) {
                                        jpInverter = new JpInverter();
                                    }

                                    // 品牌
//                        jpInverter.setBrand(inverterDetailDto.getName());
                                    // 国标
//                        jpInverter.setNationalStandard(inverterDetailDto.getNationalStandards());
                                    // 满发小时数
//                        jpInverter.setGenerationHours(String.valueOf(inverterDetailDto.getFullHour()));
                                    // 装机容量
                                    // jpInverter.setCapacity();
                                    if (jpCollectorlist != null && jpCollectorlist.size() > 0) {
                                        for (JpCollector jpCollector : jpCollectorlist) {
                                            if (jpCollector.getSnCode().equals(ksolarStationCollectList.getCollectId().trim())) {
                                                jpInverter.setCapacity(KSolarConstant.Capacity.get(StringUtils.lowerCase(jpCollector.getName())));
                                            }
                                        }
                                    }
                                    jpInverter.setSnCode(ksolarStationCollectData.getInverterId().trim());
                                    jpInverter.setId(ksolarStationCollectData.getInverterId().trim());
                                    jpInverter.setState(KSolarConstant.collectStaus.get(ksolarStationCollectData.getStatus()));
                                    jpInverter.setCollectorId(ksolarStationCollectList.getCollectId().trim());
                                    jpInverter.setCollectorSnCode(ksolarStationCollectList.getCollectId().trim());
                                    jpInverter.setUpdateTime(new Date());

                                    jpInverter.setCurrentPower(ksolarStationCollectData.getPowerApparent() != null ? ksolarStationCollectData.getPowerApparent() / 1000 : null);
                                    jpInverter.setDayPowerGeneration(ksolarStationCollectData.getDayGeneration());
                                    jpInverter.setMonthPowerGeneration(ksolarStationCollectData.getMonthGeneration());
                                    jpInverter.setYearPowerGeneration(ksolarStationCollectData.getYearGeneration());
                                    jpInverter.setTotalPowerGeneration(ksolarStationCollectData.getTotalGeneration());
                                    jpInverter.setModel(ksolarStationCollectData.getDeviceModel());
                                    jpInverter.setVersion(ksolarStationCollectData.getVersion());
                                    jpInverter.setThirdStationId(ksolarStationCollectList.getThirdStationId());
                                    jpInverter.setThirdCode(PVProducerInfoEnum.KSOLAR.getCode());
                                    jpInverter.setName(ksolarStationCollectList.getCollectName());
                                    jpInverter.setStationName(ksolarStationCollectList.getStationName());
                                    jpInverter.setAddr(ksolarStationCollectList.getAddress());
                                    if (!ObjectUtils.isEmpty(jpInverter.getSequenceNbr())) {
                                        jpInverterMapper.updateById(jpInverter);
                                    } else {
                                        if(StringUtils.isNotEmpty(jpInverter.getSnCode())){
                                            jpInverterMapper.insert(jpInverter);
                                        }
                                    }


                                    String jsonString = JSON.toJSONString(ksolarStationCollectData);
                                    Map<String, Object> hanlderResult = JSON.parseObject(jsonString, Map.class);

                                    for (int k1 = 1; k1 < 13; k1++) {
                                        JpInverterElectricity jpInverterElectricity = jpInverterElectricityMapper.selectOne(new QueryWrapper<JpInverterElectricity>().
                                                eq("sn_code", ksolarStationCollectData.getInverterId().trim()).
                                                eq("type", "直流").
                                                eq("name", "PV" + k1)
                                        );
                                        if (ObjectUtils.isEmpty(jpInverterElectricity)) {
                                            jpInverterElectricity = new JpInverterElectricity();
                                        }
                                        jpInverterElectricity.setInverterId(ksolarStationCollectData.getInverterId().trim());
                                        jpInverterElectricity.setSnCode(ksolarStationCollectData.getInverterId().trim());
                                        jpInverterElectricity.setThirdCode(PVProducerInfoEnum.KSOLAR.getCode());
                                        jpInverterElectricity.setThirdStationId(ksolarStationCollectList.getThirdStationId());
                                        jpInverterElectricity.setType("直流");
                                        jpInverterElectricity.setName("PV" + k1);
                                        jpInverterElectricity.setVoltage(Double.valueOf(hanlderResult.get("voltagePv" + k1).toString()));
                                        jpInverterElectricity.setCurrent(Double.valueOf(hanlderResult.get("currentPv" + k1).toString()));
                                        jpInverterElectricity.setPower(Double.valueOf(hanlderResult.get("powerPv" + k1).toString()));
                                        if (ObjectUtils.isEmpty(jpInverterElectricity.getSequenceNbr())) {
                                            jpInverterElectricityMapper.insert(jpInverterElectricity);
                                        } else {
                                            jpInverterElectricityMapper.updateById(jpInverterElectricity);
                                        }
                                    }

                                    JpInverterElectricity jpInverterElectricityR = jpInverterElectricityMapper.selectOne(new QueryWrapper<JpInverterElectricity>().
                                            eq("sn_code", ksolarStationCollectData.getInverterId().trim()).
                                            eq("type", "交流").
                                            eq("name", "RS")
                                    );
                                    if (ObjectUtils.isEmpty(jpInverterElectricityR)) {
                                        jpInverterElectricityR = new JpInverterElectricity();
                                    }
                                    jpInverterElectricityR.setInverterId(ksolarStationCollectData.getInverterId().trim());
                                    jpInverterElectricityR.setSnCode(ksolarStationCollectData.getInverterId().trim());
                                    jpInverterElectricityR.setThirdCode(PVProducerInfoEnum.KSOLAR.getCode());
                                    jpInverterElectricityR.setThirdStationId(ksolarStationCollectList.getThirdStationId());
                                    jpInverterElectricityR.setFrequency(ksolarStationCollectData.getFrequencyRs());
                                    jpInverterElectricityR.setType("交流");
                                    jpInverterElectricityR.setName("RS");
                                    jpInverterElectricityR.setVoltage(ksolarStationCollectData.getVoltageRs());
                                    jpInverterElectricityR.setCurrent(ksolarStationCollectData.getCurrentR());
                                    if (ObjectUtils.isEmpty(jpInverterElectricityR.getSequenceNbr())) {
                                        jpInverterElectricityMapper.insert(jpInverterElectricityR);
                                    } else {
                                        jpInverterElectricityMapper.updateById(jpInverterElectricityR);
                                    }

                                    JpInverterElectricity jpInverterElectricityS = jpInverterElectricityMapper.selectOne(new QueryWrapper<JpInverterElectricity>().
                                            eq("sn_code", ksolarStationCollectData.getInverterId().trim()).
                                            eq("type", "交流").
                                            eq("name", "ST")
                                    );
                                    if (ObjectUtils.isEmpty(jpInverterElectricityS)) {
                                        jpInverterElectricityS = new JpInverterElectricity();
                                    }
                                    jpInverterElectricityS.setInverterId(ksolarStationCollectData.getInverterId().trim());
                                    jpInverterElectricityS.setSnCode(ksolarStationCollectData.getInverterId().trim());
                                    jpInverterElectricityS.setThirdCode(PVProducerInfoEnum.KSOLAR.getCode());
                                    jpInverterElectricityS.setThirdStationId(ksolarStationCollectList.getThirdStationId());
                                    jpInverterElectricityS.setType("交流");
                                    jpInverterElectricityS.setName("ST");
                                    jpInverterElectricityS.setVoltage(ksolarStationCollectData.getVoltageSt());
                                    jpInverterElectricityS.setCurrent(ksolarStationCollectData.getCurrents());
                                    if (ObjectUtils.isEmpty(jpInverterElectricityS.getSequenceNbr())) {
                                        jpInverterElectricityMapper.insert(jpInverterElectricityS);
                                    } else {
                                        jpInverterElectricityMapper.updateById(jpInverterElectricityS);
                                    }


                                    JpInverterElectricity jpInverterElectricityT = jpInverterElectricityMapper.selectOne(new QueryWrapper<JpInverterElectricity>().
                                            eq("sn_code", ksolarStationCollectData.getInverterId().trim()).
                                            eq("type", "交流").
                                            eq("name", "TR")
                                    );
                                    if (ObjectUtils.isEmpty(jpInverterElectricityT)) {
                                        jpInverterElectricityT = new JpInverterElectricity();
                                    }
                                    jpInverterElectricityT.setInverterId(ksolarStationCollectData.getInverterId().trim());
                                    jpInverterElectricityT.setSnCode(ksolarStationCollectData.getInverterId().trim());
                                    jpInverterElectricityT.setThirdCode(PVProducerInfoEnum.KSOLAR.getCode());
                                    jpInverterElectricityT.setThirdStationId(ksolarStationCollectList.getThirdStationId());
                                    jpInverterElectricityT.setType("交流");
                                    jpInverterElectricityT.setName("TR");
                                    jpInverterElectricityT.setVoltage(ksolarStationCollectData.getVoltageTr());
                                    jpInverterElectricityT.setCurrent(ksolarStationCollectData.getCurrentT());
                                    if (ObjectUtils.isEmpty(jpInverterElectricityT.getSequenceNbr())) {
                                        jpInverterElectricityMapper.insert(jpInverterElectricityT);
                                    } else {
                                        jpInverterElectricityMapper.updateById(jpInverterElectricityT);
                                    }

//
                                    HYGFJPInverterElecHistory hygfjpInverterElecHistory = new HYGFJPInverterElecHistory();
                                    hygfjpInverterElecHistory.setThirdStationId(ksolarStationCollectList.getThirdStationId());
                                    hygfjpInverterElecHistory.setCreatedTime(System.currentTimeMillis());
                                    hygfjpInverterElecHistory.setSnCode(ksolarStationCollectData.getInverterId().trim());

                                    hygfjpInverterElecHistory.setUAcCurrent(ksolarStationCollectData.getCurrentR());
                                    hygfjpInverterElecHistory.setVAcCurrent(ksolarStationCollectData.getCurrents());
                                    hygfjpInverterElecHistory.setWAcCurrent(ksolarStationCollectData.getCurrentT());
                                    hygfjpInverterElecHistory.setUAcVoltage(ksolarStationCollectData.getVoltageRs());
                                    hygfjpInverterElecHistory.setVAcVoltage(ksolarStationCollectData.getVoltageSt());
                                    hygfjpInverterElecHistory.setWAcVoltage(ksolarStationCollectData.getVoltageTr());
                                    hygfjpInverterElecHistory.setThirdCode(PVProducerInfoEnum.KSOLAR.getCode());
                                    hygfjpInverterElecHistory.setTime(System.currentTimeMillis());
                                    hygfjpInverterElecHistoryMapper.insert(hygfjpInverterElecHistory);

                                    // 逆变器历史
                                    String today = DateUtil.today();
                                    HYGFJPInverterHistory hygfjpInverterHistory = hygfjpInverterHistoryMapper.selectOne(
                                            new QueryWrapper<HYGFJPInverterHistory>().eq("sn_code", ksolarStationCollectData.getInverterId()).eq("date", today));
                                    if (ObjectUtils.isEmpty(hygfjpInverterHistory)) {
                                        hygfjpInverterHistory = new HYGFJPInverterHistory();
                                    }

                                    // 满发小时数
//                        hygfjpInverterHistory.setGenerationHours(inverterDetailDto.getFullHour());
                                    hygfjpInverterHistory.setDate(today);
                                    hygfjpInverterHistory.setThirdStationId(ksolarStationCollectList.getThirdStationId());
                                    hygfjpInverterHistory.setInverterId(ksolarStationCollectData.getInverterId());
                                    hygfjpInverterHistory.setSnCode(jpInverter.getSnCode().trim());
                                    hygfjpInverterHistory.setThirdCode(PVProducerInfoEnum.KSOLAR.getCode());
                                    hygfjpInverterHistory.setPowerGeneration(ksolarStationCollectData.getTotalGeneration());
                                    if (ObjectUtils.isEmpty(hygfjpInverterHistory.getCreatedTime())) {
                                        hygfjpInverterHistory.setCreatedTime(System.currentTimeMillis());
                                        hygfjpInverterHistoryMapper.insert(hygfjpInverterHistory);
                                    } else {
                                        hygfjpInverterHistoryMapper.insert(hygfjpInverterHistory);
                                    }

                                    //-----------------------户用光伏日报表----------------------
                                    TdHYGFInverterDayGenerate tdHYGFInverterDayGenerate = new TdHYGFInverterDayGenerate();
                                    tdHYGFInverterDayGenerate.setCreatedTime(System.currentTimeMillis());
                                    tdHYGFInverterDayGenerate.setThirdStationId(jpInverter.getThirdStationId());
                                    tdHYGFInverterDayGenerate.setSnCode(jpInverter.getSnCode());
                                    tdHYGFInverterDayGenerate.setName(jpInverter.getName());
                                    tdHYGFInverterDayGenerate.setWorkStatus(jpInverter.getState());
                                    //交流电压
                                    tdHYGFInverterDayGenerate.setDcv1(jpInverterElectricityR.getVoltage());
                                    tdHYGFInverterDayGenerate.setDcv2(jpInverterElectricityS.getVoltage());
                                    tdHYGFInverterDayGenerate.setDcv3(jpInverterElectricityT.getVoltage());
                                    //交流电流
//                tdHYGFInverterDayGenerate.setDcv4(inverterDetailDto.getUAc4());
                                    tdHYGFInverterDayGenerate.setDcc1(jpInverterElectricityR.getCurrent());
                                    tdHYGFInverterDayGenerate.setDcc2(jpInverterElectricityS.getCurrent());
                                    tdHYGFInverterDayGenerate.setDcc3(jpInverterElectricityT.getCurrent());
//                tdHYGFInverterDayGenerate.setDcc4(inverterDetailDto.getIAc4());
                                    //直流电压
                                    tdHYGFInverterDayGenerate.setAcv1(Double.valueOf(hanlderResult.get("voltagePv1").toString()));
                                    tdHYGFInverterDayGenerate.setAcv2(Double.valueOf(hanlderResult.get("voltagePv2").toString()));
                                    tdHYGFInverterDayGenerate.setAcv3(Double.valueOf(hanlderResult.get("voltagePv3").toString()));
                                    tdHYGFInverterDayGenerate.setAcv4(Double.valueOf(hanlderResult.get("voltagePv4").toString()));
                                    //直流电流
                                    tdHYGFInverterDayGenerate.setAcc1(Double.valueOf(hanlderResult.get("currentPv1").toString()));
                                    tdHYGFInverterDayGenerate.setAcc2(Double.valueOf(hanlderResult.get("currentPv2").toString()));
                                    tdHYGFInverterDayGenerate.setAcc3(Double.valueOf(hanlderResult.get("currentPv3").toString()));
                                    tdHYGFInverterDayGenerate.setAcc4(Double.valueOf(hanlderResult.get("currentPv4").toString()));

                                    tdHYGFInverterDayGenerate.setPv1(Double.valueOf(hanlderResult.get("powerPv1").toString()));
                                    tdHYGFInverterDayGenerate.setPv2(Double.valueOf(hanlderResult.get("powerPv2").toString()));
                                    tdHYGFInverterDayGenerate.setPv3(Double.valueOf(hanlderResult.get("powerPv3").toString()));
                                    tdHYGFInverterDayGenerate.setPv4(Double.valueOf(hanlderResult.get("powerPv4").toString()));
                                    //功率
                                    tdHYGFInverterDayGenerate.setTotalPower(jpInverter.getCurrentPower());
//                                    //频率
                                    tdHYGFInverterDayGenerate.setFrequency(String.valueOf(jpInverterElectricityR.getFrequency()));
//                                    //功率因数
                                    tdHYGFInverterDayGenerate.setPowerFactor(1.0);
                                    tdHYGFInverterDayGenerate.setDayGen(jpInverter.getDayPowerGeneration());
                                    tdHYGFInverterDayGenerate.setMonthGen(jpInverter.getMonthPowerGeneration());
                                    tdHYGFInverterDayGenerate.setYearGen(jpInverter.getYearPowerGeneration());
                                    tdHYGFInverterDayGenerate.setTotalGen(jpInverter.getTotalPowerGeneration());
                                    tdHYGFInverterDayGenerate.setIgbtTemp(ObjectUtils.isEmpty(jpInverter.getIgbtTemperature()) ? null : Double.valueOf(jpInverter.getIgbtTemperature()));
                                    tdHYGFInverterDayGenerate.setIncome(null);
                                    tdHYGFInverterDayGenerate.setFullhour(0.0d);

                                    tdHYGFInverterDayGenerate.setFullhour(jpInverter.getDayPowerGeneration() / jpInverter.getCapacity());


                                    //电站区域经销商，
                                    JpStation jpStation = jpStationMapper.selectOne(new QueryWrapper<JpStation>().
                                            eq("third_code",PVProducerInfoEnum.KSOLAR.getCode()).
                                            eq("third_station_id", String.valueOf(jpInverter.getThirdStationId())));

                                    if(jpStation!=null){
                                        tdHYGFInverterDayGenerate.setAmosCompanyCode(jpStation.getAmosCompanyCode());
                                        tdHYGFInverterDayGenerate.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
                                        tdHYGFInverterDayGenerate.setStationName(jpStation.getName());
                                        tdHYGFInverterDayGenerate.setStationState(jpStation.getState());

                                    }



                                    tdHYGFInverterDayGenerateMapper.insert(tdHYGFInverterDayGenerate);
                                    //户用场站月发电量
                                    Date today1 = new Date();
                                    TdHYGFInverterMonthGenerate tdHYGFInverterMonthGenerate = tdHYGFInverterMonthGenerateMapper.selectOne(new QueryWrapper<TdHYGFInverterMonthGenerate>()
                                            .eq("third_station_id", jpInverter.getThirdStationId())
                                            .eq("sn_code", jpInverter.getSnCode())
                                            .eq("day_time", DateUtil.format(today1, "yyyy-MM-dd"))
                                            .eq("year_month", DateUtil.format(today1, "yyyy-MM")));
                                    if (ObjectUtils.isEmpty(tdHYGFInverterMonthGenerate)) {
                                        tdHYGFInverterMonthGenerate = new TdHYGFInverterMonthGenerate();
                                    }
                                    tdHYGFInverterMonthGenerate.setThirdStationId(jpInverter.getThirdStationId());
                                    tdHYGFInverterMonthGenerate.setSnCode(jpInverter.getSnCode().trim());
                                    tdHYGFInverterMonthGenerate.setDayTime(DateUtil.format(today1, "yyyy-MM-dd"));
                                    tdHYGFInverterMonthGenerate.setYearMonth(DateUtil.format(today1, "yyyy-MM"));
                                    tdHYGFInverterMonthGenerate.setGenerate(jpInverter.getDayPowerGeneration());
                                    tdHYGFInverterMonthGenerate.setName(jpInverter.getName());

                                    tdHYGFInverterMonthGenerate.setFullhour(jpInverter.getDayPowerGeneration() / jpInverter.getCapacity());
                                    //新加
                                    if(jpStation!=null){
                                        tdHYGFInverterMonthGenerate.setAmosCompanyCode(jpStation.getAmosCompanyCode());
                                        tdHYGFInverterMonthGenerate.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
                                        tdHYGFInverterMonthGenerate.setStationName(jpStation.getName());
                                        tdHYGFInverterMonthGenerate.setStationState(jpStation.getState());

                                    }

                                    if (ObjectUtils.isEmpty(tdHYGFInverterMonthGenerate.getCreatedTime())) {
                                        tdHYGFInverterMonthGenerate.setCreatedTime(System.currentTimeMillis());
                                        tdHYGFInverterMonthGenerateMapper.insert(tdHYGFInverterMonthGenerate);
                                    } else {
                                        tdHYGFInverterMonthGenerateMapper.insert(tdHYGFInverterMonthGenerate);
                                    }
                                    //户用场站年发电量
                                    TdHYGFInverterYearGenerate tdHYGFInverterYearGenerate = tdHYGFInverterYearGenerateMapper.selectOne(new QueryWrapper<TdHYGFInverterYearGenerate>()
                                            .eq("third_station_id", jpInverter.getThirdStationId())
                                            .eq("sn_code", jpInverter.getSnCode())
                                            .eq("month_time", DateUtil.format(today1, "yyyy-MM"))
                                            .eq("year", DateUtil.format(today1, "yyyy")));
                                    if (ObjectUtils.isEmpty(tdHYGFInverterYearGenerate)) {
                                        tdHYGFInverterYearGenerate = new TdHYGFInverterYearGenerate();
                                    }
                                    tdHYGFInverterYearGenerate.setThirdStationId(jpInverter.getThirdStationId());
                                    tdHYGFInverterYearGenerate.setSnCode(jpInverter.getSnCode().trim());
                                    tdHYGFInverterYearGenerate.setMonthTime(DateUtil.format(today1, "yyyy-MM"));
                                    tdHYGFInverterYearGenerate.setYear(DateUtil.format(today1, "yyyy"));
                                    tdHYGFInverterYearGenerate.setGenerate(jpInverter.getMonthPowerGeneration());
                                    tdHYGFInverterYearGenerate.setName(jpInverter.getName());

                                    tdHYGFInverterYearGenerate.setFullhour(jpInverter.getMonthPowerGeneration() / jpInverter.getCapacity());

                                    //新加
                                    if(jpStation!=null){
                                        tdHYGFInverterYearGenerate.setAmosCompanyCode(jpStation.getAmosCompanyCode());
                                        tdHYGFInverterYearGenerate.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
                                        tdHYGFInverterYearGenerate.setStationName(jpStation.getName());
                                        tdHYGFInverterYearGenerate.setStationState(jpStation.getState());

                                    }


                                    if (ObjectUtils.isEmpty(tdHYGFInverterYearGenerate.getCreatedTime())) {
                                        tdHYGFInverterYearGenerate.setCreatedTime(System.currentTimeMillis());
                                        tdHYGFInverterYearGenerateMapper.insert(tdHYGFInverterYearGenerate);
                                    } else {
                                        tdHYGFInverterYearGenerateMapper.insert(tdHYGFInverterYearGenerate);
                                    }
                                    //户用场站年发电量
                                    TdHYGFInverterTotalGenerate tdHYGFInverterTotalGenerate = tdHYGFInverterTotalGenerateMapper.selectOne(new QueryWrapper<TdHYGFInverterTotalGenerate>()
                                            .eq("third_station_id", jpInverter.getThirdStationId())
                                            .eq("sn_code", jpInverter.getSnCode())
                                            .eq("year_time", DateUtil.format(today1, "yyyy"))
                                            .eq("year", DateUtil.format(today1, "yyyy")));
                                    if (ObjectUtils.isEmpty(tdHYGFInverterTotalGenerate)) {
                                        tdHYGFInverterTotalGenerate = new TdHYGFInverterTotalGenerate();
                                    }
                                    tdHYGFInverterTotalGenerate.setThirdStationId(jpInverter.getThirdStationId());
                                    tdHYGFInverterTotalGenerate.setSnCode(jpInverter.getSnCode().trim());
                                    tdHYGFInverterTotalGenerate.setYearTime(DateUtil.format(today1, "yyyy"));
                                    tdHYGFInverterTotalGenerate.setYear(DateUtil.format(today1, "yyyy"));
                                    tdHYGFInverterTotalGenerate.setGenerate(jpInverter.getYearPowerGeneration());
                                    tdHYGFInverterTotalGenerate.setFullhour(0.0d);
                                    tdHYGFInverterTotalGenerate.setName(jpInverter.getName());
                                    //新加
                                    if(jpStation!=null){
                                        tdHYGFInverterTotalGenerate.setAmosCompanyCode(jpStation.getAmosCompanyCode());
                                        tdHYGFInverterTotalGenerate.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
                                        tdHYGFInverterTotalGenerate.setStationName(jpStation.getName());
                                        tdHYGFInverterTotalGenerate.setStationState(jpStation.getState());

                                    }
                                    tdHYGFInverterTotalGenerate.setFullhour(jpInverter.getYearPowerGeneration() / jpInverter.getCapacity());
                                    if (ObjectUtils.isEmpty(tdHYGFInverterTotalGenerate.getCreatedTime())) {
                                        tdHYGFInverterTotalGenerate.setCreatedTime(System.currentTimeMillis());
                                        tdHYGFInverterTotalGenerateMapper.insert(tdHYGFInverterTotalGenerate);
                                    } else {
                                        tdHYGFInverterTotalGenerateMapper.insert(tdHYGFInverterTotalGenerate);
                                    }
                                });
                            }


                        }


                    }


//                    if (!CollectionUtils.isEmpty(result)) {
//                        result.forEach(ksolarStationCollectData -> {
//                            JpInverter jpInverter = jpInverterMapper.selectOne(new QueryWrapper<JpInverter>().
//                                    eq("third_station_id", ksolarStationCollectList.getThirdStationId()).
//                                    eq("third_code", PVProducerInfoEnum.KSOLAR.getCode()).
//                                    eq("sn_code", ksolarStationCollectData.getInverterId()));
//                            if (ObjectUtils.isEmpty(jpInverter)) {
//                                jpInverter = new JpInverter();
//                            }
//
//                            // 品牌
////                        jpInverter.setBrand(inverterDetailDto.getName());
//                            // 国标
////                        jpInverter.setNationalStandard(inverterDetailDto.getNationalStandards());
//                            // 满发小时数
////                        jpInverter.setGenerationHours(String.valueOf(inverterDetailDto.getFullHour()));
//                            // 装机容量
//                            // jpInverter.setCapacity();
//                            if(jpCollectorlist!=null&&jpCollectorlist.size()>0){
//                                for (JpCollector jpCollector : jpCollectorlist) {
//                                    if(jpCollector.getSnCode().equals(ksolarStationCollectList.getCollectId())){
//                                        jpInverter.setCapacity( KSolarConstant.Capacity.get(StringUtils.lowerCase(jpCollector.getName())));
//                                    }
//                                }
//                            }
//                            jpInverter.setSnCode(ksolarStationCollectData.getInverterId());
//                            jpInverter.setId(ksolarStationCollectData.getInverterId());
//                            jpInverter.setState(KSolarConstant.stationStaus.get(ksolarStationCollectData.getStatus()));
//                            jpInverter.setCollectorId(ksolarStationCollectList.getCollectId());
//                            jpInverter.setCollectorSnCode(ksolarStationCollectList.getCollectId());
//                            jpInverter.setUpdateTime(new Date());
//
//                            jpInverter.setCurrentPower(ksolarStationCollectData.getPowerApparent()!=null?ksolarStationCollectData.getPowerApparent()/1000:0.0);
//                            jpInverter.setDayPowerGeneration(ksolarStationCollectData.getDayGeneration());
//                            jpInverter.setMonthPowerGeneration(ksolarStationCollectData.getMonthGeneration());
//                            jpInverter.setYearPowerGeneration(ksolarStationCollectData.getYearGeneration());
//                            jpInverter.setTotalPowerGeneration(ksolarStationCollectData.getTotalGeneration());
//                            jpInverter.setModel(ksolarStationCollectData.getDeviceModel());
//                            jpInverter.setVersion(ksolarStationCollectData.getVersion());
//                            jpInverter.setThirdStationId(ksolarStationCollectList.getThirdStationId());
//                            jpInverter.setThirdCode(PVProducerInfoEnum.KSOLAR.getCode());
//                            jpInverter.setStationName(ksolarStationCollectList.getStationName());
//                            jpInverter.setAddr(ksolarStationCollectList.getAddress());
//                            if (!ObjectUtils.isEmpty(jpInverter.getSequenceNbr())) {
//                                jpInverterMapper.updateById(jpInverter);
//                            } else {
//                                jpInverterMapper.insert(jpInverter);
//                            }
//
//
//                            String jsonString = JSON.toJSONString(ksolarStationCollectData);
//                            Map<String, Object> hanlderResult = JSON.parseObject(jsonString, Map.class);
//
//                            for (int k1 = 1; k1 < 13; k1++) {
//                                JpInverterElectricity jpInverterElectricity = jpInverterElectricityMapper.selectOne(new QueryWrapper<JpInverterElectricity>().
//                                        eq("sn_code", ksolarStationCollectData.getInverterId()).
//                                        eq("type", "直流").
//                                        eq("name", "PV" + k1)
//                                );
//                                if (ObjectUtils.isEmpty(jpInverterElectricity)) {
//                                    jpInverterElectricity = new JpInverterElectricity();
//                                }
//                                jpInverterElectricity.setInverterId(ksolarStationCollectData.getInverterId());
//                                jpInverterElectricity.setSnCode(ksolarStationCollectData.getInverterId());
//                                jpInverterElectricity.setThirdCode(PVProducerInfoEnum.KSOLAR.getCode());
//                                jpInverterElectricity.setThirdStationId(ksolarStationCollectList.getThirdStationId());
//                                jpInverterElectricity.setType("直流");
//                                jpInverterElectricity.setName("PV" + k1);
//                                jpInverterElectricity.setVoltage(Double.valueOf(hanlderResult.get("voltagePv" + k1).toString()));
//                                jpInverterElectricity.setCurrent(Double.valueOf(hanlderResult.get("currentPv" + k1).toString()));
//                                jpInverterElectricity.setPower(Double.valueOf(hanlderResult.get("powerPv" + k1).toString()));
//                                if (ObjectUtils.isEmpty(jpInverterElectricity.getSequenceNbr())) {
//                                    jpInverterElectricityMapper.insert(jpInverterElectricity);
//                                } else {
//                                    jpInverterElectricityMapper.updateById(jpInverterElectricity);
//                                }
//                            }
//
//                            JpInverterElectricity jpInverterElectricityR = jpInverterElectricityMapper.selectOne(new QueryWrapper<JpInverterElectricity>().
//                                    eq("sn_code", ksolarStationCollectData.getInverterId()).
//                                    eq("type", "交流").
//                                    eq("name", "RS")
//                            );
//                            if (ObjectUtils.isEmpty(jpInverterElectricityR)) {
//                                jpInverterElectricityR = new JpInverterElectricity();
//                            }
//                            jpInverterElectricityR.setInverterId(ksolarStationCollectData.getInverterId());
//                            jpInverterElectricityR.setSnCode(ksolarStationCollectData.getInverterId());
//                            jpInverterElectricityR.setThirdCode(PVProducerInfoEnum.KSOLAR.getCode());
//                            jpInverterElectricityR.setThirdStationId(ksolarStationCollectList.getThirdStationId());
//                            jpInverterElectricityR.setFrequency(ksolarStationCollectData.getFrequencyRs());
//                            jpInverterElectricityR.setType("交流");
//                            jpInverterElectricityR.setName("RS");
//                            jpInverterElectricityR.setVoltage(ksolarStationCollectData.getVoltageRs());
//                            jpInverterElectricityR.setCurrent(ksolarStationCollectData.getCurrentR());
//                            if (ObjectUtils.isEmpty(jpInverterElectricityR.getSequenceNbr())) {
//                                jpInverterElectricityMapper.insert(jpInverterElectricityR);
//                            } else {
//                                jpInverterElectricityMapper.updateById(jpInverterElectricityR);
//                            }
//
//                            JpInverterElectricity jpInverterElectricityS = jpInverterElectricityMapper.selectOne(new QueryWrapper<JpInverterElectricity>().
//                                    eq("sn_code", ksolarStationCollectData.getInverterId()).
//                                    eq("type", "交流").
//                                    eq("name", "ST")
//                            );
//                            if (ObjectUtils.isEmpty(jpInverterElectricityS)) {
//                                jpInverterElectricityS = new JpInverterElectricity();
//                            }
//                            jpInverterElectricityS.setInverterId(ksolarStationCollectData.getInverterId());
//                            jpInverterElectricityS.setSnCode(ksolarStationCollectData.getInverterId());
//                            jpInverterElectricityS.setThirdCode(PVProducerInfoEnum.KSOLAR.getCode());
//                            jpInverterElectricityS.setThirdStationId(ksolarStationCollectList.getThirdStationId());
//                            jpInverterElectricityS.setType("交流");
//                            jpInverterElectricityS.setName("ST");
//                            jpInverterElectricityS.setVoltage(ksolarStationCollectData.getVoltageSt());
//                            jpInverterElectricityS.setCurrent(ksolarStationCollectData.getCurrents());
//                            if (ObjectUtils.isEmpty(jpInverterElectricityS.getSequenceNbr())) {
//                                jpInverterElectricityMapper.insert(jpInverterElectricityS);
//                            } else {
//                                jpInverterElectricityMapper.updateById(jpInverterElectricityS);
//                            }
//
//
//                            JpInverterElectricity jpInverterElectricityT = jpInverterElectricityMapper.selectOne(new QueryWrapper<JpInverterElectricity>().
//                                    eq("sn_code", ksolarStationCollectData.getInverterId()).
//                                    eq("type", "交流").
//                                    eq("name", "TR")
//                            );
//                            if (ObjectUtils.isEmpty(jpInverterElectricityT)) {
//                                jpInverterElectricityT = new JpInverterElectricity();
//                            }
//                            jpInverterElectricityT.setInverterId(ksolarStationCollectData.getInverterId());
//                            jpInverterElectricityT.setSnCode(ksolarStationCollectData.getInverterId());
//                            jpInverterElectricityT.setThirdCode(PVProducerInfoEnum.KSOLAR.getCode());
//                            jpInverterElectricityT.setThirdStationId(ksolarStationCollectList.getThirdStationId());
//                            jpInverterElectricityT.setType("交流");
//                            jpInverterElectricityT.setName("TR");
//                            jpInverterElectricityT.setVoltage(ksolarStationCollectData.getVoltageTr());
//                            jpInverterElectricityT.setCurrent(ksolarStationCollectData.getCurrentT());
//                            if (ObjectUtils.isEmpty(jpInverterElectricityT.getSequenceNbr())) {
//                                jpInverterElectricityMapper.insert(jpInverterElectricityT);
//                            } else {
//                                jpInverterElectricityMapper.updateById(jpInverterElectricityT);
//                            }
//
////
//                            HYGFJPInverterElecHistory hygfjpInverterElecHistory = new HYGFJPInverterElecHistory();
//                            hygfjpInverterElecHistory.setThirdStationId(ksolarStationCollectList.getThirdStationId());
//                            hygfjpInverterElecHistory.setCreatedTime(System.currentTimeMillis());
//                            hygfjpInverterElecHistory.setSnCode(ksolarStationCollectData.getInverterId());
//
//                            hygfjpInverterElecHistory.setUAcCurrent(ksolarStationCollectData.getCurrentR());
//                            hygfjpInverterElecHistory.setVAcCurrent(ksolarStationCollectData.getCurrents());
//                            hygfjpInverterElecHistory.setWAcCurrent(ksolarStationCollectData.getCurrentT());
//                            hygfjpInverterElecHistory.setUAcVoltage(ksolarStationCollectData.getVoltageRs());
//                            hygfjpInverterElecHistory.setVAcVoltage(ksolarStationCollectData.getVoltageSt());
//                            hygfjpInverterElecHistory.setWAcVoltage(ksolarStationCollectData.getVoltageTr());
//                            hygfjpInverterElecHistory.setThirdCode(PVProducerInfoEnum.KSOLAR.getCode());
//                            hygfjpInverterElecHistory.setTime(System.currentTimeMillis());
//                            hygfjpInverterElecHistoryMapper.insert(hygfjpInverterElecHistory);
//
//                            // 逆变器历史
//                            String today = DateUtil.today();
//                            HYGFJPInverterHistory hygfjpInverterHistory = hygfjpInverterHistoryMapper.selectOne(
//                                    new QueryWrapper<HYGFJPInverterHistory>().eq("sn_code", ksolarStationCollectData.getInverterId()).eq("date", today));
//                            if (ObjectUtils.isEmpty(hygfjpInverterHistory)) {
//                                hygfjpInverterHistory = new HYGFJPInverterHistory();
//                            }
//
//                            // 满发小时数
////                        hygfjpInverterHistory.setGenerationHours(inverterDetailDto.getFullHour());
//                            hygfjpInverterHistory.setDate(today);
//                            hygfjpInverterHistory.setThirdStationId(ksolarStationCollectList.getThirdStationId());
//                            hygfjpInverterHistory.setInverterId(ksolarStationCollectData.getInverterId());
//                            hygfjpInverterHistory.setSnCode(ksolarStationCollectData.getInverterId());
//                            hygfjpInverterHistory.setThirdCode(PVProducerInfoEnum.KSOLAR.getCode());
//                            hygfjpInverterHistory.setPowerGeneration(ksolarStationCollectData.getTotalGeneration());
//                            if (ObjectUtils.isEmpty(hygfjpInverterHistory.getCreatedTime())) {
//                                hygfjpInverterHistory.setCreatedTime(System.currentTimeMillis());
//                                hygfjpInverterHistoryMapper.insert(hygfjpInverterHistory);
//                            } else {
//                                hygfjpInverterHistoryMapper.insert(hygfjpInverterHistory);
//                            }
//                        });
//                    }
                }
            });
        }
        // 实时告警
//        try {
//            inverAlramInfo();
//        } catch (ParseException e) {
//            e.printStackTrace();
//        }
    }

    @Override
    public void inverterList() {

    }

    @Override
    public void inverterDetail() {
    }


    @Scheduled(cron = "${dataRequstScheduled.keshida}")
    @Override
    public void inverAlramInfo() {
        try {
            TimeUnit.SECONDS.sleep(1);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }


        List<JpInverter> ksdInverterList = jpInverterMapper.selectList(new QueryWrapper<JpInverter>().
                eq("third_code", PVProducerInfoEnum.KSOLAR.getCode()));
        ksdInverterList = ksdInverterList.stream().filter(jpInverter -> !ObjectUtils.isEmpty(jpInverter.getSnCode())).collect(Collectors.toList());

        Map<String, String> ksdInverterListMap = new HashMap<>();
        ksdInverterList.forEach(jpInverter -> {
            ksdInverterListMap.put(jpInverter.getCollectorId(), jpInverter.getSnCode().trim());
        });
//        ksdInverterList.stream().filter(jpInverter -> !ObjectUtils.isEmpty(jpInverter.getCollectorSnCode())).collect(Collectors.toMap(JpInverter::getCollectorId,JpInverter::getCollectorSnCode));

        HashMap<String, Object> requestInfo = new HashMap<>(1);
        String requestParaminfo = JSON.toJSONString(requestInfo);
        String url = KSolarConstant.stationCollectAlarmUrl + "?pageNumber=1&pageSize=200";
        List<KsolarAlarmDto> result = kSolarRequestUtil.getResPonse(
                url,
                KSolarConstant.requestGET,
                requestParaminfo,
                KSolarConstant.resovle_rows,
                KsolarAlarmDto.class
        );
        if (!CollectionUtils.isEmpty(result)) {
            for (KsolarAlarmDto ksolarAlarmDto : result) {
                if (!ObjectUtils.isEmpty(ksolarAlarmDto.getInverterId())) {
//                    String startTime = ksolarAlarmDto.getSaveTime();
//                    String recoverTime = ksolarAlarmDto.getRemoveTime();
//                    String pattern = "yyyy-MM-dd HH:mm:ss";
//                    SimpleDateFormat sdf = new SimpleDateFormat(pattern);
//                    Date startTimeL = sdf.parse(startTime);
//                    Date recoverTimeL = sdf.parse(recoverTime);

                    String snCode = ksdInverterListMap.get(ksolarAlarmDto.getDeviceId());
                    if (ObjectUtils.isEmpty(snCode)) {
                        continue;
                    }
                    List<HYGFJPInverterWarn> list = hygfjpInverterWarnMapper.selectList(new QueryWrapper<HYGFJPInverterWarn>()
                            .eq("sn_code", snCode)
                            .eq("start_time", DateUtil.parse(ksolarAlarmDto.getSaveTime(), DatePattern.NORM_DATETIME_PATTERN).getTime())
                            .eq("third_code", PVProducerInfoEnum.KSOLAR.getCode())
                            .eq("third_station_id", ksolarAlarmDto.getStationId())
                    );
                    HYGFJPInverterWarn hygfjpInverterWarn = new HYGFJPInverterWarn();
                    if (!ObjectUtils.isEmpty(list)) {
                        hygfjpInverterWarn = list.get(0);
                    }

                    hygfjpInverterWarn.setTime(System.currentTimeMillis());
                    hygfjpInverterWarn.setSnCode(snCode);
                    hygfjpInverterWarn.setThirdStationId(ksolarAlarmDto.getStationId());
                    hygfjpInverterWarn.setLevel(KSolarConstant.alarmLevel.get(ksolarAlarmDto.getLevels()));
                    hygfjpInverterWarn.setContent(ksolarAlarmDto.getMessage());
                    hygfjpInverterWarn.setThirdCode(PVProducerInfoEnum.KSOLAR.getCode());
                    hygfjpInverterWarn.setTreatment(ksolarAlarmDto.getSolution());
                    hygfjpInverterWarn.setStartTime(DateUtil.parse(ksolarAlarmDto.getSaveTime(), DatePattern.NORM_DATETIME_PATTERN).getTime());
                    hygfjpInverterWarn.setState(KSolarConstant.alarmstatus.get(ksolarAlarmDto.getStatus()));
                    hygfjpInverterWarn.setTimeLong(null);
                    hygfjpInverterWarn.setRecoverTime(null);



                    //电站区域经销商，
                    JpStation jpStation = jpStationMapper.selectOne(new QueryWrapper<JpStation>().
                            eq("third_code", PVProducerInfoEnum.KSOLAR.getCode()).
                            eq("third_station_id", ksolarAlarmDto.getStationId()));

                    if(jpStation!=null){
                        hygfjpInverterWarn.setAmosCompanyCode(jpStation.getAmosCompanyCode());
                        hygfjpInverterWarn.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
                        hygfjpInverterWarn.setStationName(jpStation.getName());
                        hygfjpInverterWarn.setStationState(jpStation.getState());

                    }



                    if (StringUtils.isNotBlank(ksolarAlarmDto.getRemoveTime())) {
                        hygfjpInverterWarn.setRecoverTime(DateUtil.parse(ksolarAlarmDto.getRemoveTime(), DatePattern.NORM_DATETIME_PATTERN).getTime());
                    }
                    if (!ObjectUtils.isEmpty(ksolarAlarmDto.getSaveTime()) && !ObjectUtils.isEmpty(ksolarAlarmDto.getRemoveTime())) {
                        hygfjpInverterWarn.setTimeLong(hygfjpInverterWarn.getRecoverTime() - hygfjpInverterWarn.getStartTime());
                    }
                    if (ObjectUtils.isEmpty(hygfjpInverterWarn.getCreatedTime())) {
                        hygfjpInverterWarn.setCreatedTime(System.currentTimeMillis());
                        hygfjpInverterWarnMapper.insert(hygfjpInverterWarn);
                    } else {
                        hygfjpInverterWarnMapper.insert(hygfjpInverterWarn);
                    }
                }

            }
        }
    }
}
