package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import com.yeejoin.amos.boot.module.hygf.api.entity.MaintenanceTraining;
import com.yeejoin.amos.boot.module.hygf.api.mapper.MaintenanceTrainingMapper;
import com.yeejoin.amos.boot.module.hygf.api.service.IMaintenanceTrainingService;
import com.yeejoin.amos.boot.module.hygf.api.dto.MaintenanceTrainingDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;
import java.util.Map;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2024-03-11
 */
@Service
public class MaintenanceTrainingServiceImpl extends BaseService<MaintenanceTrainingDto,MaintenanceTraining,MaintenanceTrainingMapper> implements IMaintenanceTrainingService {

    @Autowired
    MaintenanceServiceImpl maintenanceService;
    /**
     * 分页查询
     */
    public Page<MaintenanceTrainingDto> queryForMaintenanceTrainingPage(Page<MaintenanceTrainingDto> page)   {


        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<MaintenanceTrainingDto> queryForMaintenanceTrainingList()   {
        return this.queryForList("" , false);
    }



     @Transactional
    public void selectTrainingStatus(MaintenanceTrainingDto model,String userId){

        model = this.createWithModel(model);
        //查询培训科目总数及当前已学习总数
        Map<String, Long> map = this.getBaseMapper().selectTrainingStatus(userId);
        Long total = map.get("total");
        Long num = map.get("num");
        //如果相减是0 即已学习完 反之为学习完
        if ((total - num) == 0){
            //如果是true 则已学习完 需修改运维人员的培训状态为完成 当为完成时  运维方可进行工单业务
         maintenanceService.updateTraining(model.getUserId());

        }

    }
}