package com.yeejoin.amos.boot.module.jxiop.biz.ESDto;

import io.github.classgraph.json.Id;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.util.Date;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/8/8
 */

@Data
@Accessors(chain = true)
@Document(indexName = "jxiop_equipments")
public class ESEquipments {
    @Id
    private String  id;

    @Field(type = FieldType.Text, index = false)
    private String  address;
    @Field(type = FieldType.Text)
    private String  dataType;
    @Field(type = FieldType.Text)
    private String  equipmentSpecificName;
    @Field(type = FieldType.Keyword)
    private String  gatewayId;
    @Field(type = FieldType.Text)
    private String  isAlarm;
    @Field(type = FieldType.Date, format = DateFormat.basic_date_time, index = false)
    private Date createdTime;
    @Field(type = FieldType.Text , index = false)
    private String  unit;
    @Field(type = FieldType.Text)
    private String  value;
    @Field(type = FieldType.Float, index = false)
    private Float valueF ;
    @Field(type = FieldType.Text)
    private String  valueLabel;
    @Field(type = FieldType.Text , index = false)
    private String  traceId;
    @Field(type = FieldType.Keyword )
    private String  equipmentIndexName;
    @Field(type = FieldType.Keyword )
    private String  equipmentNumber;
    @Field(type = FieldType.Text)
    private String  frontModule;
    @Field(type = FieldType.Text)
    private String  systemType;
    @Field(type = FieldType.Text , index = false)
    private String  pictureName;
    @Field(type = FieldType.Text)
    private String  displayName;


    public ESEquipments(Float valueF, String id, String address, String dataType, String equipmentSpecificName, String gatewayId, String isAlarm, Date createdTime, String unit, String value, String valueLabel, String traceId, String equipmentIndexName, String equipmentNumber, String frontModule, String systemType, String pictureName, String displayName) {

        this.valueF = valueF;
        this.id = id;
        this.address = address;
        this.dataType = dataType;
        this.equipmentSpecificName = equipmentSpecificName;
        this.gatewayId = gatewayId;
        this.isAlarm = isAlarm;
        this.createdTime = createdTime;
        this.unit = unit;
        this.value = value;
        this.valueLabel = valueLabel;
        this.traceId = traceId;
        this.equipmentIndexName = equipmentIndexName;
        this.equipmentNumber = equipmentNumber;
        this.frontModule = frontModule;
        this.systemType = systemType;
        this.pictureName = pictureName;
        this.displayName = displayName;
    }


    public ESEquipments() {
    }
}
