package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 风险管控任务表
 *
 * @author duanwei
 * @date 2021-01-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_task_risk_control")
@ApiModel(value = "TaskRiskControl对象", description = "风险管控任务表")
public class TaskRiskControl extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "风险管控名称")
    private String name;

    @ApiModelProperty(value = "项目id")
    private Long projectId;

    @ApiModelProperty(value = "风险作业id")
    private Long riskWorkId;

    @ApiModelProperty(value = "计划开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startTime;

    @ApiModelProperty(value = "计划结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endTime;

    @ApiModelProperty(value = "提前启动时间")
    private Integer preStartTime;
    
    @ApiModelProperty(value = "任务完成时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date taskEndTime;

    @ApiModelProperty(value = "任务id")
    private Long taskId;

    @ApiModelProperty(value = "阶段")
    private Integer stage;

    @ApiModelProperty(value = "公司id")
    private Long companyId;
    
    @ApiModelProperty(value = "安全负责人id")
    private Long secPersonId;

    @ApiModelProperty(value = "是否考试")
    private Boolean isExam;

    @ApiModelProperty(value = "是否知识")
    private Boolean isKnowledge;

    @ApiModelProperty(value = "项目地址")
    private String projectAddress;

    @ApiModelProperty(value = "组织机构代码")
    private String orgCode;

    @ApiModelProperty(value = "进入风险区域累计人数")
    private Integer personCount;
    
    @ApiModelProperty(value = "技术负责人id")
    private Long techPersonId;
    
    @ApiModelProperty(value = "施工方案id")
    private Long constructDocumentId;
}
