package com.yeejoin.amos.boot.module.tzs.api.dto;

import java.util.Date;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 特种设备基本信息-施工信息Dto
 *
 * @author duanwei
 * @date 2022-07-26
 */
@Data
public class TzsJgConstructionInfoDto extends BaseDto {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "id")
	/**
	 * id
	 */
	private Long sequenceNbr;
	@ApiModelProperty(value = "设备唯一标识码")
	/**
	 * 设备唯一标识码
	 */
	private String sequenceCode;
	@ApiModelProperty(value = "监管系统唯一编码")
	/**
	 * 监管系统唯一编码
	 */
	private String superviseCode;
	@ApiModelProperty(value = "施工类型(安装、改造、移装)")
	/**
	 * 施工类型(安装、改造、移装)
	 */
	private String constructionType;
	@ApiModelProperty(value = "施工单位统一社会信用代码")
	/**
	 * 施工单位统一社会信用代码
	 */
	private String uscUnitCreditCode;
	@ApiModelProperty(value = "施工单位名称")
	/**
	 * 施工单位名称
	 */
	private String uscUnitName;
	@ApiModelProperty(value = "安装/改造/移装告知ID")
	/**
	 * 安装/改造/移装告知ID
	 */
	private String uscInformId;
	@ApiModelProperty(value = "施工时间")
	/**
	 * 施工时间
	 */
	private Date uscDate;
	
	private String uscDateStr;
	@ApiModelProperty(value = "同步时间")
	/**
	 * 同步时间
	 */
	private Date syncDate;
	@ApiModelProperty(value = "同步状态（0-新增   1-更新   2-删除）")
	/**
	 * 同步状态（0-新增 1-更新 2-删除）
	 */
	private Integer syncState;
	@ApiModelProperty(value = "对接公司编码")
	/**
	 * 对接公司编码
	 */
	private String appId;
	@ApiModelProperty(value = "创建时间")
	/**
	 * 创建时间
	 */
	private Date recDate;
	@ApiModelProperty(value = "操作人员")
	/**
	 * 操作人员
	 */
	private String recUserId;

}
